/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.elements.table.LayoutCell;
import org.eclipse.birt.report.model.api.elements.table.LayoutSlot;
import org.eclipse.birt.report.model.elements.Cell;

public class LayoutRow {
    private int rowId;
    private List cells;
    private LayoutSlot container = null;

    LayoutRow(LayoutSlot container, int rowId) {
        this.container = container;
        this.rowId = rowId;
        this.cells = new ArrayList();
    }

    public LayoutCell getLayoutCell(int colId) {
        if (colId < 0 || colId > this.cells.size() - 1) {
            return null;
        }
        return (LayoutCell)this.cells.get(colId);
    }

    protected LayoutCell getLayoutCell(CellHandle cell) {
        int i = 0;
        while (i < this.cells.size()) {
            LayoutCell layoutCell = (LayoutCell)this.cells.get(i);
            if (layoutCell.getContent() == cell.getElement()) {
                return layoutCell;
            }
            ++i;
        }
        return null;
    }

    protected void addCell(LayoutCell cell) {
        this.cells.add(cell);
    }

    protected List checkOverlappedLayoutCells(int colId, int colSpan) {
        ArrayList<LayoutCell> retValue = new ArrayList<LayoutCell>();
        int i = 0;
        while (i < colSpan) {
            LayoutCell cell = this.getLayoutCell(colId + i);
            if (cell.isUsed()) {
                retValue.add(cell);
            }
            ++i;
        }
        return retValue;
    }

    protected void fillCells(int cellId, int colId, int colSpan, int rowSpanOffset, Cell content, boolean isEffectualDrop) {
        int i = 0;
        while (i < colSpan) {
            this.cells.set(colId + i, new LayoutCell(this, cellId, content, rowSpanOffset, i, isEffectualDrop));
            ++i;
        }
    }

    protected void fillDropSpannedCells(int cellId, int colId, int colSpan, int rowSpanOffset, Cell content) {
        int i = 0;
        while (i < colSpan) {
            this.cells.set(colId + i, new LayoutCell(this, cellId, content, rowSpanOffset, i));
            ++i;
        }
    }

    protected int findCellColumnPos(Cell cell) {
        int i = 0;
        while (i < this.cells.size()) {
            LayoutCell tmpCell = (LayoutCell)this.cells.get(i);
            if (tmpCell.isUsed() && cell.equals(tmpCell.getContent())) {
                assert (tmpCell.isCellStartPosition());
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    protected int getColumnCount() {
        return this.cells.size();
    }

    protected int getOccupiedColumnCount() {
        int retCount = 0;
        int i = 0;
        while (i < this.cells.size()) {
            if (this.getLayoutCell(i).isUsed()) {
                ++retCount;
            }
            ++i;
        }
        return retCount;
    }

    public String getLayoutString() {
        if (this.cells.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.cells.size()) {
            LayoutCell cell = (LayoutCell)this.cells.get(i);
            sb.append(cell.getLayoutString());
            ++i;
        }
        sb.append("\r\n");
        return sb.toString();
    }

    public RowHandle getRow() {
        int rowCount = this.container.getRowCount();
        if (this.rowId + 1 > rowCount) {
            return null;
        }
        SlotHandle slot = this.container.getSlot();
        return (RowHandle)slot.get(this.rowId);
    }

    protected LayoutSlot getContainer() {
        return this.container;
    }

    public Iterator layoutCellsIterator() {
        return new ArrayList(this.cells).iterator();
    }

    public Iterator cellsIterator() {
        LinkedHashSet<CellHandle> retValue = new LinkedHashSet<CellHandle>();
        int i = 0;
        while (i < this.cells.size()) {
            LayoutCell cell = (LayoutCell)this.cells.get(i);
            if (cell.isUsed() && cell.isCellStartPosition()) {
                retValue.add(cell.getCell());
            }
            ++i;
        }
        return retValue.iterator();
    }

    protected int getRowPosn() {
        int i = 0;
        while (i < this.container.getRowCount()) {
            if (this.container.getLayoutRow(i) == this) {
                return i + 1;
            }
            ++i;
        }
        assert (false);
        return -1;
    }
}

