/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DefaultResourceLocator;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.command.LibraryChangeEvent;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.birt.report.model.api.core.IResourceChangeListener;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ModelResourceHandle;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.DefaultAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.parser.DesignReader;
import org.eclipse.birt.report.model.parser.GenericModuleReader;
import org.eclipse.birt.report.model.parser.LibraryReader;
import org.eclipse.birt.report.model.util.ModelUtil;

public class DesignSession {
    private static List defaultTOCStyleList = null;
    public static final String TOC_DEFAULT_VALUE = "templates/TOCDefaultValue.xml";
    protected String resourceFolder = null;
    protected IResourceLocator resourceLocator = new DefaultResourceLocator();
    protected static String resourcePath = null;
    protected IAbsoluteFontSizeValueProvider fontSizeProvider = DefaultAbsoluteFontSizeValueProvider.getInstance();
    protected List designs = new ArrayList();
    protected List libraries = new ArrayList();
    protected ULocale locale;
    protected ModelResourceHandle resources;
    private String units = "in";
    private int colorFormat = 3;
    private HashMap defaultValues = new HashMap();
    private List resourceChangeListeners = null;
    private static Boolean isTOCStyleInitialized = Boolean.FALSE;

    public DesignSession(ULocale theLocale) {
        this.locale = theLocale;
        if (this.locale == null) {
            this.locale = ULocale.getDefault();
        }
        this.activate();
    }

    public void activate() {
        ThreadResources.setLocale(this.locale);
    }

    public void suspend() {
        ThreadResources.setLocale(null);
    }

    public ReportDesign openDesign(String fileName) throws DesignFileException {
        return this.openDesign(fileName, (ModuleOption)null);
    }

    public ReportDesign openDesign(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        this.initializeOptions(options);
        ReportDesign design = DesignReader.getInstance().read(this, fileName, options);
        this.designs.add(design);
        return design;
    }

    private void initializeOptions(ModuleOption options) {
        if (options == null) {
            return;
        }
        if (this.resourceLocator == null) {
            this.resourceLocator = options.getResourceLocator();
        }
        if (this.locale == null) {
            this.locale = options.getLocale();
        }
        if (this.resourceFolder == null) {
            this.resourceFolder = options.getResourceFolder();
        }
    }

    public ReportDesign openDesign(String fileName, InputStream is) throws DesignFileException {
        return this.openDesign(fileName, is, null);
    }

    public ReportDesign openDesign(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        ReportDesign design = DesignReader.getInstance().read(this, fileName, is, options);
        this.designs.add(design);
        return design;
    }

    public ReportDesign openDesign(URL systemId, InputStream is) throws DesignFileException {
        return this.openDesign(systemId, is, null);
    }

    public ReportDesign openDesign(URL systemId, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        ReportDesign design = DesignReader.getInstance().read(this, systemId, is, options);
        this.designs.add(design);
        return design;
    }

    public Module openModule(String fileName, InputStream is) throws DesignFileException {
        return this.openModule(fileName, is, null);
    }

    public Module openModule(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        Module module = GenericModuleReader.getInstance().read(this, fileName, is, options);
        assert (module instanceof Library || module instanceof ReportDesign);
        if (module instanceof ReportDesign) {
            this.designs.add(module);
        } else {
            this.libraries.add(module);
        }
        return module;
    }

    public Module openModule(String fileName) throws DesignFileException {
        return this.openModule(fileName, (ModuleOption)null);
    }

    public Module openModule(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        this.initializeOptions(options);
        Module module = GenericModuleReader.getInstance().read(this, fileName, options);
        assert (module instanceof Library || module instanceof ReportDesign);
        if (module instanceof ReportDesign) {
            this.designs.add(module);
        } else {
            this.libraries.add(module);
        }
        return module;
    }

    public Library openLibrary(String fileName) throws DesignFileException {
        return this.openLibrary(fileName, (ModuleOption)null);
    }

    public Library openLibrary(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        this.initializeOptions(options);
        Library library = LibraryReader.getInstance().read(this, fileName, options);
        this.libraries.add(library);
        return library;
    }

    public Library openLibrary(String fileName, InputStream is) throws DesignFileException {
        return this.openLibrary(fileName, is, null);
    }

    public Library openLibrary(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        Library design = LibraryReader.getInstance().read(this, fileName, is, options);
        this.libraries.add(design);
        return design;
    }

    public Library openLibrary(URL systemId, InputStream is) throws DesignFileException {
        return this.openLibrary(systemId, is, null);
    }

    public Library openLibrary(URL systemId, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        Library library = LibraryReader.getInstance().read(this, systemId, is, options);
        this.libraries.add(library);
        return library;
    }

    public ReportDesign createDesign(String fileName, ModuleOption options) {
        URL systemId;
        ReportDesign design = new ReportDesign(this);
        design.setFileName(fileName);
        if (!StringUtil.isBlank(fileName) && (systemId = URIUtil.getDirectory(fileName)) != null) {
            design.setSystemId(systemId);
        }
        if (!this.isBlankCreation(options)) {
            this.addExtensionDefaultStyles(design);
        }
        design.setValid(true);
        this.designs.add(design);
        return design;
    }

    private boolean isBlankCreation(ModuleOption options) {
        if (options == null) {
            return false;
        }
        Boolean isSimpleCreation = (Boolean)options.getProperty("blankCreation");
        return isSimpleCreation != null && isSimpleCreation != false;
    }

    public Library createLibraryFromTemplate(String templateName) throws DesignFileException {
        Library library = this.openLibrary(templateName);
        library.setFileName(null);
        return library;
    }

    public ReportDesign createDesignFromTemplate(String templateName) throws DesignFileException {
        ReportDesign design = this.openDesign(templateName);
        design.setFileName(null);
        this.addExtensionDefaultStyles(design);
        return design;
    }

    private List findToAddExtensionDefaultStyle(ReportDesign design) {
        ArrayList<Style> retList = new ArrayList<Style>();
        List<Style> defaultStyles = MetaDataDictionary.getInstance().getExtensionFactoryStyles();
        int i = 0;
        while (i < defaultStyles.size()) {
            Style style = defaultStyles.get(i);
            assert (style.getName() != null);
            if (design.findStyle(style.getName()) == null) {
                retList.add(style);
            }
            ++i;
        }
        return retList;
    }

    private void addExtensionDefaultStyles(ReportDesign design) {
        List tmpStyles = this.findToAddExtensionDefaultStyle(design);
        int i = 0;
        while (i < tmpStyles.size()) {
            block4: {
                Style style = (Style)tmpStyles.get(i);
                Style tmpStyle = null;
                try {
                    tmpStyle = (Style)style.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    assert (false);
                    break block4;
                }
                design.add(tmpStyle, 0);
                tmpStyle.setID(design.getNextID());
                design.addElementID(tmpStyle);
                design.getNameHelper().getNameSpace(0).insert(tmpStyle);
            }
            ++i;
        }
    }

    public Library createLibrary() {
        Library library = new Library(this);
        Theme theme = new Theme(ModelMessages.getMessage("Theme.defaultThemeName"));
        library.setProperty("theme", (Object)new ElementRefValue(null, theme));
        ModelUtil.insertCompatibleThemeToLibrary(library, theme);
        theme.setID(library.getNextID());
        library.addElementID(theme);
        library.setValid(true);
        this.libraries.add(library);
        return library;
    }

    public Iterator getDesignIterator() {
        return this.designs.iterator();
    }

    public Iterator getLibraryIterator() {
        return this.libraries.iterator();
    }

    public Iterator getModuleIterator() {
        ArrayList roots = new ArrayList();
        roots.addAll(this.designs);
        roots.addAll(this.libraries);
        return roots.iterator();
    }

    public void drop(Module module) {
        if (module instanceof ReportDesign) {
            assert (this.designs.contains(module));
            this.designs.remove(module);
        } else if (module instanceof Library) {
            assert (this.libraries.contains(module));
            this.libraries.remove(module);
        }
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String newUnits) throws PropertyValueException {
        if (!("cm".equalsIgnoreCase(newUnits) || "in".equalsIgnoreCase(newUnits) || "mm".equalsIgnoreCase(newUnits) || "pc".equalsIgnoreCase(newUnits) || "pt".equalsIgnoreCase(newUnits))) {
            throw new PropertyValueException((Object)newUnits, "Error.PropertyValueException.INVALID_VALUE", 5);
        }
        this.units = newUnits;
    }

    public void setColorFormat(int format) throws PropertyValueException {
        if (format != 3 && format != 4 && format != 1 && format != 0 && format != 2) {
            throw new PropertyValueException(new Integer(format), "Error.PropertyValueException.INVALID_VALUE", 5);
        }
        this.colorFormat = format;
    }

    public int getColorFormat() {
        return this.colorFormat;
    }

    public void setDefaultValue(String propName, Object value) throws PropertyValueException {
        assert (!StringUtil.isBlank(propName));
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementPropertyDefn propDefn = dd.getStyle().getProperty(propName);
        assert (propDefn != null);
        if (value == null) {
            this.defaultValues.remove(propName);
        } else {
            Object actualValue = ((ElementPropertyDefn)propDefn).validateValue(null, value);
            this.defaultValues.put(propName, actualValue);
        }
    }

    public Object getDefaultValue(String propName) {
        assert (!StringUtil.isBlank(propName));
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementPropertyDefn propDefn = dd.getStyle().getProperty(propName);
        assert (propDefn != null);
        return this.defaultValues.get(propName);
    }

    public void setResourceLocator(IResourceLocator algorithm) {
        assert (algorithm != null);
        this.resourceLocator = algorithm;
    }

    public IResourceLocator getResourceLocator() {
        assert (this.resourceLocator != null);
        return this.resourceLocator;
    }

    public IAbsoluteFontSizeValueProvider getPredefinedFontSizeProvider() {
        return this.fontSizeProvider;
    }

    public void setPredefinedFontSizeProvider(IAbsoluteFontSizeValueProvider fontSizeProvider) {
        this.fontSizeProvider = fontSizeProvider;
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public void fireLibChange(LibraryChangeEvent ev) {
        URL url = ModelUtil.getURLPresentation(ev.getChangedResourcePath());
        if (url == null) {
            return;
        }
        String path = url.toExternalForm();
        Iterator iter = this.getModuleIterator();
        while (iter.hasNext()) {
            Module module = (Module)iter.next();
            if (!module.getLocation().equalsIgnoreCase(path) && module.getLibraryByLocation(path, Integer.MAX_VALUE) == null) continue;
            LibraryChangeEvent event = new LibraryChangeEvent(ev.getChangedResourcePath());
            event.setTarget(module);
            event.setDeliveryPath(ev.getDeliveryPath());
            module.broadcastResourceChangeEvent(event);
        }
        this.broadcastResourceChangeEvent(ev);
    }

    public void addResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            this.resourceChangeListeners = new ArrayList();
        }
        if (!this.resourceChangeListeners.contains(listener)) {
            this.resourceChangeListeners.add(listener);
        }
    }

    public boolean removeResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            return false;
        }
        return this.resourceChangeListeners.remove(listener);
    }

    public void broadcastResourceChangeEvent(ResourceChangeEvent event) {
        if (this.resourceChangeListeners == null || this.resourceChangeListeners.isEmpty()) {
            return;
        }
        ArrayList temp = new ArrayList(this.resourceChangeListeners);
        for (IResourceChangeListener listener : temp) {
            listener.resourceChanged(null, event);
        }
    }

    public void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    public String getResourceFolder() {
        if (this.resourceFolder == null) {
            return resourcePath;
        }
        return this.resourceFolder;
    }

    public static String getResourcePath() {
        return resourcePath;
    }

    public static void setResourcePath(String resourcePath) {
        DesignSession.resourcePath = resourcePath;
    }

    private void initDefaultTOCStyle() {
        defaultTOCStyleList = new ArrayList();
        URL url = new DefaultResourceLocator().findResource(null, TOC_DEFAULT_VALUE, 0);
        if (url == null) {
            return;
        }
        ReportDesign tocDesign = null;
        try {
            DesignSession session = new DesignSession(this.locale);
            tocDesign = session.openDesign(url, url.openStream());
            tocDesign.setReadOnly();
        }
        catch (DesignFileException designFileException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        ContainerSlot slot = tocDesign.getSlot(0);
        Iterator iterator = slot.iterator();
        while (iterator.hasNext()) {
            DesignElement tmpStyle = (DesignElement)iterator.next();
            StyleHandle styleHandle = (StyleHandle)tmpStyle.getHandle(tocDesign);
            defaultTOCStyleList.add(styleHandle);
        }
        isTOCStyleInitialized = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDefaultTOCStyleValue() {
        if (isTOCStyleInitialized.booleanValue()) {
            return Collections.unmodifiableList(defaultTOCStyleList);
        }
        Boolean bl = isTOCStyleInitialized;
        synchronized (bl) {
            if (!isTOCStyleInitialized.booleanValue()) {
                this.initDefaultTOCStyle();
            }
        }
        return Collections.unmodifiableList(defaultTOCStyleList);
    }

    public Module getOpenedModule(String location) {
        if (location == null) {
            return null;
        }
        ArrayList modules = new ArrayList();
        modules.addAll(this.designs);
        modules.addAll(this.libraries);
        int i = 0;
        while (i < modules.size()) {
            Module tmpModule = (Module)modules.get(i);
            if (location.equalsIgnoreCase(tmpModule.getLocation())) {
                return tmpModule;
            }
            ++i;
        }
        return null;
    }
}

