/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.extension.IEncryptionHelper;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.scripts.IScriptableObjectClassInfo;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.EncryptionHelperExtensionLoader;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionException;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaLogManager;
import org.eclipse.birt.report.model.metadata.PeerExtensionLoader;
import org.eclipse.birt.report.model.metadata.ScriptableObjectExtensionLoader;
import org.eclipse.birt.report.model.metadata.SimpleEncryptionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionManager {
    protected static ExtensionManager instance;
    private Map<String, IEncryptionHelper> encryptionHelperMap = new HashMap<String, IEncryptionHelper>();
    private String defaultEncryptionHelperID = "base64";
    private HashMap<String, IElementDefn> extensionNameMap = new HashMap();
    private IScriptableObjectClassInfo scriptableFactory = null;
    private Map<String, Style> extensionFactoryStyles = new HashMap<String, Style>();

    private ExtensionManager() {
    }

    void initialize() {
        assert (!MetaDataDictionary.getInstance().isEmpty());
        new EncryptionHelperExtensionLoader().load();
        new PeerExtensionLoader().load();
        new ScriptableObjectExtensionLoader().load();
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new ExtensionManager();
        }
    }

    public static ExtensionManager getInstance() {
        if (instance == null) {
            ExtensionManager.createInstance();
        }
        return instance;
    }

    void releaseInstance() {
        instance = null;
    }

    public IElementDefn getElement(String name) {
        return this.extensionNameMap.get(name);
    }

    public List<IElementDefn> getExtensions() {
        return new ArrayList<IElementDefn>(this.extensionNameMap.values());
    }

    void addExtension(ExtensionElementDefn extDefn) throws MetaDataException {
        assert (extDefn != null);
        String elementName = extDefn.getName();
        if (StringUtil.isBlank(elementName)) {
            throw new MetaDataException("MISSING_EXTENSION_NAME");
        }
        if (MetaDataDictionary.getInstance().getElement(elementName) != null) {
            throw new MetaDataException(new String[]{elementName}, "DUPLICATE_EXTENSION_NAME");
        }
        this.extensionNameMap.put(elementName, extDefn);
    }

    public IEncryptionHelper getEncryptionHelper(String id) {
        if (id == null) {
            return null;
        }
        if ("base64".equals(id)) {
            return SimpleEncryptionHelper.getInstance();
        }
        return this.encryptionHelperMap.get(id);
    }

    public List<IEncryptionHelper> getEncryptionHelpers() {
        ArrayList<IEncryptionHelper> encryptions = new ArrayList<IEncryptionHelper>();
        encryptions.add(SimpleEncryptionHelper.getInstance());
        if (this.encryptionHelperMap != null) {
            encryptions.addAll(this.encryptionHelperMap.values());
        }
        return encryptions;
    }

    public IEncryptionHelper getDefaultEncryptionHelper() {
        return this.getEncryptionHelper(this.defaultEncryptionHelperID);
    }

    public String getDefaultEncryptionHelperID() {
        return this.defaultEncryptionHelperID;
    }

    public void setDefaultEncryptionHelper(String encryptionID) {
        if (this.getEncryptionHelper(encryptionID) != null) {
            this.defaultEncryptionHelperID = encryptionID;
        }
    }

    void addEncryptionHelper(String id, IEncryptionHelper encryptionHelper) throws MetaDataException {
        assert (id != null);
        assert (encryptionHelper != null);
        if (this.getEncryptionHelper(id) != null) {
            throw new ExtensionException(new String[]{id}, "ENCYRPTION_EXTENSION_EXISTS");
        }
        this.encryptionHelperMap.put(id, encryptionHelper);
    }

    public IScriptableObjectClassInfo getScriptableFactory() {
        return this.scriptableFactory;
    }

    void setScriptableFactory(IScriptableObjectClassInfo scriptableFactory) {
        this.scriptableFactory = scriptableFactory;
    }

    public List<Style> getExtensionFactoryStyles() {
        if (this.extensionFactoryStyles != null) {
            return new ArrayList<Style>(this.extensionFactoryStyles.values());
        }
        return Collections.emptyList();
    }

    void addExtensionFactoryStyle(Style style) {
        if (this.extensionFactoryStyles == null) {
            this.extensionFactoryStyles = new HashMap<String, Style>();
        }
        if (this.extensionFactoryStyles.containsKey(style.getName())) {
            MetaLogManager.log("the extension predefined style has duplicated name, will be ignored.");
        } else {
            this.extensionFactoryStyles.put(style.getName(), style);
        }
    }
}

