/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.validators.AbstractSemanticValidator;

public class SemanticTriggerDefnSet {
    protected List triggerList = null;

    void add(SemanticTriggerDefn validatorDefn) {
        if (this.triggerList == null) {
            this.triggerList = new ArrayList();
        }
        this.triggerList.add(validatorDefn);
    }

    public void add(SemanticTriggerDefnSet triggers) {
        if (triggers != null && triggers.triggerList != null) {
            for (SemanticTriggerDefn trigger : triggers.triggerList) {
                this.add(trigger);
            }
        }
    }

    public List getTriggerList() {
        return this.triggerList;
    }

    public void build() throws MetaDataException {
        if (this.triggerList != null) {
            for (SemanticTriggerDefn validatorDefn : this.triggerList) {
                if (validatorDefn.getValidator() != null) continue;
                AbstractSemanticValidator validator = MetaDataDictionary.getInstance().getSemanticValidator(validatorDefn.getValidatorName());
                if (validator == null) {
                    throw new MetaDataException(new String[]{validatorDefn.getValidatorName()}, "VALIDATOR_NOT_FOUND");
                }
                validatorDefn.setValidator(validator);
            }
        }
    }

    boolean contain(String validatorName) {
        if (this.triggerList == null) {
            return false;
        }
        assert (validatorName != null);
        int i = 0;
        while (i < this.triggerList.size()) {
            SemanticTriggerDefn tmpDefn = (SemanticTriggerDefn)this.triggerList.get(i);
            if (validatorName.equalsIgnoreCase(tmpDefn.getValidatorName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

