/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;
import org.eclipse.birt.core.archive.compound.ArchiveView;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.archive.compound.IArchiveFileFactory;

public class ArchiveFileFactory
implements IArchiveFileFactory {
    public IArchiveFile createArchive(String archiveId) throws IOException {
        String fileName = this.getPhysicalFile(archiveId);
        return this.doCreateArchive(archiveId, fileName, "rw");
    }

    public IArchiveFile createTransientArchive(String archiveId) throws IOException {
        String fileName = this.getPhysicalFile(archiveId);
        return this.doCreateArchive(archiveId, fileName, "rwt");
    }

    private IArchiveFile doCreateArchive(String archiveId, String fileName, String mode) throws IOException {
        return new ArchiveFileV2(archiveId, fileName, mode);
    }

    public IArchiveFile createView(String viewId, IArchiveFile archive) throws IOException {
        String fileName = this.getPhysicalFile(viewId);
        return this.doCreateView(fileName, viewId, archive, "rw");
    }

    public IArchiveFile createTransientView(String viewId, IArchiveFile archive) throws IOException {
        String fileName = this.getPhysicalFile(viewId);
        return this.doCreateView(fileName, viewId, archive, "rwt");
    }

    private IArchiveFile doCreateView(String viewId, String fileName, IArchiveFile archive, String mode) throws IOException {
        ArchiveFileV2 view = new ArchiveFileV2(viewId, archive.getSystemId(), fileName, mode);
        return new ArchiveView(view, archive, true);
    }

    public IArchiveFile openArchive(String archiveId, String mode) throws IOException {
        String fileName = this.getPhysicalFile(archiveId);
        ArchiveFile file = new ArchiveFile(fileName, archiveId, mode);
        String dependId = file.getDependId();
        if (dependId != null && dependId.length() > 0) {
            IArchiveFile archive = this.openArchive(dependId, "r");
            return new ArchiveView(file, archive, false);
        }
        return file;
    }

    public IArchiveFile openView(String viewId, String mode, IArchiveFile archive) throws IOException {
        String fileName = this.getPhysicalFile(viewId);
        ArchiveFile view = new ArchiveFile(fileName, viewId, mode);
        return new ArchiveView(view, archive, true);
    }

    protected String getPhysicalFile(String systemId) {
        return systemId;
    }
}

