/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.withaxes.AxisSubUnit;
import org.eclipse.birt.chart.computation.withaxes.StackGroup;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StackedSeriesLookup {
    private final Hashtable<Axis, ArrayList<StackGroup>> htAxisToStackGroups = new Hashtable();
    private final Hashtable<Series, StackGroup> htSeriesToStackGroup = new Hashtable();
    private int iCachedUnitCount = 0;

    StackedSeriesLookup(RunTimeContext rtc) {
    }

    public final ArrayList<StackGroup> getStackGroups(Axis ax) {
        return this.htAxisToStackGroups.get(ax);
    }

    public final int getSeriesCount(Axis ax) {
        ArrayList<StackGroup> alSG = this.htAxisToStackGroups.get(ax);
        if (alSG == null || alSG.isEmpty()) {
            return 0;
        }
        int iCount = 0;
        int i = 0;
        while (i < alSG.size()) {
            StackGroup sg = alSG.get(i);
            iCount += sg.alSeries.size();
            ++i;
        }
        return iCount;
    }

    public final StackGroup getStackGroup(Series se) {
        return this.htSeriesToStackGroup.get(se);
    }

    public final AxisSubUnit getSubUnit(StackGroup sg, int iUnitIndex) {
        if (sg == null || !this.htSeriesToStackGroup.contains(sg)) {
            return null;
        }
        if (sg.alUnitPositions == null) {
            sg.alUnitPositions = new ArrayList(8);
        }
        if (sg.alUnitPositions.size() <= iUnitIndex) {
            sg.alUnitPositions.add(new AxisSubUnit(sg.bStackTogether));
        }
        return sg.alUnitPositions.get(iUnitIndex);
    }

    public final AxisSubUnit getUnit(Series se, int iUnitIndex) {
        StackGroup sg = this.htSeriesToStackGroup.get(se);
        return this.getSubUnit(sg, iUnitIndex);
    }

    public final void resetSubUnits() {
        Enumeration<StackGroup> e = this.htSeriesToStackGroup.elements();
        while (e.hasMoreElements()) {
            StackGroup sg = e.nextElement();
            if (sg.alUnitPositions == null) continue;
            int i = 0;
            while (i < sg.alUnitPositions.size()) {
                AxisSubUnit asu = sg.alUnitPositions.get(i);
                asu.reset();
                ++i;
            }
        }
    }

    static final StackedSeriesLookup create(ChartWithAxes cwa, RunTimeContext rtc) throws ChartException, IllegalArgumentException {
        if (cwa == null) {
            return null;
        }
        StackedSeriesLookup ssl = new StackedSeriesLookup(rtc);
        Axis axBase = cwa.getBaseAxes()[0];
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axBase, true);
        DataSetIterator dsi = null;
        int i = 0;
        while (i < axaOrthogonal.length) {
            StackGroup sg;
            int iSharedUnitIndex = 0;
            int iSharedUnitCount = 0;
            StackGroup sgSingle = null;
            EList el = axaOrthogonal[i].getSeriesDefinitions();
            ArrayList<StackGroup> alSGCopies = new ArrayList<StackGroup>(4);
            iSharedUnitCount = 0;
            int j = 0;
            while (j < el.size()) {
                int iDataSetCount;
                Series se;
                int k;
                SeriesDefinition sd = (SeriesDefinition)el.get(j);
                List alSeries = sd.getRunTimeSeries();
                int iSeriesCount = alSeries.size();
                if (iSeriesCount > 1) {
                    boolean bStackedSet = false;
                    sg = null;
                    k = 0;
                    while (k < iSeriesCount) {
                        se = (Series)alSeries.get(k);
                        dsi = new DataSetIterator(se.getDataSet());
                        iDataSetCount = dsi.size();
                        if (ssl.iCachedUnitCount == 0) {
                            ssl.iCachedUnitCount = iDataSetCount;
                        } else if (ssl.iCachedUnitCount != iDataSetCount) {
                            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.runtime.dataset.count.mismatch"), new Integer(ssl.iCachedUnitCount), new Integer(iDataSetCount)));
                        }
                        if (se.canBeStacked()) {
                            if (!se.isSetStacked()) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 13, "exception.unset.series.stacked.property", new Object[]{se}, Messages.getResourceBundle(rtc.getULocale()));
                            }
                            if (se.canShareAxisUnit()) {
                                if (se.isStacked()) {
                                    if (k > 0 && !bStackedSet) {
                                        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                                    }
                                    if (k == 0) {
                                        sg = new StackGroup(iSharedUnitIndex++);
                                        alSGCopies.add(sg);
                                        ++iSharedUnitCount;
                                    }
                                    bStackedSet = true;
                                    ssl.htSeriesToStackGroup.put(se, sg);
                                    sg.addSeries(se);
                                } else {
                                    if (k > 0 && bStackedSet) {
                                        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                                    }
                                    sg = new StackGroup(iSharedUnitIndex++);
                                    alSGCopies.add(sg);
                                    ++iSharedUnitCount;
                                    ssl.htSeriesToStackGroup.put(se, sg);
                                    sg.addSeries(se);
                                }
                            } else if (se.isStacked()) {
                                if (k > 0 && !bStackedSet) {
                                    throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                                }
                                if (k == 0) {
                                    sg = new StackGroup(-1);
                                    alSGCopies.add(sg);
                                }
                                bStackedSet = true;
                                ssl.htSeriesToStackGroup.put(se, sg);
                                sg.addSeries(se);
                            } else {
                                if (k > 0 && bStackedSet) {
                                    throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                                }
                                sg = new StackGroup(-1);
                                alSGCopies.add(sg);
                                ssl.htSeriesToStackGroup.put(se, sg);
                                sg.addSeries(se);
                            }
                        } else {
                            sg = new StackGroup(-1);
                            alSGCopies.add(sg);
                            ssl.htSeriesToStackGroup.put(se, sg);
                            sg.addSeries(se);
                        }
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < iSeriesCount) {
                        se = (Series)alSeries.get(k);
                        dsi = new DataSetIterator(se.getDataSet());
                        iDataSetCount = dsi.size();
                        if (ssl.iCachedUnitCount == 0) {
                            ssl.iCachedUnitCount = iDataSetCount;
                        } else if (ssl.iCachedUnitCount != iDataSetCount) {
                            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.runtime.dataset.count.mismatch"), new Integer(ssl.iCachedUnitCount), new Integer(iDataSetCount)));
                        }
                        if (se.canBeStacked()) {
                            if (se.canShareAxisUnit()) {
                                if (se.isStacked()) {
                                    if (sgSingle == null) {
                                        sgSingle = new StackGroup(iSharedUnitIndex++);
                                        alSGCopies.add(sgSingle);
                                        ++iSharedUnitCount;
                                    }
                                    ssl.htSeriesToStackGroup.put(se, sgSingle);
                                    sgSingle.addSeries(se);
                                } else {
                                    sg = new StackGroup(iSharedUnitIndex++);
                                    ++iSharedUnitCount;
                                    alSGCopies.add(sg);
                                    ssl.htSeriesToStackGroup.put(se, sg);
                                    sg.addSeries(se);
                                }
                            } else {
                                sg = new StackGroup(-1);
                                alSGCopies.add(sg);
                                ssl.htSeriesToStackGroup.put(se, sg);
                                sg.addSeries(se);
                            }
                        } else {
                            sg = new StackGroup(-1);
                            alSGCopies.add(sg);
                            ssl.htSeriesToStackGroup.put(se, sg);
                            sg.addSeries(se);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            if (iSharedUnitCount < 1) {
                iSharedUnitCount = 1;
            }
            j = 0;
            while (j < alSGCopies.size()) {
                sg = (StackGroup)alSGCopies.get(j);
                sg.updateCount(iSharedUnitCount);
                ++j;
            }
            ssl.htAxisToStackGroups.put(axaOrthogonal[i], alSGCopies);
            ++i;
        }
        return ssl;
    }

    public final int getUnitCount() {
        return this.iCachedUnitCount;
    }
}

