/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import com.ibm.icu.util.Calendar;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;

public class UserDataSetProcessor {
    public DataSet[] populate(Object oResultSetDef) throws ChartException {
        DataSet[] ds = new DataSet[]{};
        if (oResultSetDef instanceof IResultSetDataSet) {
            IResultSetDataSet rsds = (IResultSetDataSet)oResultSetDef;
            long lRowCount = rsds.getSize();
            if (lRowCount <= 0L) {
                throw new ChartException("org.eclipse.birt.chart.engine", 16, "exception.empty.dataset", Messages.getResourceBundle());
            }
            int columnCount = rsds.getColumnCount();
            ds = new DataSet[columnCount];
            int k = 0;
            while (k < columnCount) {
                switch (rsds.getDataType(k)) {
                    case 16: {
                        String[] saDataSet = new String[(int)lRowCount];
                        ds[k] = TextDataSetImpl.create(saDataSet);
                        break;
                    }
                    case 8: {
                        Calendar[] caDataSet = new Calendar[(int)lRowCount];
                        ds[k] = DateTimeDataSetImpl.create(caDataSet);
                        break;
                    }
                    case 1: {
                        Double[] doaDataSet = new Double[(int)lRowCount];
                        ds[k] = NumberDataSetImpl.create(doaDataSet);
                        break;
                    }
                    default: {
                        throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.unknown.trigger.datatype", Messages.getResourceBundle());
                    }
                }
                ++k;
            }
            int i = 0;
            while (rsds.hasNext()) {
                Object[] row = rsds.next();
                int k2 = 0;
                while (k2 < columnCount) {
                    Object value = null;
                    switch (rsds.getDataType(k2)) {
                        case 16: {
                            value = row[k2];
                            break;
                        }
                        case 8: {
                            value = Methods.asDateTime(row[k2]);
                            break;
                        }
                        case 1: {
                            value = Methods.asDouble(row[k2]);
                            break;
                        }
                        default: {
                            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.unknown.trigger.datatype", Messages.getResourceBundle());
                        }
                    }
                    ((Object[])ds[k2].getValues())[i] = value;
                    ++k2;
                }
                ++i;
            }
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.unknown.custom.dataset", Messages.getResourceBundle());
        }
        return ds;
    }
}

