/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryLocator;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.DataExtractionOption;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IDataExtractionOption;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ExtractionResults;
import org.eclipse.birt.report.engine.api.impl.IInternalReportDocument;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.api.impl.ResultSetItem;
import org.eclipse.birt.report.engine.api.impl.SubqueryResultMetaData;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.extension.IDataExtractionExtension;
import org.eclipse.birt.report.engine.extension.engine.IDataExtension;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataExtractionTaskV1
extends EngineTask
implements IDataExtractionTask {
    protected IReportDocument reportDocReader;
    protected Report report;
    protected InstanceID instanceId;
    protected String resultSetName;
    protected String[] selectedColumns;
    protected IExtractionResults currentResult = null;
    protected IFilterDefinition[] filterExpressions = null;
    protected ISortDefinition[] sortExpressions = null;
    protected int maxRows = -1;
    protected int startRow = 0;
    protected boolean distinct;
    protected boolean groupMode = true;
    protected boolean isMetaDataPrepared = false;
    protected HashMap rsetName2IdMapping = new HashMap();
    protected HashMap rsetId2queryIdMapping = new HashMap();
    protected HashMap queryId2NameMapping = new HashMap();
    protected HashMap queryId2QueryMapping = new HashMap();
    protected HashMap query2QueryIdMapping = new HashMap();
    protected HashMap rssetIdMapping = new HashMap();
    protected ArrayList resultMetaList = new ArrayList();
    protected static Logger logger = Logger.getLogger(DteDataEngine.class.getName());
    private HashMap tmpQuery2QueryIdMapping = new HashMap();

    public DataExtractionTaskV1(ReportEngine engine, IReportDocument reader) throws EngineException {
        super(engine, 4);
        IReportRunnable runnable = this.getOnPreparedRunnable(reader);
        this.setReportRunnable(runnable);
        IInternalReportDocument internalDoc = (IInternalReportDocument)reader;
        Report reportIR = internalDoc.getReportIR(this.executionContext.getDesign());
        this.executionContext.setReport(reportIR);
        this.report = this.executionContext.getReport();
        this.reportDocReader = reader;
        this.executionContext.setReportDocument(this.reportDocReader);
        this.executionContext.setFactoryMode(false);
        this.executionContext.setPresentationMode(true);
        this.setParameterValues(this.reportDocReader.getParameterValues());
        this.setParameterDisplayTexts(this.reportDocReader.getParameterDisplayTexts());
        this.usingParameterValues();
        this.executionContext.registerGlobalBeans(this.reportDocReader.getGlobalVariables(null));
        Map appContext = this.executionContext.getAppContext();
        IDataEngine dataEngine = this.executionContext.getDataEngine();
        dataEngine.prepare(this.report, appContext);
    }

    private void prepareMetaData() {
        if (this.isMetaDataPrepared) {
            return;
        }
        HashMap queryIds = this.report.getQueryIDs();
        HashMap query2itemMapping = this.report.getReportItemToQueryMap();
        for (Map.Entry entry : queryIds.entrySet()) {
            IDataQueryDefinition baseQuery = (IDataQueryDefinition)entry.getKey();
            if (!(baseQuery instanceof IQueryDefinition)) continue;
            IQueryDefinition query = (IQueryDefinition)baseQuery;
            String queryId = (String)entry.getValue();
            ReportItemDesign item = (ReportItemDesign)query2itemMapping.get(query);
            String queryName = item.getName();
            if (queryName == null) {
                queryName = "ELEMENT_" + item.getID();
            }
            this.queryId2NameMapping.put(queryId, queryName);
            this.queryId2QueryMapping.put(queryId, query);
            this.query2QueryIdMapping.put(query, queryId);
        }
        try {
            this.loadResultSetMetaData();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        this.isMetaDataPrepared = true;
    }

    private String getQueryName(String queryId) {
        return (String)this.queryId2NameMapping.get(queryId);
    }

    private IQueryDefinition getQuery(String queryId) {
        return (IQueryDefinition)this.queryId2QueryMapping.get(queryId);
    }

    private void loadResultSetMetaData() {
        try {
            HashMap query2ResultMetaData = this.report.getResultMetaData();
            IDocArchiveReader reader = this.reportDocReader.getArchive();
            HashMap<String, Integer> queryCounts = new HashMap<String, Integer>();
            ArrayList result = DteMetaInfoIOUtil.loadDteMetaInfo(reader);
            if (result != null) {
                HashSet<String> dteMetaInfoSet = new HashSet<String>();
                int i = 0;
                while (i < result.size()) {
                    String[] rsetRelation = (String[])result.get(i);
                    this.rssetIdMapping.put(this.getDteMetaInfoString(rsetRelation), rsetRelation[3]);
                    String dteMetaInfoString = this.getDteMetaInfoString(rsetRelation);
                    if (!dteMetaInfoSet.contains(dteMetaInfoString)) {
                        ReportItemDesign design;
                        ReportItemHandle handle;
                        ResultMetaData metaData;
                        dteMetaInfoSet.add(dteMetaInfoString);
                        String queryId = rsetRelation[2];
                        String rsetId = rsetRelation[3];
                        IQueryDefinition query = this.getQuery(queryId);
                        int count = -1;
                        Integer countObj = (Integer)queryCounts.get(queryId);
                        if (countObj != null) {
                            count = countObj;
                        }
                        String rsetName = this.getQueryName(queryId);
                        if (++count > 0) {
                            rsetName = String.valueOf(rsetName) + "_" + count;
                        }
                        queryCounts.put(queryId, new Integer(count));
                        if (query2ResultMetaData != null && (metaData = (ResultMetaData)query2ResultMetaData.get(query)) != null && metaData.getColumnCount() > 0 && (handle = (ReportItemHandle)(design = (ReportItemDesign)this.report.getReportItemToQueryMap().get(query)).getHandle()).allowExport()) {
                            ResultSetItem resultItem = new ResultSetItem(rsetName, metaData, (DesignElementHandle)handle, this.executionContext.getLocale());
                            this.resultMetaList.add(resultItem);
                            this.rsetName2IdMapping.put(rsetName, rsetId);
                            this.rsetId2queryIdMapping.put(rsetId, queryId);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
        }
    }

    private String getDteMetaInfoString(String[] rsetRelation) {
        StringBuffer buffer = new StringBuffer();
        String pRsetId = rsetRelation[0];
        String rowId = rsetRelation[1];
        String queryId = rsetRelation[2];
        buffer.setLength(0);
        if (pRsetId == null) {
            buffer.append("null");
        } else {
            buffer.append(pRsetId);
        }
        buffer.append(".");
        buffer.append(rowId);
        buffer.append(".");
        buffer.append(queryId);
        return buffer.toString();
    }

    InstanceID[] getAncestors(InstanceID id) {
        LinkedList<InstanceID> iids = new LinkedList<InstanceID>();
        while (id != null) {
            iids.addFirst(id);
            id = id.getParentID();
        }
        return iids.toArray(new InstanceID[0]);
    }

    protected String queryId2rsetId(String id) {
        for (Map.Entry entry : this.rsetId2queryIdMapping.entrySet()) {
            String queryId = (String)entry.getValue();
            String rsetId = (String)entry.getKey();
            if (!queryId.equals(id)) continue;
            return rsetId;
        }
        return null;
    }

    protected String rsetId2Name(String id) {
        for (Map.Entry entry : this.rsetName2IdMapping.entrySet()) {
            String rsetId = (String)entry.getValue();
            String rsetName = (String)entry.getKey();
            if (!rsetId.equals(id)) continue;
            return rsetName;
        }
        return null;
    }

    protected String rsetName2Id(String name) {
        return (String)this.rsetName2IdMapping.get(name);
    }

    @Override
    public void setInstanceID(InstanceID iid) {
        assert (iid != null);
        this.prepareMetaData();
        this.instanceId = iid;
        this.resultSetName = null;
        this.selectedColumns = null;
    }

    @Override
    public void selectResultSet(String displayName) {
        assert (displayName != null);
        this.prepareMetaData();
        if (displayName.startsWith("InstanceId:")) {
            this.resultSetName = null;
            this.instanceId = InstanceID.parse(displayName.substring(11));
        } else {
            this.resultSetName = displayName;
            this.instanceId = null;
        }
        this.selectedColumns = null;
    }

    @Override
    public List getMetaData() throws EngineException {
        return this.getResultSetList();
    }

    @Override
    public List getResultSetList() throws EngineException {
        this.prepareMetaData();
        if (this.instanceId != null) {
            ArrayList<ResultSetItem> rsetList = new ArrayList<ResultSetItem>();
            IResultMetaData metaData = null;
            try {
                metaData = this.getMetaDateByInstanceID(this.instanceId);
            }
            catch (BirtException ex) {
                throw new EngineException(ex);
            }
            if (metaData != null) {
                rsetList.add(new ResultSetItem("InstanceId:" + this.instanceId.toUniqueString(), metaData));
            }
            return rsetList;
        }
        return this.resultMetaList;
    }

    protected IResultMetaData getResultMetaData(String rsetName) {
        for (IResultSetItem rsetItem : this.resultMetaList) {
            if (!rsetItem.getResultSetName().equals(rsetName)) continue;
            return rsetItem.getResultMetaData();
        }
        return null;
    }

    @Override
    public void selectColumns(String[] columnNames) {
        this.selectedColumns = columnNames;
    }

    @Override
    public IExtractionResults extract() throws EngineException {
        try {
            this.prepareMetaData();
            if (this.resultSetName != null) {
                return this.extractByResultSetName(this.resultSetName);
            }
            if (this.instanceId != null) {
                return this.extractByInstanceID(this.instanceId);
            }
            return null;
        }
        catch (BirtException ex) {
            throw new EngineException(ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Plan createPlan(InstanceID instanceId) throws EngineException {
        iid = instanceId;
        query = null;
        while (iid != null) {
            id = iid.getComponentID();
            design = (ReportItemDesign)this.report.getReportItemByID(id);
            dataQuery = design.getQuery();
            if (dataQuery != null) {
                handle = (ReportItemHandle)design.getHandle();
                if (!handle.allowExport()) {
                    throw new EngineException("Error.ResultsetExtractError");
                }
                if (!(dataQuery instanceof IBaseQueryDefinition)) {
                    return null;
                }
                query = (IBaseQueryDefinition)dataQuery;
                break;
            }
            iid = iid.getParentID();
        }
        dsIDs = new ArrayList<DataSetID>();
        plan = new Plan();
        ** GOTO lbl42
        {
            block7: {
                if (iid.getDataID() == null) break block7;
                dataId = iid.getDataID();
                dsId = dataId.getDataSetID();
                found = false;
                itr = dsIDs.iterator();
                while (itr.hasNext()) {
                    if (!((DataSetID)itr.next()).equals(dsId)) continue;
                    found = true;
                    break;
                }
                if (found) break block7;
                dsIDs.add(dsId);
                task = new QueryTask(query, dsId, (int)dataId.getRowID(), iid);
                plan.add(task);
                ** GOTO lbl40
            }
            iid = iid.getParentID();
            do {
                if (iid != null) continue block1;
lbl40:
                // 2 sources

                if (iid == null) break block1;
                query = query.getParentQuery();
lbl42:
                // 2 sources

            } while (query != null);
        }
        task = new QueryTask(query, null, -1, null);
        plan.add(task);
        return plan;
    }

    private void updatePlan(Plan plan, int index, IBaseQueryDefinition query) {
        if (index < 0 || plan == null || plan.size() < index + 1) {
            return;
        }
        QueryTask task = (QueryTask)plan.get(index);
        task.query = query;
    }

    private void updatePlanFully(Plan plan, IBaseQueryDefinition query) {
        int index = 0;
        while (query != null && index <= plan.size()) {
            this.updatePlan(plan, index, query);
            ++index;
            query = query.getParentQuery();
        }
    }

    private QueryResultSet executePlan(ArrayList<QueryTask> plan, int index) throws BirtException {
        if (plan == null || plan.size() == 0 || index < 0 || index + 1 > plan.size()) {
            return null;
        }
        QueryResultSet parent = null;
        int current = plan.size() - 1;
        while (current >= index) {
            QueryTask task = plan.get(current);
            IBaseQueryDefinition query = task.query;
            if (task.parent == null) {
                String queryId = this.getQueryId(query);
                String rsID = this.getResultsetID(null, -1L, queryId);
                assert (rsID != null);
                IQueryResults qryRS = this.executeQuery(rsID, (QueryDefinition)query);
                parent = new QueryResultSet(this.executionContext.getDataEngine(), this.executionContext, (IQueryDefinition)query, qryRS);
            } else {
                if (parent == null) {
                    throw new EngineException("Error.ResultsetExtractError");
                }
                IResultIterator parentItr = parent.getResultIterator();
                parentItr.moveTo(task.rowId);
                if (query instanceof IQueryDefinition) {
                    String queryId = this.getQueryId(query);
                    int rowId = parentItr.getRowId();
                    String rsID = this.getResultsetID(parent.getQueryResultsID(), rowId, queryId);
                    assert (rsID != null);
                    IQueryResults qryRS = this.executeQuery(rsID, (QueryDefinition)query);
                    parent = new QueryResultSet(this.executionContext.getDataEngine(), this.executionContext, parent, (IQueryDefinition)query, qryRS);
                } else if (query instanceof ISubqueryDefinition) {
                    String queryName = query.getName();
                    Scriptable scope = this.executionContext.getSharedScope();
                    IResultIterator itr2 = parentItr.getSecondaryIterator(queryName, scope);
                    parent = new QueryResultSet(parent, (ISubqueryDefinition)query, itr2);
                } else {
                    return null;
                }
            }
            --current;
        }
        return parent;
    }

    private String getQueryId(IBaseQueryDefinition query) {
        String id = (String)this.tmpQuery2QueryIdMapping.get(query);
        if (id == null) {
            return (String)this.query2QueryIdMapping.get(query);
        }
        return id;
    }

    private IQueryResults executeQuery(String rset, QueryDefinition query) throws BirtException {
        query.setQueryResultsID(rset);
        DataRequestSession dataSession = this.executionContext.getDataEngine().getDTESession();
        Scriptable scope = this.executionContext.getSharedScope();
        Map appContext = this.executionContext.getAppContext();
        this.processQueryExtensions((IDataQueryDefinition)query);
        IPreparedQuery pQuery = dataSession.prepare((IQueryDefinition)query, appContext);
        return pQuery.execute(scope);
    }

    private IExtractionResults extractByResultSetName(String rsetName) throws BirtException {
        if (!this.rsetName2IdMapping.containsKey(rsetName)) {
            throw new EngineException("Error.ResultsetExtractError");
        }
        DataRequestSession dataSession = this.executionContext.getDataEngine().getDTESession();
        String rsetId = this.rsetName2Id(rsetName);
        if (rsetId != null) {
            IResultMetaData metaData;
            IQueryResults results = null;
            String queryId = (String)this.rsetId2queryIdMapping.get(rsetId);
            QueryDefinition query = (QueryDefinition)this.getQuery(queryId);
            if (query == null) {
                return null;
            }
            QueryDefinition newQuery = null;
            if (this.groupMode) {
                newQuery = this.cloneQuery(query);
                this.setupQueryWithFilterAndSort((IBaseQueryDefinition)newQuery);
                newQuery.setQueryResultsID(rsetId);
            } else {
                QueryDefinition cloned = this.cloneQuery(query);
                cloned.setQueryResultsID(rsetId);
                newQuery = new QueryDefinition();
                newQuery.setSourceQuery((IBaseQueryDefinition)cloned);
                this.setupQueryWithFilterAndSort((IBaseQueryDefinition)newQuery);
                this.setupDistinct((IBaseQueryDefinition)newQuery);
            }
            Scriptable scope = this.executionContext.getSharedScope();
            this.processQueryExtensions((IDataQueryDefinition)newQuery);
            IPreparedQuery preparedQuery = dataSession.prepare((IQueryDefinition)newQuery);
            results = preparedQuery.execute(scope);
            if (results != null && (metaData = this.getResultMetaData(rsetName)) != null) {
                return new ExtractionResults(results, metaData, this.selectedColumns, this.startRow, this.maxRows);
            }
        }
        return null;
    }

    private IExtractionResults extractByInstanceID(InstanceID instanceId) throws BirtException {
        IResultMetaData metaData;
        QueryDefinition newQuery;
        assert (instanceId != null);
        Plan plan = this.createPlan(instanceId);
        if (plan.size() == 0) {
            return null;
        }
        this.tmpQuery2QueryIdMapping.clear();
        IQueryResults queryResults = null;
        QueryTask task = (QueryTask)plan.get(0);
        IBaseQueryDefinition query = task.query;
        if (this.groupMode) {
            newQuery = null;
            newQuery = this.cloneQuery(query);
            this.setupQueryWithFilterAndSort((IBaseQueryDefinition)newQuery);
            this.updatePlanFully(plan, (IBaseQueryDefinition)newQuery);
            QueryResultSet rset = this.executePlan(plan, 0);
            if (rset == null) {
                return null;
            }
            queryResults = (IQueryResults)rset.getQueryResults();
        } else {
            newQuery = new QueryDefinition();
            if (query instanceof IQueryDefinition) {
                QueryDefinition cloned = this.cloneQuery((QueryDefinition)query);
                this.updatePlanFully(plan, (IBaseQueryDefinition)cloned);
                QueryResultSet rset = this.executePlan(plan, 0);
                cloned.setQueryResultsID(rset.getQueryResultsID());
                newQuery.setSourceQuery((IBaseQueryDefinition)cloned);
                this.setupQueryWithFilterAndSort((IBaseQueryDefinition)newQuery);
            } else {
                SubqueryDefinition clonedSubquery = this.cloneQuery2((SubqueryDefinition)query, task.iid);
                this.updatePlanFully(plan, (IBaseQueryDefinition)clonedSubquery);
                int index = 1;
                SubqueryDefinition topSubquery = clonedSubquery;
                while (topSubquery != null) {
                    if (topSubquery.getParentQuery() instanceof IQueryDefinition) break;
                    topSubquery = (ISubqueryDefinition)topSubquery.getParentQuery();
                    ++index;
                }
                QueryResultSet rset = this.executePlan(plan, index);
                ((QueryDefinition)topSubquery.getParentQuery()).setQueryResultsID(rset.getQueryResultsID());
                newQuery.setSourceQuery((IBaseQueryDefinition)clonedSubquery);
                this.setupDistinct((IBaseQueryDefinition)newQuery);
                this.setupQueryWithFilterAndSort((IBaseQueryDefinition)newQuery);
            }
            DataRequestSession dataSession = this.executionContext.getDataEngine().getDTESession();
            Scriptable scope = this.executionContext.getSharedScope();
            this.processQueryExtensions((IDataQueryDefinition)newQuery);
            IPreparedQuery preparedQuery = dataSession.prepare((IQueryDefinition)newQuery);
            queryResults = preparedQuery.execute(scope);
        }
        if (queryResults != null && (metaData = this.getMetaDateByInstanceID(instanceId)) != null) {
            return new ExtractionResults(queryResults, metaData, this.selectedColumns, this.startRow, this.maxRows);
        }
        return null;
    }

    private void setupQueryWithFilterAndSort(IBaseQueryDefinition query) {
        int iNum;
        if (this.filterExpressions != null) {
            iNum = 0;
            while (iNum < this.filterExpressions.length) {
                query.getFilters().add(this.filterExpressions[iNum]);
                ++iNum;
            }
            this.filterExpressions = null;
        }
        if (this.sortExpressions != null) {
            iNum = 0;
            while (iNum < this.sortExpressions.length) {
                query.getSorts().add(this.sortExpressions[iNum]);
                ++iNum;
            }
            this.sortExpressions = null;
        }
    }

    private void setupDistinct(IBaseQueryDefinition query) {
        ((BaseQueryDefinition)query).setDistinctValue(this.distinct);
    }

    private String getResultsetID(String prset, long rowId, String queryId) {
        String parentRSet = prset == null ? "null" : prset;
        String rsmeta = String.valueOf(parentRSet) + "." + rowId + "." + queryId;
        return (String)this.rssetIdMapping.get(rsmeta);
    }

    private IResultMetaData getMetaDateByInstanceID(InstanceID iid) throws BirtException {
        while (iid != null) {
            long id = iid.getComponentID();
            ReportItemDesign design = (ReportItemDesign)this.report.getReportItemByID(id);
            IDataQueryDefinition query = design.getQuery();
            if (query != null) {
                ReportItemHandle handle = (ReportItemHandle)design.getHandle();
                if (!handle.allowExport()) {
                    return null;
                }
                HashMap query2ResultMetaData = this.report.getResultMetaData();
                if (query2ResultMetaData != null) {
                    if (query instanceof ISubqueryDefinition) {
                        return new SubqueryResultMetaData((ISubqueryDefinition)query, query2ResultMetaData);
                    }
                    return (ResultMetaData)query2ResultMetaData.get(query);
                }
                return null;
            }
            iid = iid.getParentID();
        }
        return null;
    }

    private BaseQueryDefinition cloneQuery2(IBaseQueryDefinition query, InstanceID instanceID) {
        if (query instanceof SubqueryDefinition) {
            return this.cloneQuery2((SubqueryDefinition)query, instanceID);
        }
        if (query instanceof QueryDefinition) {
            return this.cloneQuery((QueryDefinition)query);
        }
        return null;
    }

    private SubqueryDefinition cloneQuery2(SubqueryDefinition query, InstanceID instanceID) {
        while (instanceID.getDataID() == null) {
            instanceID = instanceID.getParentID();
        }
        InstanceID currentID = instanceID;
        BaseQueryDefinition parent = this.cloneQuery2(query.getParentQuery(), instanceID.getParentID());
        SubqueryLocator locator = new SubqueryLocator((int)currentID.getDataID().getRowID(), query.getName(), (IBaseQueryDefinition)parent);
        locator.getBindings().putAll(query.getBindings());
        locator.getSorts().addAll(query.getSorts());
        locator.getFilters().addAll(query.getFilters());
        locator.getSubqueries().addAll(query.getSubqueries());
        locator.getGroups().addAll(query.getGroups());
        locator.setUsesDetails(query.usesDetails());
        return locator;
    }

    private BaseQueryDefinition cloneQuery(IBaseQueryDefinition query) {
        if (query instanceof SubqueryDefinition) {
            return this.cloneQuery((SubqueryDefinition)query);
        }
        if (query instanceof QueryDefinition) {
            return this.cloneQuery((QueryDefinition)query);
        }
        return null;
    }

    private SubqueryDefinition cloneQuery(SubqueryDefinition query) {
        BaseQueryDefinition parent = this.cloneQuery(query.getParentQuery());
        SubqueryDefinition newQuery = new SubqueryDefinition(query.getName(), (IBaseQueryDefinition)parent);
        newQuery.getBindings().putAll(query.getBindings());
        newQuery.getSorts().addAll(query.getSorts());
        newQuery.getFilters().addAll(query.getFilters());
        newQuery.getSubqueries().addAll(query.getSubqueries());
        newQuery.getGroups().addAll(query.getGroups());
        newQuery.setUsesDetails(query.usesDetails());
        newQuery.setApplyOnGroupFlag(query.applyOnGroup());
        parent.getSubqueries().add(newQuery);
        return newQuery;
    }

    private QueryDefinition cloneQuery(QueryDefinition query) {
        QueryDefinition newQuery = new QueryDefinition((BaseQueryDefinition)query.getParentQuery());
        newQuery.getBindings().putAll(query.getBindings());
        newQuery.getSorts().addAll(query.getSorts());
        newQuery.getFilters().addAll(query.getFilters());
        newQuery.getGroups().addAll(query.getGroups());
        newQuery.setUsesDetails(query.usesDetails());
        newQuery.setMaxRows(query.getMaxRows());
        newQuery.setDataSetName(query.getDataSetName());
        newQuery.setAutoBinding(query.needAutoBinding());
        newQuery.setColumnProjection(query.getColumnProjection());
        newQuery.setName(query.getName());
        String queryID = (String)this.query2QueryIdMapping.get(query);
        this.tmpQuery2QueryIdMapping.put(newQuery, queryID);
        return newQuery;
    }

    @Override
    public void setFilters(IFilterDefinition[] simpleFilterExpression) {
        this.filterExpressions = simpleFilterExpression;
    }

    @Override
    public void setSorts(ISortDefinition[] simpleSortExpression) {
        this.sortExpressions = simpleSortExpression;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void extract(IDataExtractionOption option) throws BirtException {
        IDataExtractionOption extractOption = this.setupExtractOption(option);
        IDataExtractionExtension dataExtraction = this.getDataExtractionExtension(extractOption);
        try {
            dataExtraction.initilize(this.executionContext.getReportContext(), extractOption);
            dataExtraction.output(this.extract());
        }
        finally {
            dataExtraction.release();
        }
    }

    private IDataExtractionExtension getDataExtractionExtension(IDataExtractionOption option) throws EngineException {
        IDataExtractionExtension dataExtraction = null;
        String extension = option.getExtension();
        ExtensionManager extensionManager = ExtensionManager.getInstance();
        if (extension != null && (dataExtraction = extensionManager.createDataExtractionExtensionById(extension)) == null) {
            logger.log(Level.WARNING, "Extension with id " + extension + " doesn't exist.");
        }
        String format = null;
        if (dataExtraction == null && (format = option.getOutputFormat()) != null && (dataExtraction = extensionManager.createDataExtractionExtensionByFormat(format)) == null) {
            logger.log(Level.WARNING, "Extension of format " + format + " doesn't exist.");
        }
        if (dataExtraction == null) {
            throw new EngineException("Error.InvalidExtensionError", new Object[]{extension, format});
        }
        return dataExtraction;
    }

    @Override
    public void setStartRow(int startRow) {
        this.startRow = startRow;
        if (startRow > 0) {
            this.groupMode = false;
        }
    }

    @Override
    public void setDistinctValuesOnly(boolean distinct) {
        this.distinct = distinct;
        if (distinct) {
            this.groupMode = false;
        }
    }

    protected void processQueryExtensions(IDataQueryDefinition query) throws EngineException {
        String[] extensions = this.executionContext.getEngineExtensions();
        if (extensions != null) {
            EngineExtensionManager manager = this.executionContext.getEngineExtensionManager();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extensionName = stringArray[n2];
                IDataExtension extension = manager.getDataExtension(extensionName);
                if (extension != null) {
                    extension.prepareQuery(query);
                }
                ++n2;
            }
        }
    }

    private IDataExtractionOption setupExtractOption(IDataExtractionOption options) {
        DataExtractionOption extractOption;
        IRenderOption defaultHtmlOptions;
        HashMap allOptions = new HashMap();
        HashMap configs = this.engine.getConfig().getEmitterConfigs();
        IRenderOption defaultOptions = (IRenderOption)configs.get("org.eclipse.birt.report.engine.api.EngineConfig.defaultRenderOption");
        if (defaultOptions != null) {
            allOptions.putAll(defaultOptions.getOptions());
        }
        if ((defaultHtmlOptions = (IRenderOption)configs.get("html")) != null) {
            allOptions.putAll(defaultHtmlOptions.getOptions());
        }
        allOptions.putAll(options.getOptions());
        Map appContext = this.executionContext.getAppContext();
        Object renderContext = appContext.get("HTML_RENDER_CONTEXT");
        if (renderContext == null) {
            HTMLRenderContext htmlContext = new HTMLRenderContext();
            HTMLRenderOption htmlOptions = new HTMLRenderOption(allOptions);
            htmlContext.setBaseImageURL(htmlOptions.getBaseImageURL());
            htmlContext.setBaseURL(htmlOptions.getBaseURL());
            htmlContext.setImageDirectory(htmlOptions.getImageDirectory());
            htmlContext.setSupportedImageFormats(htmlOptions.getSupportedImageFormats());
            htmlContext.SetRenderOption(htmlOptions);
            appContext.put("HTML_RENDER_CONTEXT", htmlContext);
        }
        if ((extractOption = new DataExtractionOption(allOptions)).getInstanceID() == null && this.instanceId != null) {
            extractOption.setInstanceID(this.instanceId);
        }
        return extractOption;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Plan
    extends ArrayList<QueryTask> {
        Plan() {
        }
    }

    class QueryTask {
        IBaseQueryDefinition query;
        DataSetID parent;
        int rowId;
        InstanceID iid;

        QueryTask(IBaseQueryDefinition query, DataSetID parent, int rowId, InstanceID iid) {
            this.query = query;
            this.parent = parent;
            this.rowId = rowId;
            this.iid = iid;
        }
    }
}

