/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ScriptLibHandle;

public class ApplicationClassLoader
extends ClassLoader {
    protected static Logger logger = Logger.getLogger(ApplicationClassLoader.class.getName());
    private ClassLoader engineClassLoader;
    private ClassLoader loader = null;
    private IReportRunnable runnable;
    private ExecutionContext executionContext = null;
    private ReportEngine engine;

    public ApplicationClassLoader(ReportEngine engine, IReportRunnable reportRunnable, ExecutionContext executionContext) {
        this.runnable = reportRunnable;
        this.engine = engine;
        this.executionContext = executionContext;
        this.engineClassLoader = this.getReportEngineClassLoader();
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        try {
            if (this.loader == null) {
                this.createWrappedClassLoaders();
            }
            return this.loader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.engineClassLoader.loadClass(className);
        }
    }

    public URL getResource(String name) {
        URL url = this.engineClassLoader.getResource(name);
        if (url == null) {
            if (this.loader == null) {
                this.createWrappedClassLoaders();
            }
            return this.loader.getResource(name);
        }
        return null;
    }

    protected void createWrappedClassLoaders() {
        ClassLoader engineClassLoader = this.engineClassLoader;
        if (this.engine != null) {
            engineClassLoader = this.engine.getClassLoader();
        }
        this.loader = ApplicationClassLoader.createClassLoaderFromDesign(this.runnable, engineClassLoader, this.executionContext);
    }

    protected ClassLoader getReportEngineClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return IReportEngine.class.getClassLoader();
            }
        });
    }

    public static ClassLoader createClassLoaderFromDesign(IReportRunnable runnable, ClassLoader parent, ExecutionContext executionContext) {
        if (runnable != null) {
            ModuleHandle module = (ModuleHandle)runnable.getDesignHandle();
            ArrayList<URL> urls = new ArrayList<URL>();
            Iterator iter = module.scriptLibsIterator();
            while (iter.hasNext()) {
                ScriptLibHandle lib = (ScriptLibHandle)iter.next();
                String libPath = lib.getName();
                URL url = module.findResource(libPath, 2);
                if (url != null) {
                    urls.add(url);
                    continue;
                }
                if (executionContext != null) {
                    executionContext.addException(new EngineException("Error.JarNotFoundError", libPath));
                }
                logger.log(Level.SEVERE, "Can not find specified jar: " + libPath);
            }
            if (urls.size() != 0) {
                URL[] jarUrls = urls.toArray(new URL[0]);
                return new URLClassLoader(jarUrls, parent);
            }
        }
        return parent;
    }
}

