/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;

public class SuppressDuplicateUtil {
    public static void clearDuplicateFlags(ReportItemDesign list) {
        if (list != null) {
            list.accept(new ClearDuplicateFlagVisitor(), null);
        }
    }

    protected static class ClearDuplicateFlagVisitor
    extends DefaultReportItemVisitorImpl {
        protected ClearDuplicateFlagVisitor() {
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            int i = 0;
            while (i < container.getItemCount()) {
                container.getItem(i).accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitListing(ListingDesign list, Object value) {
            BandDesign footer;
            BandDesign header = list.getHeader();
            if (header != null) {
                value = header.accept(this, value);
            }
            int i = 0;
            while (i < list.getGroupCount()) {
                BandDesign groupFooter;
                GroupDesign group = list.getGroup(i);
                BandDesign groupHeader = group.getHeader();
                if (groupHeader != null) {
                    value = groupHeader.accept(this, value);
                }
                if ((groupFooter = group.getFooter()) != null) {
                    value = groupFooter.accept(this, value);
                }
                ++i;
            }
            BandDesign detail = list.getDetail();
            if (detail != null) {
                value = detail.accept(this, value);
            }
            if ((footer = list.getFooter()) != null) {
                value = footer.accept(this, value);
            }
            return null;
        }

        public Object visitDataItem(DataItemDesign data, Object value) {
            data.setExecutionState(null);
            return value;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            int i = 0;
            while (i < grid.getRowCount()) {
                value = grid.getRow(i).accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitRow(RowDesign row, Object value) {
            int i = 0;
            while (i < row.getCellCount()) {
                value = this.visitCell(row.getCell(i), value);
                ++i;
            }
            return value;
        }

        public Object visitCell(CellDesign cell, Object value) {
            int i = 0;
            while (i < cell.getContentCount()) {
                value = cell.getContent(i).accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitBand(BandDesign band, Object value) {
            int i = 0;
            while (i < band.getContentCount()) {
                value = band.getContent(i).accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitGroup(GroupDesign group, Object value) {
            BandDesign footer;
            BandDesign header = group.getHeader();
            if (header != null) {
                value = header.accept(this, value);
            }
            if ((footer = group.getFooter()) != null) {
                value = footer.accept(this, value);
            }
            return value;
        }
    }
}

