/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;

public class HTMLGroupLM
extends HTMLBlockStackingLM {
    boolean isFirstLayout = true;

    public HTMLGroupLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public int getType() {
        return 8;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        super.initialize(parent, content, executor, emitter);
        this.isFirstLayout = true;
    }

    protected boolean isHeaderBand() {
        IContent band;
        if (this.childLayout != null && (band = ((HTMLAbstractLM)this.childLayout).getContent()) instanceof IBandContent) {
            return ((IBandContent)band).getBandType() == 3;
        }
        return false;
    }

    protected void repeatHeader() {
        if (!this.isFirstLayout) {
            IGroupContent group = (IGroupContent)this.content;
            IBandContent header = group.getHeader();
            if (group.isHeaderRepeat() && header != null && !this.isHeaderBand()) {
                boolean pageBreak = this.context.allowPageBreak();
                this.context.setAllowPageBreak(false);
                IPageBuffer buffer = this.context.getPageBufferManager();
                boolean isRepeated = buffer.isRepeated();
                buffer.setRepeated(true);
                this.engine.layout((ILayoutManager)this, header, this.emitter);
                buffer.setRepeated(isRepeated);
                this.context.setAllowPageBreak(pageBreak);
            }
        }
        this.isFirstLayout = false;
    }

    protected boolean layoutChildren() {
        this.repeatHeader();
        boolean hasNext = super.layoutChildren();
        return hasNext;
    }
}

