/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.PDFReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManagerFactory;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class PDFLayoutEngineContext {
    protected PDFLayoutManagerFactory factory = null;
    protected StartVisitor start;
    protected EndVisitor end;
    protected String masterPage = null;
    protected boolean allowPageBreak = true;
    protected IContent unresolvedContent = null;
    protected PDFReportLayoutEngine engine;
    protected int maxWidth;
    protected int maxHeight;
    protected String format;
    protected boolean cancel = false;
    protected IReportContent report;
    protected boolean autoPageBreak = false;
    protected Locale locale;
    protected ArrayList hints = new ArrayList();
    protected ArrayList columnHints = new ArrayList();
    protected long pageNumber = 1L;
    protected long pageCount = 1L;
    protected boolean outputDisplayNone = false;
    protected boolean fitToPage = false;
    protected boolean pageBreakPaginationOnly = false;
    protected int pageOverflow = 1;
    protected int preferenceWidth = 0;
    protected boolean textWrapping = true;
    protected boolean fontSubstitution = true;
    protected boolean bidiProcessing = true;
    private FontMappingManager fontManager;

    public void setLayoutPageHint(IPageHint pageHint) {
        if (pageHint != null) {
            this.hints.clear();
            this.columnHints.clear();
            this.pageNumber = pageHint.getPageNumber();
            this.masterPage = pageHint.getMasterPage();
            int count = pageHint.getUnresolvedRowCount();
            int i = 0;
            while (i < count) {
                this.hints.add(pageHint.getUnresolvedRowHint(i));
                ++i;
            }
            count = pageHint.getTableColumnHintCount();
            i = 0;
            while (i < count) {
                this.columnHints.add(pageHint.getTableColumnHint(i));
                ++i;
            }
        }
    }

    public TableColumnHint getTableColumnHint(String tableId) {
        if (this.columnHints.size() > 0) {
            for (TableColumnHint hint : this.columnHints) {
                if (!tableId.equals(hint.getTableId())) continue;
                return hint;
            }
        }
        return null;
    }

    public UnresolvedRowHint getUnresolvedRowHint(ITableContent table) {
        if (this.hints.size() > 0) {
            String idStr = table.getInstanceID().toUniqueString();
            for (UnresolvedRowHint rowHint : this.hints) {
                if (!idStr.equals(rowHint.getTableId())) continue;
                return rowHint;
            }
        }
        return null;
    }

    public void addUnresolvedRowHints(Collection hints) {
        this.hints.addAll(hints);
    }

    public void setAutoPageBreak(boolean autoBreak) {
        this.autoPageBreak = autoBreak;
    }

    public boolean isAutoPageBreak() {
        return this.autoPageBreak;
    }

    public IReportContent getReport() {
        return this.report;
    }

    public void setReport(IReportContent report) {
        this.report = report;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public String getMasterPage() {
        return this.masterPage;
    }

    public void setMasterPage(String masterPage) {
        this.masterPage = masterPage;
    }

    public PDFLayoutEngineContext(PDFReportLayoutEngine engine) {
        this.engine = engine;
        this.start = new StartVisitor();
        this.end = new EndVisitor();
    }

    public void setFactory(PDFLayoutManagerFactory factory) {
        this.factory = factory;
    }

    public IContentVisitor getStart() {
        return this.start;
    }

    public IContentVisitor getEnd() {
        return this.end;
    }

    public PDFLayoutManagerFactory getFactory() {
        return this.factory;
    }

    public boolean allowPageBreak() {
        return this.allowPageBreak;
    }

    public void setAllowPageBreak(boolean allowPageBreak) {
        this.allowPageBreak = allowPageBreak;
    }

    public PDFReportLayoutEngine getLayoutEngine() {
        return this.engine;
    }

    public void addUnresolvedContent(IContent content) {
        this.unresolvedContent = content;
    }

    public IContent getUnresolvedContent() {
        return this.unresolvedContent;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    public void setFitToPage(boolean fitToPage) {
        this.fitToPage = fitToPage;
    }

    public boolean fitToPage() {
        return this.fitToPage;
    }

    public void setPagebreakPaginationOnly(boolean pageBreakPaginationOnly) {
        this.pageBreakPaginationOnly = pageBreakPaginationOnly;
    }

    public boolean pagebreakPaginationOnly() {
        return this.pageBreakPaginationOnly;
    }

    public int getPageOverflow() {
        return this.pageOverflow;
    }

    public void setPageOverflow(int pageOverflow) {
        this.pageOverflow = pageOverflow;
    }

    public void setPreferenceWidth(int preferenceWidth) {
        this.preferenceWidth = preferenceWidth;
    }

    public int getPreferenceWidth() {
        return this.preferenceWidth;
    }

    public void setTextWrapping(boolean textWrapping) {
        this.textWrapping = textWrapping;
    }

    public boolean getTextWrapping() {
        return this.textWrapping;
    }

    public void setFontSubstitution(boolean fontSubstitution) {
        this.fontSubstitution = fontSubstitution;
    }

    public boolean getFontSubstitution() {
        return this.fontSubstitution;
    }

    public void setBidiProcessing(boolean bidiProcessing) {
        this.bidiProcessing = bidiProcessing;
    }

    public boolean getBidiProcessing() {
        return this.bidiProcessing;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setOutputDisplayNone(boolean outputDisplayNone) {
        this.outputDisplayNone = outputDisplayNone;
    }

    public boolean getOutputDisplayNone() {
        return this.outputDisplayNone;
    }

    public FontMappingManager getFontManager() {
        if (this.fontManager == null) {
            this.fontManager = FontMappingManagerFactory.getInstance().getFontMappingManager(this.format, this.locale);
        }
        return this.fontManager;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public long getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }

    private class EndVisitor
    implements IContentVisitor {
        private EndVisitor() {
        }

        public Object visit(IContent content, Object value) {
            ((IContentEmitter)value).endContent(content);
            return null;
        }

        public Object visitContent(IContent content, Object value) {
            ((IContentEmitter)value).endContent(content);
            return null;
        }

        public Object visitPage(IPageContent page, Object value) {
            ((IContentEmitter)value).endPage(page);
            return null;
        }

        public Object visitContainer(IContainerContent container, Object value) {
            ((IContentEmitter)value).endContainer(container);
            return null;
        }

        public Object visitTable(ITableContent table, Object value) {
            ((IContentEmitter)value).endTable(table);
            return null;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            return null;
        }

        public Object visitRow(IRowContent row, Object value) {
            ((IContentEmitter)value).endRow(row);
            return null;
        }

        public Object visitCell(ICellContent cell, Object value) {
            ((IContentEmitter)value).endCell(cell);
            return null;
        }

        public Object visitText(ITextContent text, Object value) {
            return null;
        }

        public Object visitLabel(ILabelContent label, Object value) {
            return null;
        }

        public Object visitData(IDataContent data, Object value) {
            return null;
        }

        public Object visitImage(IImageContent image, Object value) {
            return null;
        }

        public Object visitForeign(IForeignContent foreign, Object value) {
            return null;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            return null;
        }

        public Object visitList(IListContent list, Object value) {
            ((IContentEmitter)value).endList(list);
            return null;
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            return null;
        }

        public Object visitGroup(IGroupContent group, Object value) {
            return null;
        }

        public Object visitListGroup(IListGroupContent group, Object value) {
            return null;
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) {
            return null;
        }
    }

    private class StartVisitor
    implements IContentVisitor {
        private StartVisitor() {
        }

        public Object visit(IContent content, Object value) {
            ((IContentEmitter)value).startContent(content);
            return null;
        }

        public Object visitContent(IContent content, Object value) {
            ((IContentEmitter)value).startContent(content);
            return null;
        }

        public Object visitPage(IPageContent page, Object value) {
            ((IContentEmitter)value).startPage(page);
            return null;
        }

        public Object visitContainer(IContainerContent container, Object value) {
            ((IContentEmitter)value).startContainer(container);
            return null;
        }

        public Object visitTable(ITableContent table, Object value) {
            ((IContentEmitter)value).startTable(table);
            return null;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            return null;
        }

        public Object visitRow(IRowContent row, Object value) {
            ((IContentEmitter)value).startRow(row);
            return null;
        }

        public Object visitCell(ICellContent cell, Object value) {
            ((IContentEmitter)value).startCell(cell);
            return null;
        }

        public Object visitText(ITextContent text, Object value) {
            ((IContentEmitter)value).startText(text);
            return null;
        }

        public Object visitLabel(ILabelContent label, Object value) {
            ((IContentEmitter)value).startLabel(label);
            return null;
        }

        public Object visitData(IDataContent data, Object value) {
            ((IContentEmitter)value).startData(data);
            return null;
        }

        public Object visitImage(IImageContent image, Object value) {
            ((IContentEmitter)value).startImage(image);
            return null;
        }

        public Object visitForeign(IForeignContent foreign, Object value) {
            ((IContentEmitter)value).startForeign(foreign);
            return null;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            ((IContentEmitter)value).startAutoText(autoText);
            return null;
        }

        public Object visitList(IListContent list, Object value) {
            ((IContentEmitter)value).startList(list);
            return null;
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            return null;
        }

        public Object visitGroup(IGroupContent group, Object value) {
            return null;
        }

        public Object visitListGroup(IListGroupContent group, Object value) {
            return null;
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) {
            return null;
        }
    }
}

