/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.layout.LayoutUtil;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.pdf.BorderConflictResolver;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableLM;
import org.eclipse.birt.report.engine.layout.pdf.cache.ClonedCellContent;
import org.eclipse.birt.report.engine.layout.pdf.cache.CursorableList;
import org.eclipse.birt.report.engine.layout.pdf.cache.DummyCell;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;
import org.w3c.dom.css.CSSValue;

public class TableAreaLayout {
    protected CursorableList rows = new CursorableList();
    protected BorderConflictResolver bcr = new BorderConflictResolver();
    protected PDFTableLM.TableLayoutInfo layoutInfo = null;
    protected ITableContent tableContent;
    protected ICellContent lastCellContent;
    protected int startCol;
    protected int endCol;
    protected boolean hasDropCell = true;
    protected Row unresolvedRow;
    protected boolean firstRow = true;

    public TableAreaLayout(ITableContent tableContent, PDFTableLM.TableLayoutInfo layoutInfo, int startCol, int endCol) {
        this.tableContent = tableContent;
        this.layoutInfo = layoutInfo;
        this.startCol = startCol;
        this.endCol = endCol;
        if (tableContent != null) {
            this.bcr.setRTL(tableContent.isRTL());
        }
    }

    public void initTableLayout(UnresolvedRowHint hint) {
        if (hint != null) {
            IReportContent report = this.tableContent.getReportContent();
            IRowContent rowContent = report.createRowContent();
            InstanceID rowId = InstanceID.parse(hint.getRowId());
            rowContent.setInstanceID(rowId);
            rowContent.setParent(this.tableContent);
            RowArea rowArea = AreaFactory.createRowArea(rowContent);
            this.unresolvedRow = new Row(rowArea, this.startCol, this.endCol, false);
            int i = this.startCol;
            while (i <= this.endCol) {
                ICellContent cellContent = report.createCellContent();
                hint.initUnresolvedCell(cellContent, rowId, i);
                cellContent.setParent(rowContent);
                CellArea cellArea = AreaFactory.createCellArea(cellContent);
                this.unresolvedRow.addArea(cellArea);
                i = i + cellArea.getColSpan() - 1;
                ++i;
            }
        }
    }

    public void setUnresolvedRow(Row row) {
        this.unresolvedRow = row;
    }

    public Row getUnresolvedRow() {
        return (Row)this.rows.getCurrent();
    }

    protected int resolveBottomBorder(CellArea cell, boolean isLast) {
        IStyle tableStyle = this.tableContent.getComputedStyle();
        IContent cellContent = cell.getContent();
        IStyle columnStyle = this.getColumnStyle(cell.getColumnID());
        IStyle cellAreaStyle = cell.getStyle();
        if (isLast) {
            IStyle cellContentStyle = cellContent.getComputedStyle();
            IStyle rowStyle = ((IContent)cellContent.getParent()).getComputedStyle();
            this.bcr.resolveTableBottomBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
        } else {
            this.bcr.resolveTableBottomBorder(tableStyle, null, columnStyle, null, cellAreaStyle);
        }
        return PropertyUtil.getDimensionValue(cellAreaStyle.getProperty(22));
    }

    protected void add(ContainerArea area, ArrayList rows) {
        if (area instanceof RowArea) {
            rows.add(area);
        } else {
            Iterator iter = area.getChildren();
            while (iter.hasNext()) {
                ContainerArea container = (ContainerArea)iter.next();
                this.add(container, rows);
            }
        }
    }

    public void remove(TableArea table) {
        this.firstRow = true;
        ArrayList rowColloection = new ArrayList();
        this.add(table, rowColloection);
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (!rowColloection.contains(row.getArea())) continue;
            iter.remove();
        }
        this.rows.resetCursor();
    }

    protected IStyle getLeftCellContentStyle(Row lastRow, int columnID) {
        CellArea cell;
        if (this.lastCellContent != null && this.lastCellContent.getColumn() + this.lastCellContent.getColSpan() <= columnID) {
            CellArea cell2;
            if (lastRow != null && columnID > 0 && (cell2 = lastRow.getCell(columnID - 1)) != null && cell2.getRowSpan() < 0 && cell2.getContent() != null) {
                return cell2.getContent().getComputedStyle();
            }
            return this.lastCellContent.getComputedStyle();
        }
        if (lastRow != null && columnID > 0 && (cell = lastRow.getCell(columnID - 1)) != null && cell.getRowSpan() > 1 && cell.getContent() != null) {
            return cell.getContent().getComputedStyle();
        }
        return null;
    }

    public void resolveBorderConflict(CellArea cellArea, boolean isFirst) {
        IContent cellContent = cellArea.getContent();
        int columnID = cellArea.getColumnID();
        int colSpan = cellArea.getColSpan();
        IRowContent row = (IRowContent)cellContent.getParent();
        IStyle cellContentStyle = cellContent.getComputedStyle();
        IStyle cellAreaStyle = cellArea.getStyle();
        IStyle tableStyle = this.tableContent.getComputedStyle();
        IStyle rowStyle = row.getComputedStyle();
        IStyle columnStyle = this.getColumnStyle(columnID);
        IStyle preRowStyle = null;
        IStyle preColumnStyle = this.getColumnStyle(columnID - 1);
        IStyle leftCellContentStyle = null;
        IStyle topCellStyle = null;
        Row lastRow = null;
        if (this.rows.size() > 0) {
            lastRow = (Row)this.rows.getCurrent();
        }
        leftCellContentStyle = this.getLeftCellContentStyle(lastRow, columnID);
        if (lastRow != null) {
            preRowStyle = lastRow.getContent().getComputedStyle();
            CellArea cell = lastRow.getCell(columnID);
            if (cell != null && cell.getContent() != null) {
                topCellStyle = cell.getContent().getComputedStyle();
            }
        }
        if (this.rows.size() == 0 && lastRow == null) {
            if (isFirst) {
                this.bcr.resolveTableTopBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveTableTopBorder(tableStyle, null, columnStyle, null, cellAreaStyle);
            }
            if (columnID == this.startCol) {
                this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle, cellAreaStyle);
            }
            if (columnID + colSpan - 1 == this.endCol) {
                this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            }
        } else {
            if (isFirst) {
                this.bcr.resolveCellTopBorder(preRowStyle, rowStyle, topCellStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellTopBorder(preRowStyle, null, topCellStyle, null, cellAreaStyle);
            }
            if (columnID == this.startCol) {
                this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle, cellAreaStyle);
            }
            if (columnID + colSpan - 1 == this.endCol) {
                this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            }
        }
        this.lastCellContent = (ICellContent)cellContent;
    }

    private IStyle getColumnStyle(int columnID) {
        return null;
    }

    protected void verticalAlign(CellArea c) {
        CSSValue align;
        boolean isRightAligned;
        CellArea cell = c instanceof DummyCell ? ((DummyCell)c).getCell() : c;
        IContent content = cell.getContent();
        if (content == null) {
            return;
        }
        CSSValue verticalAlign = content.getComputedStyle().getProperty(31);
        if (IStyle.BOTTOM_VALUE.equals(verticalAlign) || IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
            int totalHeight = 0;
            Iterator iter = cell.getChildren();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                totalHeight += child.getAllocatedHeight();
            }
            int offset = cell.getContentHeight() - totalHeight;
            if (offset > 0) {
                AbstractArea child;
                if (IStyle.BOTTOM_VALUE.equals(verticalAlign)) {
                    iter = cell.getChildren();
                    while (iter.hasNext()) {
                        child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset);
                    }
                } else if (IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
                    iter = cell.getChildren();
                    while (iter.hasNext()) {
                        child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset / 2);
                    }
                }
            }
        }
        if ((isRightAligned = BidiAlignmentResolver.isRightAligned(content, align = content.getComputedStyle().getProperty(23), false)) || IStyle.CENTER_VALUE.equals(align)) {
            Iterator iter = cell.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                int spacing = cell.getContentWidth() - area.getAllocatedWidth();
                if (spacing <= 0) continue;
                if (isRightAligned) {
                    area.setAllocatedPosition(spacing + area.getAllocatedX(), area.getAllocatedY());
                    continue;
                }
                if (!IStyle.CENTER_VALUE.equals(align)) continue;
                area.setAllocatedPosition(spacing / 2 + area.getAllocatedX(), area.getAllocatedY());
            }
        }
    }

    public void reset(TableArea table) {
        this.firstRow = true;
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (!table.contains(row.getArea())) continue;
            iter.remove();
        }
        this.rows.resetCursor();
    }

    public int resolveDropCells(int dropValue) {
        int rowHeight;
        assert (dropValue < 0);
        if (this.rows.size() == 0 || !this.hasDropCell) {
            return 0;
        }
        Row row = (Row)this.rows.getCurrent();
        assert (row != null);
        int height = rowHeight = row.getArea().getHeight();
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell = row.getCell(i);
            if (cell != null && cell.getRowSpan() == dropValue) {
                height = cell instanceof DummyCell ? Math.max(height, cell.getHeight() + rowHeight) : Math.max(height, cell.getHeight());
            }
            ++i;
        }
        int delta = height - rowHeight;
        HashSet<CellArea> dropCells = new HashSet<CellArea>();
        int i2 = this.startCol;
        while (i2 <= this.endCol) {
            CellArea cell = row.getCell(i2);
            if (cell != null) {
                if (cell instanceof DummyCell) {
                    int remainCellHeight = cell.getHeight() - delta;
                    cell.setHeight(remainCellHeight);
                    if (cell.getRowSpan() == dropValue) {
                        CellArea ref;
                        if (cell.getHeight() < 0 && !dropCells.contains(ref = ((DummyCell)cell).getCell())) {
                            ref.setHeight(ref.getHeight() - remainCellHeight);
                            cell.setHeight(0);
                            this.verticalAlign(ref);
                            dropCells.add(ref);
                        }
                        cell.setRowSpan(1);
                    }
                } else if (cell.getRowSpan() == 1 && delta != 0) {
                    cell.setHeight(height);
                    row.getArea().setHeight(height);
                    this.verticalAlign(cell);
                }
            }
            ++i2;
        }
        return delta;
    }

    public int resolveAll() {
        int rowHeight;
        if (this.rows.size() == 0 || !this.hasDropCell) {
            return 0;
        }
        Row row = (Row)this.rows.getCurrent();
        int height = rowHeight = row.getArea().getHeight();
        boolean hasDropCell = false;
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell = row.getCell(i);
            if (cell != null && (this.isDropCell(cell) || cell.getRowSpan() > 1)) {
                height = cell instanceof DummyCell ? Math.max(height, cell.getHeight() + rowHeight) : Math.max(height, cell.getHeight());
                hasDropCell = true;
            }
            ++i;
        }
        int delta = height - rowHeight;
        if (hasDropCell) {
            HashSet<CellArea> dropCells = new HashSet<CellArea>();
            if (delta > 0) {
                row.getArea().setHeight(height);
            }
            int i2 = this.startCol;
            while (i2 <= this.endCol) {
                CellArea cell = row.getCell(i2);
                if (cell != null) {
                    CellArea ref;
                    int rowSpan = cell.getRowSpan();
                    if (rowSpan < 0 || rowSpan > 1) {
                        if (cell instanceof DummyCell) {
                            ref = ((DummyCell)cell).getCell();
                            int cellHeight = cell.getHeight();
                            int refHeight = ref.getHeight();
                            if (!dropCells.contains(ref)) {
                                ref.setHeight(refHeight - cellHeight + delta);
                                this.verticalAlign(ref);
                                dropCells.add(ref);
                            }
                        } else {
                            cell.setHeight(height);
                            this.verticalAlign(cell);
                        }
                    } else if (rowSpan == 1) {
                        if (cell instanceof DummyCell) {
                            ref = ((DummyCell)cell).getCell();
                            if (!dropCells.contains(ref)) {
                                ref.setHeight(ref.getHeight() + delta);
                                if (delta > 0) {
                                    this.verticalAlign(ref);
                                }
                                dropCells.add(ref);
                            }
                        } else {
                            cell.setHeight(height);
                            this.verticalAlign(cell);
                        }
                    }
                }
                ++i2;
            }
        }
        if (hasDropCell || row != null && !row.finished) {
            this.unresolvedRow = row;
        }
        return delta;
    }

    public int resolveBottomBorder() {
        if (this.rows.size() == 0) {
            return 0;
        }
        Row row = (Row)this.rows.getCurrent();
        HashSet<CellArea> cells = new HashSet<CellArea>();
        int result = 0;
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell = row.getCell(i);
            if (cell != null) {
                if (cell instanceof DummyCell) {
                    CellArea ref = ((DummyCell)cell).getCell();
                    if (!cells.contains(ref)) {
                        int width = this.resolveBottomBorder(ref, row.finished);
                        if (width > result) {
                            result = width;
                        }
                        cells.add(ref);
                    }
                } else if (!cells.contains(cell)) {
                    int width = this.resolveBottomBorder(cell, row.finished);
                    if (width > result) {
                        result = width;
                    }
                    cells.add(cell);
                }
            }
            ++i;
        }
        if (result > 0 && cells.size() > 0) {
            for (CellArea cell : cells) {
                cell.setHeight(cell.getHeight() + result);
            }
            row.getArea().setHeight(row.getArea().getHeight() + result);
        }
        return result;
    }

    public void addRow(RowArea rowArea, boolean finished, boolean repeated) {
        if (!repeated) {
            this.firstRow = false;
        }
        this.hasDropCell = !finished;
        Row lastRow = (Row)this.rows.getCurrent();
        Row row = new Row(rowArea, this.startCol, this.endCol, finished, repeated);
        int rowHeight = rowArea.getHeight();
        HashSet<CellArea> dropCells = new HashSet<CellArea>();
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell;
            CellArea lastCell = null;
            if (lastRow != null) {
                lastCell = lastRow.getCell(i);
            }
            if ((cell = row.getCell(i)) != null && (cell.getRowSpan() > 1 || this.isDropCell(cell))) {
                this.hasDropCell = true;
            }
            if (lastCell != null && (lastCell.getRowSpan() > 1 || this.isDropCell(lastCell)) && cell == null) {
                DummyCell dummyCell = null;
                if (lastCell instanceof DummyCell) {
                    DummyCell refDummy = (DummyCell)lastCell;
                    dummyCell = new DummyCell(refDummy.getCell());
                    if (lastCell.getRowSpan() > 0) {
                        dummyCell.setRowSpan(lastCell.getRowSpan() - 1);
                    } else {
                        dummyCell.setRowSpan(lastCell.getRowSpan());
                    }
                    dummyCell.setHeight(refDummy.getHeight() - rowHeight);
                } else {
                    dummyCell = new DummyCell(lastCell);
                    if (lastCell.getRowSpan() > 0) {
                        dummyCell.setRowSpan(lastCell.getRowSpan() - 1);
                    } else {
                        dummyCell.setRowSpan(lastCell.getRowSpan());
                    }
                    dummyCell.setHeight(lastCell.getHeight() - lastRow.getArea().getHeight() - rowHeight);
                }
                row.addArea(dummyCell);
                if (dummyCell.getRowSpan() == 1) {
                    CellArea cArea;
                    if (dummyCell.getHeight() < 0 && !dropCells.contains(cArea = dummyCell.getCell())) {
                        cArea.setHeight(cArea.getHeight() - dummyCell.getHeight());
                        this.verticalAlign(cArea);
                        dropCells.add(cArea);
                    }
                } else {
                    this.hasDropCell = true;
                }
                i = i + dummyCell.getColSpan() - 1;
            }
            ++i;
        }
        this.rows.add(row);
    }

    public void skipRow(RowArea area) {
    }

    protected boolean existDropCells() {
        if (this.unresolvedRow != null) {
            int i = this.startCol;
            while (i <= this.endCol) {
                CellArea cell = this.unresolvedRow.getCell(i);
                if (cell != null && (this.isDropCell(cell) || cell.getRowSpan() > 1)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void updateRow(RowArea rowArea, int specifiedHeight, boolean finished) {
        this.hasDropCell = !finished;
        Row lastRow = this.getPreviousRow();
        if (lastRow == null && this.existDropCells() && !LayoutUtil.isRepeatableRow((IRowContent)rowArea.getContent())) {
            lastRow = this.unresolvedRow;
        }
        Row row = new Row(rowArea, this.startCol, this.endCol, finished);
        int height = specifiedHeight;
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea lastCell = null;
            if (lastRow != null) {
                lastCell = lastRow.getCell(i);
            }
            CellArea cell = row.getCell(i);
            if (lastCell != null && (lastCell.getRowSpan() > 1 || this.isDropCell(lastCell))) {
                if (this.isDropCell(lastCell) && cell != null) {
                    row.remove(i);
                }
                if (lastCell.getRowSpan() == 2) {
                    height = lastCell instanceof DummyCell ? Math.max(height, lastCell.getHeight()) : Math.max(height, lastCell.getHeight() - lastRow.getArea().getHeight());
                }
                i = i + lastCell.getColSpan() - 1;
            } else {
                if (cell != null && cell.getRowSpan() == 1) {
                    height = Math.max(height, cell.getHeight());
                }
                if (cell == null) {
                    CellArea ca;
                    ICellContent cellContent = null;
                    if (this.unresolvedRow != null && (ca = this.unresolvedRow.getCell(i)) != null) {
                        ICellContent cc = (ICellContent)ca.getContent();
                        cellContent = new ClonedCellContent(cc, this.getRowSpan((IRowContent)rowArea.getContent(), ca, this.unresolvedRow.row));
                    }
                    if (cellContent == null) {
                        cellContent = this.tableContent.getReportContent().createCellContent();
                        cellContent.setColumn(i);
                        cellContent.setColSpan(1);
                        cellContent.setRowSpan(1);
                        cellContent.setParent(rowArea.getContent());
                    }
                    int startColumn = cellContent.getColumn();
                    int endColumn = cellContent.getColSpan() + startColumn;
                    CellArea emptyCell = AreaFactory.createCellArea(cellContent);
                    this.resolveBorderConflict(emptyCell, false);
                    IStyle areaStyle = emptyCell.getStyle();
                    areaStyle.setProperty(50, IStyle.NUMBER_0);
                    areaStyle.setProperty(28, IStyle.NUMBER_0);
                    emptyCell.setWidth(this.getCellWidth(startColumn, endColumn));
                    emptyCell.setPosition(this.layoutInfo.getXPosition(i), 0);
                    rowArea.addChild(emptyCell);
                    i = i + emptyCell.getColSpan() - 1;
                }
            }
            ++i;
        }
        if (specifiedHeight == 0 && this.isEmptyRow(row)) {
            height = Math.max(height, this.getHeightOfEmptyRow(row));
        }
        if (height >= 0) {
            Iterator iter = rowArea.getChildren();
            while (iter.hasNext()) {
                CellArea cell = (CellArea)iter.next();
                if (cell.getRowSpan() != 1) continue;
                cell.setHeight(height);
                this.verticalAlign(cell);
            }
            rowArea.setHeight(height);
        }
        if (this.firstRow && this.existDropCells() && !LayoutUtil.isRepeatableRow((IRowContent)rowArea.getContent())) {
            this.mergeDropCell(rowArea);
        }
    }

    private int getHeightOfEmptyRow(Row row) {
        int heightOfEmptyRow = 0;
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell = row.getCell(i);
            if (cell != null) {
                IStyle style = cell.getStyle();
                int bottomBorderWidth = PropertyUtil.getDimensionValue(style.getProperty(22));
                int topBorderWidth = PropertyUtil.getDimensionValue(style.getProperty(57));
                int heightOfEmptyCell = topBorderWidth + bottomBorderWidth;
                heightOfEmptyRow = Math.max(heightOfEmptyCell, heightOfEmptyRow);
            }
            ++i;
        }
        return heightOfEmptyRow;
    }

    private boolean isEmptyRow(Row row) {
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell = row.getCell(i);
            if (cell != null && !this.isDropCell(cell) && cell.getChildrenCount() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isDropCell(CellArea cell) {
        return cell != null && cell.getRowSpan() < 0;
    }

    protected void mergeDropCell(RowArea row) {
        if (this.unresolvedRow == null) {
            return;
        }
        CellArea[] cells = new CellArea[this.endCol - this.startCol + 1];
        Iterator iter = row.getChildren();
        while (iter.hasNext()) {
            CellArea cell = (CellArea)iter.next();
            int colId = cell.getColumnID();
            if (colId < this.startCol || colId > this.endCol) continue;
            cells[colId - this.startCol] = cell;
        }
        int i = this.startCol;
        while (i <= this.endCol) {
            if (cells[i - this.startCol] == null) {
                ClonedCellContent cellContent = null;
                CellArea ca = this.unresolvedRow.getCell(i);
                if (ca != null) {
                    ICellContent cc = (ICellContent)ca.getContent();
                    cellContent = new ClonedCellContent(cc, this.getRowSpan((IRowContent)row.getContent(), ca, this.unresolvedRow.row));
                    int startColumn = cellContent.getColumn();
                    int endColumn = cellContent.getColSpan() + startColumn;
                    CellArea emptyCell = AreaFactory.createCellArea(cellContent);
                    emptyCell.setRowSpan(cellContent.getRowSpan());
                    this.resolveBorderConflict(emptyCell, true);
                    emptyCell.setWidth(this.getCellWidth(startColumn, endColumn));
                    emptyCell.setPosition(this.layoutInfo.getXPosition(i), 0);
                    emptyCell.setHeight(row.getHeight());
                    row.addChild(emptyCell);
                }
            }
            ++i;
        }
    }

    protected int getRowSpan(IRowContent row, CellArea cell, RowArea rowArea) {
        int rowSpan = cell.getRowSpan();
        IContent rowContent = rowArea.getContent();
        InstanceID id = row.getInstanceID();
        InstanceID contentId = rowContent.getInstanceID();
        if (id != null && contentId != null) {
            if (rowSpan > 1 && !id.toUniqueString().equals(contentId.toUniqueString())) {
                return rowSpan - 1;
            }
            return rowSpan;
        }
        if (row != rowContent && rowSpan > 1) {
            return rowSpan - 1;
        }
        return rowSpan;
    }

    protected CellArea getReference() {
        return null;
    }

    public int getCellWidth(int startColumn, int endColumn) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getCellWidth(startColumn, endColumn);
        }
        return 0;
    }

    public Row getLastRow() {
        Row row = (Row)this.rows.getCurrent();
        return row;
    }

    protected Row getPreviousRow() {
        int size = this.rows.size();
        int i = size - 1;
        while (i >= 0) {
            Row row = (Row)this.rows.get(i);
            if (row != null && !row.repeated) {
                return row;
            }
            --i;
        }
        return null;
    }

    public static class Row {
        protected int start;
        protected int length;
        protected int end;
        protected RowArea row;
        protected CellArea[] cells;
        protected boolean finished = true;
        protected boolean repeated = false;

        Row(RowArea row, int start, int end, boolean finished) {
            this(row, start, end);
            this.finished = finished;
        }

        Row(RowArea row, int start, int end, boolean finished, boolean repeated) {
            this(row, start, end, finished);
            this.repeated = repeated;
        }

        Row(RowArea row, int start, int end) {
            this.row = row;
            this.start = start;
            this.end = end;
            this.length = end - start + 1;
            this.cells = new CellArea[this.length];
            Iterator iter = row.getChildren();
            while (iter.hasNext()) {
                CellArea cell = (CellArea)iter.next();
                int colId = cell.getColumnID();
                int colSpan = cell.getColSpan();
                if (colId < start || colId + colSpan - 1 > end) continue;
                int loopEnd = Math.min(colSpan, end - colId + 1);
                int j = 0;
                while (j < loopEnd) {
                    this.cells[colId - start + j] = cell;
                    ++j;
                }
            }
        }

        public IContent getContent() {
            return this.row.getContent();
        }

        public void remove(int colId) {
            this.row.removeChild(this.getCell(colId));
        }

        public void remove(IArea area) {
            if (area != null) {
                if (!(area instanceof DummyCell)) {
                    this.row.removeChild(area);
                }
                CellArea cell = (CellArea)area;
                int colId = cell.getColumnID();
                int colSpan = cell.getColSpan();
                if (colId >= this.start && colId + colSpan - 1 <= this.end) {
                    int loopEnd = Math.min(colSpan, this.end - colId + 1);
                    int j = 0;
                    while (j < loopEnd) {
                        this.cells[colId - this.start + j] = null;
                        ++j;
                    }
                }
            }
        }

        public CellArea getCell(int colId) {
            if (colId < this.start || colId > this.end) {
                assert (false);
                return null;
            }
            return this.cells[colId - this.start];
        }

        public void addArea(IArea area) {
            if (!(area instanceof DummyCell)) {
                this.row.addChild(area);
            }
            CellArea cell = (CellArea)area;
            int colId = cell.getColumnID();
            int colSpan = cell.getColSpan();
            if (colId >= this.start && colId + colSpan - 1 <= this.end) {
                int loopEnd = Math.min(colSpan, this.end - colId + 1);
                int j = 0;
                while (j < loopEnd) {
                    this.cells[colId - this.start + j] = cell;
                    ++j;
                }
            }
        }

        public RowArea getArea() {
            return this.row;
        }
    }

    private static class UnresolvedRow {
        IContent rowContent;
        protected HashMap map = new HashMap();

        public UnresolvedRow(IContent row) {
            this.rowContent = row;
        }

        public void addUnresolvedCell(ICellContent cell, int rowSpan) {
            int start = cell.getColumn();
            int end = start + cell.getColSpan();
            int i = start;
            while (i < end) {
                this.map.put(new Integer(start), new ClonedCellContent(cell, rowSpan));
                ++i;
            }
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public ICellContent getDropCellContent(int colId, IContent row) {
            ClonedCellContent dropCellContent = (ClonedCellContent)this.map.get(new Integer(colId));
            if (dropCellContent != null) {
                if (row != this.rowContent && dropCellContent.getRowSpan() > 0) {
                    return new ClonedCellContent(dropCellContent.getCellContent(), dropCellContent.rowSpan - 1);
                }
                return new ClonedCellContent(dropCellContent.getCellContent(), dropCellContent.rowSpan);
            }
            return null;
        }
    }
}

