/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.RepeatableLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableRegionLayout;

public class TableGroupLayout
extends RepeatableLayout {
    protected TableLayout tableLM = this.getTableLayoutManager();

    public TableGroupLayout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
        this.bandStatus = 3;
    }

    protected void repeatHeader() {
        if (this.bandStatus == 3) {
            return;
        }
        if (!((IGroupContent)this.content).isHeaderRepeat()) {
            return;
        }
        ITableBandContent header = this.context.getWrappedGroupHeader(this.content.getInstanceID());
        if (header == null || header.getChildren().isEmpty()) {
            return;
        }
        TableRegionLayout rLayout = this.tableLM.getTableRegionLayout();
        rLayout.initialize(header);
        rLayout.layout();
        TableArea tableRegion = (TableArea)header.getExtension(1);
        if (tableRegion != null && tableRegion.getAllocatedHeight() < this.getCurrentMaxContentHeight()) {
            TableLayout.TableContext tableContext = (TableLayout.TableContext)this.tableLM.contextList.getLast();
            tableContext.layout.addRows(rLayout.getTableAreaLayout().getRows());
            Iterator iter = tableRegion.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                this.addArea(area);
            }
        }
        this.content.setExtension(1, null);
    }

    public boolean addArea(AbstractArea area) {
        return this.addArea(area, false);
    }
}

