/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class StylePropertyMapping {
    protected static final HashMap nameMapping = new HashMap();
    protected static IElementDefn styleDefn;

    static {
        nameMapping.put("fontFamily", new Integer(52));
        nameMapping.put("fontStyle", new Integer(4));
        nameMapping.put("fontVariant", new Integer(6));
        nameMapping.put("fontWeight", new Integer(46));
        nameMapping.put("fontSize", new Integer(3));
        nameMapping.put("color", new Integer(12));
        nameMapping.put("backgroundColor", new Integer(20));
        nameMapping.put("backgroundImage", new Integer(37));
        nameMapping.put("backgroundRepeat", new Integer(14));
        nameMapping.put("backgroundAttachment", new Integer(32));
        nameMapping.put("backgroundPositionX", new Integer(48));
        nameMapping.put("backgroundPositionY", new Integer(54));
        nameMapping.put("wordSpacing", new Integer(55));
        nameMapping.put("letterSpacing", new Integer(49));
        nameMapping.put("textUnderline", new Integer(39));
        nameMapping.put("textOverline", new Integer(15));
        nameMapping.put("textLineThrough", new Integer(42));
        nameMapping.put("verticalAlign", new Integer(31));
        nameMapping.put("textTransform", new Integer(27));
        nameMapping.put("textAlign", new Integer(23));
        nameMapping.put("textIndent", new Integer(29));
        nameMapping.put("lineHeight", new Integer(16));
        nameMapping.put("whiteSpace", new Integer(53));
        nameMapping.put("marginTop", new Integer(28));
        nameMapping.put("marginBottom", new Integer(18));
        nameMapping.put("marginLeft", new Integer(1));
        nameMapping.put("marginRight", new Integer(2));
        nameMapping.put("paddingTop", new Integer(50));
        nameMapping.put("paddingBottom", new Integer(45));
        nameMapping.put("paddingLeft", new Integer(30));
        nameMapping.put("paddingRight", new Integer(44));
        nameMapping.put("borderTopWidth", new Integer(57));
        nameMapping.put("borderBottomWidth", new Integer(22));
        nameMapping.put("borderLeftWidth", new Integer(51));
        nameMapping.put("borderRightWidth", new Integer(21));
        nameMapping.put("borderTopColor", new Integer(13));
        nameMapping.put("borderBottomColor", new Integer(8));
        nameMapping.put("borderLeftColor", new Integer(41));
        nameMapping.put("borderRightColor", new Integer(7));
        nameMapping.put("borderTopStyle", new Integer(9));
        nameMapping.put("borderBottomStyle", new Integer(11));
        nameMapping.put("borderLeftStyle", new Integer(43));
        nameMapping.put("borderRightStyle", new Integer(10));
        nameMapping.put("display", new Integer(33));
        nameMapping.put("orphans", new Integer(25));
        nameMapping.put("widows", new Integer(24));
        nameMapping.put("pageBreakAfter", new Integer(56));
        nameMapping.put("pageBreakBefore", new Integer(58));
        nameMapping.put("pageBreakInside", new Integer(59));
        nameMapping.put("masterPage", new Integer(5));
        nameMapping.put("showIfBlank", new Integer(26));
        nameMapping.put("canShrink", new Integer(19));
        nameMapping.put("numberFormat", new Integer(34));
        nameMapping.put("stringFormat", new Integer(47));
        nameMapping.put("dateTimeFormat", new Integer(38));
        nameMapping.put("numberAlign", new Integer(17));
        nameMapping.put("bidiTextDirection", new Integer(0));
    }

    protected static IElementDefn getStyleDefn() {
        if (styleDefn != null) {
            return styleDefn;
        }
        styleDefn = MetaDataDictionary.getInstance().getElement("Style");
        assert (styleDefn != null);
        return styleDefn;
    }

    public static boolean canInherit(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.canInherit();
        }
        return false;
    }

    public static Object getDefaultValue(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.getDefault();
        }
        return null;
    }

    public static Object getDefaultValue(String name, ReportDesignHandle handle) {
        Object value = StylePropertyMapping.getDefaultValue(name);
        if (value == null && handle != null && handle.isDirectionRTL() && "bidiTextDirection".equals(name)) {
            return "rtl";
        }
        return value;
    }

    public static Object getDefaultValue(int index) {
        return StylePropertyMapping.getDefaultValue(nameMapping.get(new Integer(index)).toString());
    }

    public static int getPropertyID(String name) {
        int id = -1;
        Object obj = nameMapping.get(name);
        if (obj instanceof Integer) {
            id = (Integer)obj;
        }
        return id;
    }

    public static Set getPropertyMapping() {
        return nameMapping.entrySet();
    }
}

