/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IRowEventHandler;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Row;
import org.eclipse.birt.report.engine.script.internal.instance.RowInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;

public class RowScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(RowHandle rowHandle, ExecutionContext context) {
        try {
            Row row = new Row(rowHandle);
            IRowEventHandler eh = RowScriptExecutor.getEventHandler(rowHandle, context);
            if (eh != null) {
                eh.onPrepare(row, context.getReportContext());
            }
        }
        catch (Exception e) {
            RowScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IRowContent content, ExecutionContext context) {
        ReportItemDesign rowDesign = (ReportItemDesign)content.getGenerateBy();
        if (!RowScriptExecutor.needOnCreate(rowDesign)) {
            return;
        }
        try {
            RowInstance row = new RowInstance(content, context);
            if (RowScriptExecutor.handleJS(row, rowDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IRowEventHandler eh = RowScriptExecutor.getEventHandler(rowDesign, context);
            if (eh != null) {
                eh.onCreate(row, context.getReportContext());
            }
        }
        catch (Exception e) {
            RowScriptExecutor.addException(context, e, rowDesign.getHandle());
        }
    }

    public static void handleOnRender(IRowContent content, ExecutionContext context) {
        ReportItemDesign rowDesign = (ReportItemDesign)content.getGenerateBy();
        if (!RowScriptExecutor.needOnRender(rowDesign)) {
            return;
        }
        try {
            RowInstance row = new RowInstance(content, context);
            if (RowScriptExecutor.handleJS(row, rowDesign.getOnRender(), context).didRun()) {
                return;
            }
            IRowEventHandler eh = RowScriptExecutor.getEventHandler(rowDesign, context);
            if (eh != null) {
                eh.onRender(row, context.getReportContext());
            }
        }
        catch (Exception e) {
            RowScriptExecutor.addException(context, e, rowDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(IRowContent content, ExecutionContext context) {
        ReportItemDesign rowDesign = (ReportItemDesign)content.getGenerateBy();
        if (!RowScriptExecutor.needOnPageBreak(rowDesign)) {
            return;
        }
        try {
            RowInstance row = new RowInstance(content, context);
            if (RowScriptExecutor.handleJS(row, rowDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IRowEventHandler eh = RowScriptExecutor.getEventHandler(rowDesign, context);
            if (eh != null) {
                eh.onPageBreak(row, context.getReportContext());
            }
        }
        catch (Exception e) {
            RowScriptExecutor.addException(context, e, rowDesign.getHandle());
        }
    }

    private static IRowEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (IRowEventHandler)RowScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            RowScriptExecutor.addClassCastException(context, e, design.getHandle(), IRowEventHandler.class);
        }
        catch (EngineException e) {
            RowScriptExecutor.addException(context, (Exception)((Object)e), design.getHandle());
        }
        return null;
    }

    private static IRowEventHandler getEventHandler(RowHandle handle, ExecutionContext context) {
        try {
            return (IRowEventHandler)RowScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            RowScriptExecutor.addClassCastException(context, e, (DesignElementHandle)handle, IRowEventHandler.class);
        }
        catch (EngineException e) {
            RowScriptExecutor.addException(context, (Exception)((Object)e), (DesignElementHandle)handle);
        }
        return null;
    }
}

