/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import org.eclipse.birt.data.engine.executor.DiskDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.IncreDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.MemoryDataSetCacheObject;

public class DataSetCacheConfig {
    private DataSetCacheMode cacheMode;
    private int countConfig;
    private boolean isIncremental;
    private String cacheDir;

    private DataSetCacheConfig(DataSetCacheMode cacheMode, int countConfig, boolean isIncremental, String cacheDir) {
        assert (cacheMode != null && countConfig != 0);
        this.cacheMode = cacheMode;
        this.countConfig = countConfig;
        this.isIncremental = isIncremental;
        this.cacheDir = cacheDir;
    }

    public static DataSetCacheConfig getInstacne(DataSetCacheMode cacheMode, int countConfig, String cacheDir) {
        return DataSetCacheConfig.getInstance(cacheMode, countConfig, false, cacheDir);
    }

    public static DataSetCacheConfig getInstance(DataSetCacheMode cacheMode, int countConfig, boolean isIncremental, String cacheDir) {
        if (cacheMode == null || countConfig == 0) {
            return null;
        }
        return new DataSetCacheConfig(cacheMode, countConfig, isIncremental, cacheDir);
    }

    int getCountConfig() {
        return this.countConfig;
    }

    int getCacheCapability() {
        return this.countConfig < 0 ? Integer.MAX_VALUE : this.countConfig;
    }

    String getCacheDir() {
        return this.cacheDir;
    }

    IDataSetCacheObject createDataSetCacheObject() {
        if (this.cacheMode == DataSetCacheMode.IN_MEMORY) {
            return new MemoryDataSetCacheObject(this.getCacheCapability());
        }
        if (this.cacheMode == DataSetCacheMode.IN_DISK) {
            if (this.isIncremental) {
                return new IncreDataSetCacheObject(this.cacheDir);
            }
            return new DiskDataSetCacheObject(this.cacheDir, this.getCacheCapability());
        }
        assert (false);
        return null;
    }

    public static class DataSetCacheMode {
        public static final DataSetCacheMode IN_MEMORY = new DataSetCacheMode();
        public static final DataSetCacheMode IN_DISK = new DataSetCacheMode();

        private DataSetCacheMode() {
        }
    }
}

