/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.io.File;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.impl.DataSetCacheUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class IncreDataSetCacheObject
implements IDataSetCacheObject {
    public static final String TIMESTAMP_DATA = "timestamp.data";
    public static final String META_DATA = "meta.data";
    public static final String DATA_DATA = "data.data";
    private static final char PATH_SEP = File.separatorChar;
    private String cacheDir;

    public IncreDataSetCacheObject(String cacheDir) {
        this.cacheDir = String.valueOf(cacheDir) + PATH_SEP + "DataSetCacheObject_" + this.hashCode();
        new File(this.cacheDir).mkdirs();
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public File getDataFile() {
        return new File(String.valueOf(this.cacheDir) + PATH_SEP + DATA_DATA);
    }

    public File getMetaFile() {
        return new File(String.valueOf(this.cacheDir) + PATH_SEP + META_DATA);
    }

    public File getTimeStampFile() {
        return new File(String.valueOf(this.cacheDir) + PATH_SEP + TIMESTAMP_DATA);
    }

    public boolean isCachedDataReusable(int requiredMaxRowCount) {
        return true;
    }

    public boolean needUpdateCache(int requiredCapability) {
        return true;
    }

    public void release() {
        DataSetCacheUtil.deleteFile(this.cacheDir);
    }

    public IResultClass getResultClass() {
        return null;
    }
}

