/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.DiskCacheResultSet;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskCache
implements ResultSetCache {
    private int currResultIndex = -1;
    private IResultObject currResultObject;
    private int countOfResult;
    private int MemoryCacheRowCount;
    private String goalFileStr;
    private String sessionRootDirStr;
    private String tempRootDirStr;
    private DiskCacheResultSet diskBasedResultSet;
    private IResultClass rsMeta;
    private static Logger logger = Logger.getLogger(DiskCache.class.getName());
    private DataEngineSession session;

    public DiskCache(IResultObject[] resultObjects, IResultObject resultObject, IRowResultSet rowResultSet, IResultClass rsMeta, Comparator comparator, int MemoryCacheRowCount, DataEngineSession session, StopSign stopSign) throws DataException {
        this.MemoryCacheRowCount = MemoryCacheRowCount;
        this.rsMeta = rsMeta;
        this.session = session;
        this.diskBasedResultSet = new DiskCacheResultSet(this.getInfoMap());
        try {
            logger.info("Start processStartResultObjects");
            this.diskBasedResultSet.processStartResultObjects(resultObjects, comparator, stopSign);
            logger.info("Start processRestResultObjects");
            this.diskBasedResultSet.processRestResultObjects(resultObject, rowResultSet, stopSign);
        }
        catch (IOException e) {
            throw new DataException("data.engine.WriteTempError", e);
        }
        this.countOfResult = this.diskBasedResultSet.getCount();
        logger.info("End of process, and the count of data is " + this.countOfResult);
    }

    @Override
    public int getCurrentIndex() throws DataException {
        return this.currResultIndex;
    }

    @Override
    public IResultObject getCurrentResult() throws DataException {
        return this.currResultObject;
    }

    @Override
    public boolean next() throws DataException {
        if (this.currResultIndex > this.countOfResult - 1) {
            this.currResultObject = null;
        } else {
            ++this.currResultIndex;
            if (this.currResultIndex == this.countOfResult) {
                this.currResultObject = null;
            } else {
                try {
                    this.currResultObject = this.diskBasedResultSet.nextRow();
                }
                catch (IOException e) {
                    throw new DataException("data.engine.ReadTempError", e);
                }
            }
        }
        return this.currResultObject != null;
    }

    @Override
    public IResultObject fetch() throws DataException {
        this.next();
        IResultObject resultObject = this.getCurrentResult();
        return resultObject;
    }

    @Override
    public void moveTo(int destIndex) throws DataException {
        int advancedStep;
        this.checkValid(destIndex);
        if (destIndex >= this.currResultIndex) {
            advancedStep = destIndex - this.currResultIndex;
        } else {
            this.reset();
            advancedStep = destIndex + 1;
        }
        int i = 0;
        while (i < advancedStep) {
            this.next();
            ++i;
        }
        this.currResultIndex = destIndex;
        if (this.currResultIndex == -1 || this.currResultIndex == this.countOfResult) {
            this.currResultObject = null;
        }
    }

    private void checkValid(int destIndex) throws DataException {
        if (destIndex < -1 || destIndex > this.countOfResult) {
            throw new DataException("data.engine.BadDestIndex", new Object[]{new Integer(-1), new Integer(this.countOfResult)});
        }
    }

    @Override
    public int getCount() {
        return this.countOfResult;
    }

    @Override
    public void reset() throws DataException {
        this.diskBasedResultSet.reset();
        this.currResultIndex = -1;
        this.currResultObject = null;
    }

    @Override
    public void close() {
        this.diskBasedResultSet.close();
        File goalFile = new File(this.goalFileStr);
        goalFile.delete();
        File tempDir = new File(this.sessionRootDirStr);
        tempDir.delete();
        this.currResultIndex = -1;
        this.currResultObject = null;
    }

    private Map getInfoMap() throws DataException {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("tempDir", this.getTempDirStr());
        this.goalFileStr = this.getGoalFileStr();
        infoMap.put("goalFile", this.goalFileStr);
        infoMap.put("dataCountOfUnit", "" + this.MemoryCacheRowCount);
        return infoMap;
    }

    private String getTempDirStr() throws DataException {
        return String.valueOf(this.getSessionTempDirStr()) + File.separator + "temp";
    }

    private String getGoalFileStr() throws DataException {
        return String.valueOf(this.getSessionTempDirStr()) + File.separator + "goalFile";
    }

    private String getSessionTempDirStr() throws DataException {
        if (this.sessionRootDirStr != null) {
            return this.sessionRootDirStr;
        }
        if (this.tempRootDirStr == null) {
            this.tempRootDirStr = this.createTempRootDir();
        }
        this.sessionRootDirStr = CacheUtil.createSessionTempDir(this.tempRootDirStr);
        return this.sessionRootDirStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createTempRootDir() {
        if (this.tempRootDirStr != null) return this.tempRootDirStr;
        Class<DiskCache> clazz = DiskCache.class;
        synchronized (DiskCache.class) {
            if (this.tempRootDirStr != null) return this.tempRootDirStr;
            String tempDir = this.session.getTempDir();
            this.tempRootDirStr = CacheUtil.createTempRootDir(tempDir);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.tempRootDirStr;
        }
    }

    @Override
    public void doSave(DataOutputStream outputStream, DataOutputStream rowLensStream, List<IBinding> cacheRequestMap) throws DataException {
        DataOutputStream dos = new DataOutputStream(outputStream);
        Set resultSetNameSet = ResultSetUtil.getRsColumnRequestMap(cacheRequestMap);
        try {
            int rowCount = this.diskBasedResultSet.getCount();
            int colCount = this.rsMeta.getFieldCount();
            IOUtil.writeInt((OutputStream)dos, (int)rowCount);
            int currIndex = this.currResultIndex;
            this.reset();
            long offset = 4L;
            int i = 0;
            while (i < rowCount) {
                IOUtil.writeLong((DataOutputStream)rowLensStream, (long)offset);
                offset += (long)ResultSetUtil.writeResultObject(dos, this.diskBasedResultSet.nextRow(), colCount, resultSetNameSet);
                ++i;
            }
            this.reset();
            this.moveTo(currIndex);
            dos.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    @Override
    public void setResultClass(IResultClass rsMeta) throws DataException {
        this.rsMeta = rsMeta;
    }
}

