/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.jointdataset;

import java.util.ArrayList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.SmartCache;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.viewing.DummyEventHandler;
import org.eclipse.birt.data.engine.impl.jointdataset.IJoinConditionMatcher;
import org.eclipse.birt.data.engine.impl.jointdataset.IMatchResultObjectSeeker;
import org.eclipse.birt.data.engine.impl.jointdataset.JointResultMetadata;
import org.eclipse.birt.data.engine.impl.jointdataset.MatchResultSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class BaseJointDataSetPopulator
implements IDataSetPopulator {
    private JointResultMetadata meta;
    private IResultIterator primaryIterator;
    private IResultIterator secondaryIterator;
    private int joinType;
    private IJoinConditionMatcher jcm;
    private IResultObject curPrimaryResultObject = null;
    private Object[] curPrimaryMatchValues = null;
    private SmartCache curSecondaryResultObjects = null;
    private Object[] curSecondaryMatchValues = null;
    private int curComparedResult = 0;
    private boolean beInitialized = false;
    private boolean beSecondaryUsed = false;
    private DataEngineSession session;
    private int rowFetchLimit;
    private int rowCount;
    private boolean shouldContinueSeek;

    public BaseJointDataSetPopulator(IResultIterator left, IResultIterator right, JointResultMetadata meta, IJoinConditionMatcher jcm, int joinType, IMatchResultObjectSeeker seeker, DataEngineSession session, int rowFetchLimit) throws DataException {
        this.meta = meta;
        this.joinType = joinType;
        this.jcm = jcm;
        this.session = session;
        if (this.isPrimaryLeft()) {
            this.primaryIterator = left;
            this.secondaryIterator = right;
        } else {
            this.primaryIterator = right;
            this.secondaryIterator = left;
        }
        this.beInitialized = false;
        this.rowFetchLimit = rowFetchLimit;
        this.rowCount = 0;
        this.shouldContinueSeek = false;
    }

    private void initialize() throws DataException {
        this.fetchPrimaryObject();
        this.fetchSecondaryObjects();
        this.curComparedResult = this.getCompartorResult();
    }

    private boolean isPrimaryLeft() {
        return this.joinType != 2;
    }

    public IResultObject next() throws DataException {
        if (this.rowFetchLimit <= 0 || this.rowCount < this.rowFetchLimit) {
            IResultObject result = this.doNext();
            while (this.shouldContinueSeek) {
                result = this.doNext();
            }
            if (result != null) {
                ++this.rowCount;
            }
            return result;
        }
        return null;
    }

    private IResultObject doNext() throws DataException {
        this.shouldContinueSeek = false;
        if (!this.beInitialized) {
            this.initialize();
            this.beInitialized = true;
        }
        if (this.curComparedResult == 0) {
            return this.equalNext();
        }
        if (this.curComparedResult < 0) {
            return this.lessNext();
        }
        if (this.curComparedResult > 0) {
            return this.greaterNext();
        }
        return null;
    }

    private IResultObject equalNext() throws DataException {
        if (this.curSecondaryResultObjects.next()) {
            this.beSecondaryUsed = true;
            return this.createResultObject(this.curPrimaryResultObject, this.curSecondaryResultObjects.getCurrentResult());
        }
        this.fetchPrimaryObject();
        this.curComparedResult = this.getCompartorResult();
        this.shouldContinueSeek = true;
        return null;
    }

    private IResultObject lessNext() throws DataException {
        if (this.curPrimaryMatchValues == null) {
            return null;
        }
        if (this.joinType == 0 && this.curSecondaryMatchValues == null) {
            return null;
        }
        IResultObject resultObject = null;
        if (this.joinType != 0) {
            resultObject = this.createResultObject(this.curPrimaryResultObject, null);
        }
        this.fetchPrimaryObject();
        this.curComparedResult = this.getCompartorResult();
        if (this.joinType != 0) {
            return resultObject;
        }
        this.shouldContinueSeek = true;
        return null;
    }

    private IResultObject greaterNext() throws DataException {
        if (this.curPrimaryMatchValues == null && this.joinType != 3) {
            return null;
        }
        if (this.joinType == 3 && this.curSecondaryResultObjects.next() && !this.beSecondaryUsed) {
            return this.createResultObject(null, this.curSecondaryResultObjects.getCurrentResult());
        }
        this.fetchSecondaryObjects();
        this.curComparedResult = this.getCompartorResult();
        this.shouldContinueSeek = true;
        return null;
    }

    private int getCompartorResult() throws DataException {
        if (this.curPrimaryMatchValues == null && this.curSecondaryMatchValues == null) {
            return -1;
        }
        if (this.curPrimaryMatchValues != null && this.curSecondaryMatchValues == null) {
            return -1;
        }
        if (this.curPrimaryMatchValues == null && this.curSecondaryMatchValues != null) {
            return 1;
        }
        return this.jcm.compare(this.curPrimaryMatchValues, this.curSecondaryMatchValues);
    }

    private void fetchPrimaryObject() throws DataException {
        if (this.primaryIterator.getCurrentResult() == null) {
            this.curPrimaryResultObject = null;
            this.curPrimaryMatchValues = null;
        } else {
            this.curPrimaryResultObject = this.primaryIterator.getCurrentResult();
            this.curPrimaryMatchValues = this.jcm.getCompareValue(this.isPrimaryLeft());
            if (this.curSecondaryResultObjects != null) {
                this.curSecondaryResultObjects.reset();
            }
            this.primaryIterator.next();
        }
    }

    private void fetchSecondaryObjects() throws DataException {
        this.clearSecondaryObjects();
        if (this.secondaryIterator.getCurrentResult() == null) {
            return;
        }
        this.curSecondaryMatchValues = this.jcm.getCompareValue(!this.isPrimaryLeft());
        MatchResultSet resultSet = new MatchResultSet(this.secondaryIterator, this.jcm, !this.isPrimaryLeft());
        this.curSecondaryResultObjects = new SmartCache(new CacheRequest(0, new ArrayList(), null, new DummyEventHandler()), new OdiAdapter(resultSet), this.secondaryIterator.getResultClass(), this.session, new StopSign());
        this.beSecondaryUsed = false;
    }

    private void clearSecondaryObjects() {
        if (this.curSecondaryResultObjects != null) {
            this.curSecondaryResultObjects.close();
        }
        this.curSecondaryResultObjects = null;
        this.curSecondaryMatchValues = null;
    }

    private IResultObject createResultObject(IResultObject primary, IResultObject secondary) throws DataException {
        Object[] fields = new Object[this.meta.getResultClass().getFieldCount()];
        int i = 1;
        while (i <= fields.length) {
            IResultObject ri = null;
            if (this.meta.getColumnSource(i) == 1) {
                ri = this.isPrimaryLeft() ? primary : secondary;
            } else if (this.meta.getColumnSource(i) == 2) {
                ri = this.isPrimaryLeft() ? secondary : primary;
            }
            fields[i - 1] = ri == null ? null : ri.getFieldValue(this.meta.getSourceIndex(i));
            ++i;
        }
        return new ResultObject(this.meta.getResultClass(), fields);
    }
}

