/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

public class AddingNestAggregations
implements ICubeOperation {
    private static final String EXPRESSION_FORMAT = "^\\Qdata[\"\\E.+\\Q\"]\\E$";
    private IBinding[] nestAggregations;

    public AddingNestAggregations(IBinding[] nestAggregations) throws DataException {
        if (nestAggregations == null || nestAggregations.length == 0) {
            throw new IllegalArgumentException("nestAggregations is null or empty");
        }
        this.nestAggregations = new IBinding[nestAggregations.length];
        int i = 0;
        IBinding[] iBindingArray = nestAggregations;
        int n = nestAggregations.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding addedBinding = iBindingArray[n2];
            if (addedBinding == null) {
                throw new IllegalArgumentException("nestAggregations contains null member");
            }
            String bindingName = addedBinding.getBindingName();
            if (bindingName == null || bindingName.equals("")) {
                throw new DataException("data.olap.UnspecifiedBindingName");
            }
            if (!this.isExpressionValid(addedBinding) || !OlapExpressionUtil.isAggregationBinding(addedBinding)) {
                throw new DataException("data.olap.NotNestAggregationBinding", addedBinding.getBindingName());
            }
            this.nestAggregations[i++] = addedBinding;
            ++n2;
        }
    }

    public IBinding[] getNewBindings() {
        return this.nestAggregations;
    }

    private boolean isExpressionValid(IBinding binding) throws DataException {
        if (!(binding.getExpression() instanceof IScriptExpression)) {
            return false;
        }
        String expression = ((IScriptExpression)binding.getExpression()).getText();
        if (expression == null) {
            return false;
        }
        expression = expression.trim();
        return expression.matches(EXPRESSION_FORMAT);
    }
}

