/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeCursorImpl;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.script.JSLevelAccessor;
import org.eclipse.birt.data.engine.olap.script.JSMeasureAccessor;
import org.mozilla.javascript.Scriptable;

public class CubeQueryResults
implements ICubeQueryResults {
    private PreparedCubeQuery preparedQuery;
    private Scriptable scope;
    private DataEngineContext context;
    private DataEngineSession session;
    private String queryResultsId;
    private Map appContext;
    private StopSign stopSign;
    private IBaseQueryResults outResults;
    private ICubeCursor cubeCursor;
    private String name;

    public CubeQueryResults(IBaseQueryResults outResults, PreparedCubeQuery preparedQuery, DataEngineSession session, Scriptable scope, DataEngineContext context, Map appContext) {
        this.preparedQuery = preparedQuery;
        this.scope = scope;
        this.context = context;
        this.session = session;
        this.appContext = appContext;
        this.queryResultsId = ((ICubeQueryDefinition)preparedQuery.getCubeQueryDefinition()).getQueryResultsID();
        this.outResults = outResults;
        this.stopSign = new StopSign();
    }

    public ICubeCursor getCubeCursor() throws DataException {
        if (this.cubeCursor != null) {
            return this.cubeCursor;
        }
        try {
            this.stopSign.start();
            CubeQueryExecutor executor = new CubeQueryExecutor(this.outResults, (ICubeQueryDefinition)this.preparedQuery.getCubeQueryDefinition(), this.session, this.scope, this.context);
            BirtCubeView bcv = new BirtCubeView(executor, this.appContext);
            CubeCursor cubeCursor = bcv.getCubeCursor(this.stopSign);
            String newResultSetId = executor.getQueryResultsId();
            if (newResultSetId != null) {
                this.queryResultsId = newResultSetId;
            }
            this.scope.put("measure", this.scope, (Object)new JSMeasureAccessor(cubeCursor, bcv.getMeasureMapping()));
            this.scope.put("dimension", this.scope, (Object)new JSLevelAccessor((ICubeQueryDefinition)this.preparedQuery.getCubeQueryDefinition(), bcv));
            this.cubeCursor = new CubeCursorImpl(this.outResults, cubeCursor, this.scope, this.session.getEngineContext().getScriptContext(), (ICubeQueryDefinition)this.preparedQuery.getCubeQueryDefinition(), bcv);
            return this.cubeCursor;
        }
        catch (OLAPException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public String getID() {
        return this.queryResultsId;
    }

    public void close() throws BirtException {
    }

    public void cancel() {
        this.stopSign.stop();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

