/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.script.OLAPExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.filter.IFacttableRow;
import org.eclipse.birt.data.engine.olap.util.filter.IJSMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSMeasureFilterEvalHelper
implements IJSMeasureFilterEvalHelper {
    private ScriptableObject scope;
    private DummyMeasureObject dataObj;
    private IBaseExpression expr;
    private ScriptContext cx;

    public JSMeasureFilterEvalHelper(Scriptable parentScope, ScriptContext cx, IFilterDefinition cubeFilter) throws DataException {
        assert (cubeFilter != null);
        this.initialize(parentScope, cubeFilter, cx);
    }

    private void initialize(Scriptable parentScope, IFilterDefinition cubeFilter, ScriptContext cx) {
        this.scope = cx.getContext().initStandardObjects();
        this.scope.setParentScope(parentScope);
        this.dataObj = new DummyMeasureObject();
        this.expr = cubeFilter.getExpression();
        OLAPExpressionCompiler.compile(cx.getContext(), this.expr);
        this.cx = cx;
        this.scope.put("measure", (Scriptable)this.scope, (Object)this.dataObj);
    }

    public boolean evaluateFilter(IFacttableRow facttableRow) throws DataException {
        this.dataObj.setCurrentRow(facttableRow);
        try {
            Object result = ScriptEvalUtil.evalExpr(this.expr, this.cx, (Scriptable)this.scope, ScriptExpression.defaultID, 0);
            return DataTypeUtil.toBoolean((Object)result);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private class DummyMeasureObject
    extends ScriptableObject {
        private static final long serialVersionUID = 1L;
        private IFacttableRow row;

        private DummyMeasureObject() {
        }

        public String getClassName() {
            return "DummyMeasureObject";
        }

        public void setCurrentRow(IFacttableRow row) {
            this.row = row;
        }

        public Object get(String measureName, Scriptable scope) {
            try {
                return this.row.getMeasureValue(measureName);
            }
            catch (DataException dataException) {
                return null;
            }
        }
    }
}

