/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.Span;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;

public class Data
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -316995334044186083L;
    private static int ID = 0;
    public static final String DATE = "DATE";
    public static final String NUMBER = "NUMBER";
    public static final String STRING = "STRING";
    public static final String CALENDAR = "CALENDAR";
    public static final String CDATETIME = "CDATETIME";
    private XlsContainer container;
    private int rowSpanInDesign;
    Object txt;
    int styleId;
    int id;
    String datatype = "STRING";
    StyleEntry style;
    Span span;
    int rspan = 0;
    boolean processed = false;
    ContainerSizeInfo sizeInfo;
    HyperlinkDef url;
    BookmarkDef bookmark;
    boolean isTxtData = true;
    Logger log = Logger.getLogger(Data.class.getName());

    public Data(Object txt, String datatype, XlsContainer container) {
        this(txt, null, datatype, container);
    }

    public Data(Object txt, StyleEntry s, String datatype, XlsContainer container) {
        this(txt, s, datatype, container, 0);
    }

    public Data(Object txt, StyleEntry s, String datatype, XlsContainer container, int rowSpanOfDesign) {
        this.txt = txt;
        this.style = s;
        this.datatype = datatype;
        this.id = ID++;
        this.container = container;
        this.rowSpanInDesign = 0;
    }

    protected void setNotTxtData() {
        this.isTxtData = false;
    }

    public String getText() {
        if (this.txt == null) {
            return " ";
        }
        return this.txt.toString();
    }

    public void formatTxt() {
        if (this.txt == null) {
            return;
        }
        if (this.datatype.equals(DATE)) {
            this.txt = ExcelUtil.formatDate(this.txt);
        } else if (this.datatype.equals(NUMBER)) {
            Number number = (Number)this.txt;
            if (ExcelUtil.isBigNumber(number)) {
                this.txt = ExcelUtil.formatNumberAsScienceNotation(number);
            } else if (number.toString().length() > 31) {
                this.txt = ExcelUtil.displayedAsScientific(number) ? ExcelUtil.formatNumberAsScienceNotation(number) : ExcelUtil.formatNumberAsDecimal(number);
            }
        }
    }

    public boolean isBigNumber() {
        if (this.txt == null) {
            return false;
        }
        if (this.datatype.equals(NUMBER)) {
            return ExcelUtil.isBigNumber(this.txt);
        }
        return false;
    }

    public boolean isInfility() {
        if (this.txt == null) {
            return false;
        }
        if (this.datatype.equals(NUMBER)) {
            return ExcelUtil.isInfinity(this.txt);
        }
        return false;
    }

    public Object getValue() {
        return this.txt;
    }

    public int hashCode() {
        return this.id;
    }

    public void setDatatype(String type) {
        this.datatype = type;
    }

    public String getDatatype() {
        return this.datatype;
    }

    protected Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.log.log(Level.WARNING, "clone data failed");
        }
        return o;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Data)) {
            return false;
        }
        Data data = (Data)o;
        return data.id == this.id;
    }

    public void setStyleId(int id) {
        this.styleId = id;
    }

    public int getStyleId() {
        return this.styleId;
    }

    public void setStyleEntry(StyleEntry entry) {
        this.style = entry;
    }

    public StyleEntry getStyleEntry() {
        return this.style;
    }

    public HyperlinkDef getHyperlinkDef() {
        return this.url;
    }

    public void setHyperlinkDef(HyperlinkDef def) {
        this.url = def;
    }

    public void setSizeInfo(ContainerSizeInfo sizeInfo) {
        this.sizeInfo = sizeInfo;
    }

    public ContainerSizeInfo getRule() {
        return this.sizeInfo;
    }

    public void setSpan(Span span) {
        this.span = span;
    }

    public Span getSpan() {
        return this.span;
    }

    public int getRowSpan() {
        return this.rspan;
    }

    public void setRowSpan(int rs) {
        if (rs > 0) {
            this.rspan = rs;
        }
    }

    public void setProcessed(boolean pro) {
        this.processed = pro;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public BookmarkDef getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(BookmarkDef bookmark) {
        this.bookmark = bookmark;
    }

    public XlsContainer getContainer() {
        return this.container;
    }

    public void clearContainer() {
        this.container = null;
    }

    public boolean isBlank() {
        return false;
    }

    public int getRowSpanInDesign() {
        return this.rowSpanInDesign;
    }

    public void setRowSpanInDesign(int rowSpan) {
        this.rowSpanInDesign = rowSpan;
    }

    public void decreasRowSpanInDesign() {
        --this.rowSpanInDesign;
    }
}

