/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;

public class ExcelWriter {
    private static Double temp = Double.NaN;
    private static String NAN_STRING = temp.toString();
    private boolean isRTLSheet = false;
    public static final int rightToLeftisTrue = 1;
    private XMLWriterXLS writer = new XMLWriterXLS();
    private static HashSet splitChar = new HashSet();
    protected static Logger logger;
    ExcelContext context = null;
    private Set<String> bookmarkNames = new HashSet<String>();

    static {
        splitChar.add(new Character(' '));
        splitChar.add(new Character('\r'));
        splitChar.add(new Character('\n'));
        logger = Logger.getLogger(ExcelWriter.class.getName());
    }

    public ExcelWriter(OutputStream out, ExcelContext context) {
        this(out, "UTF-8", context);
    }

    public ExcelWriter(OutputStream out) {
        this.writer.open(out, "UTF-8");
    }

    public ExcelWriter(OutputStream out, String encoding, ExcelContext context) {
        this.context = context;
        this.writer.open(out, encoding);
    }

    public ExcelWriter(OutputStream out, boolean isRTLSheet) {
        this.isRTLSheet = isRTLSheet;
        this.writer.open(out, "UTF-8");
    }

    public ExcelWriter(OutputStream out, ExcelContext context, boolean isRTLSheet) {
        this(out, "UTF-8", context);
        this.isRTLSheet = isRTLSheet;
    }

    public ExcelWriter(OutputStream out, String encoding, ExcelContext context, boolean isRTLSheet) {
        this.context = context;
        this.isRTLSheet = isRTLSheet;
        this.writer.open(out, encoding);
    }

    public void writeDocumentProperties(IReportContent reportContent) {
        this.writer.openTag("DocumentProperties");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:office");
        this.writer.openTag("Author");
        this.writer.text(reportContent.getDesign().getReportDesign().getStringProperty("author"));
        this.writer.closeTag("Author");
        this.writer.openTag("Title");
        this.writer.text(reportContent.getDesign().getReportDesign().getStringProperty("title"));
        this.writer.closeTag("Title");
        this.writer.openTag("Description");
        this.writer.text(reportContent.getDesign().getReportDesign().getStringProperty("description"));
        this.writer.closeTag("Description");
        this.writer.closeTag("DocumentProperties");
    }

    public void writeText(Data d) {
        this.writer.openTag("Data");
        if (d.getDatatype().equals("NUMBER")) {
            if (d.getText().equals(NAN_STRING) || d.isBigNumber() || d.isInfility()) {
                this.writer.attribute("ss:Type", "String");
            } else {
                this.writer.attribute("ss:Type", "Number");
            }
        } else if (d.getDatatype().equals("DATE")) {
            this.writer.attribute("ss:Type", "DateTime");
        } else {
            this.writer.attribute("ss:Type", "String");
        }
        d.formatTxt();
        String txt = d.getText();
        if ("capitalize".equalsIgnoreCase(d.getStyleEntry().getProperty(26))) {
            txt = this.capitalize(txt);
        } else if ("uppercase".equalsIgnoreCase(d.getStyleEntry().getProperty(26))) {
            txt = txt.toUpperCase();
        } else if ("lowercase".equalsIgnoreCase(d.getStyleEntry().getProperty(26))) {
            txt = txt.toLowerCase();
        }
        this.writer.text(txt);
        this.writer.closeTag("Data");
    }

    private String capitalize(String text) {
        boolean capitalizeNextChar = true;
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            Character c = new Character(text.charAt(i));
            if (splitChar.contains(c)) {
                capitalizeNextChar = true;
            } else if (capitalizeNextChar) {
                array[i] = Character.toUpperCase(array[i]);
                capitalizeNextChar = false;
            }
            ++i;
        }
        return new String(array);
    }

    public void startRow() {
        this.writer.openTag("Row");
    }

    public void endRow() {
        this.writer.closeTag("Row");
    }

    public void startCell(int cellindex, int colspan, int rowspan, int styleid, HyperlinkDef hyperLink) {
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", cellindex);
        this.writer.attribute("ss:StyleID", styleid);
        if (hyperLink != null) {
            String urlAddress = hyperLink.getUrl();
            if (hyperLink.getType() == 2) {
                urlAddress = "#" + urlAddress;
            }
            if (urlAddress.length() >= 255) {
                logger.log(Level.WARNING, "The URL: {" + urlAddress + "} is too long!");
                urlAddress = urlAddress.substring(0, 254);
            }
            this.writer.attribute("ss:HRef", urlAddress);
        }
        this.writer.attribute("ss:MergeAcross", colspan);
        this.writer.attribute("ss:MergeDown", rowspan);
    }

    public void writeDefaultCell(Data d) {
        this.writer.openTag("Cell");
        if (d.getStyleId() != 0) {
            this.writer.attribute("ss:StyleID", d.getStyleId());
        }
        this.writeText(d);
        this.writer.closeTag("Cell");
    }

    protected void writeTxtData(Data d) {
        this.startCell(d.span.getCol(), d.span.getColSpan(), d.getRowSpan(), d.styleId, d.url);
        this.writeText(d);
        if (d.url != null && d.url.getToolTip() != null) {
            this.writeComments(d.url);
        }
        this.endCell();
    }

    protected void writeComments(HyperlinkDef linkDef) {
        String toolTip = linkDef.getToolTip();
        this.writer.openTag("Comment");
        this.writer.openTag("ss:Data");
        this.writer.attribute("xmlns", "http://www.w3.org/TR/REC-html40");
        this.writer.openTag("Font");
        this.writer.text(toolTip);
        this.writer.closeTag("Font");
        this.writer.closeTag("ss:Data");
        this.writer.closeTag("Comment");
    }

    protected void writeFormulaData(Data d) {
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", d.span.getCol());
        this.writer.attribute("ss:Formula", d.txt.toString());
        this.writer.attribute("ss:MergeAcross", d.span.getColSpan());
        this.writer.attribute("ss:StyleID", d.styleId);
        this.writer.closeTag("Cell");
    }

    public void endCell() {
        this.writer.closeTag("Cell");
    }

    public void writeAlignment(String horizontal, String vertical, String direction, boolean wrapText) {
        this.writer.openTag("Alignment");
        if (this.isValid(horizontal)) {
            this.writer.attribute("ss:Horizontal", horizontal);
        }
        if (this.isValid(vertical)) {
            this.writer.attribute("ss:Vertical", vertical);
        }
        if (this.isValid(direction)) {
            if ("rtl".equals(direction)) {
                this.writer.attribute("ss:ReadingOrder", "RightToLeft");
            } else {
                this.writer.attribute("ss:ReadingOrder", "LeftToRight");
            }
        }
        if (wrapText) {
            this.writer.attribute("ss:WrapText", "1");
        }
        this.writer.closeTag("Alignment");
    }

    public void writeBorder(String position, String lineStyle, String weight, String color) {
        this.writer.openTag("Border");
        this.writer.attribute("ss:Position", position);
        if (this.isValid(lineStyle)) {
            this.writer.attribute("ss:LineStyle", lineStyle);
        }
        if (this.isValid(weight)) {
            this.writer.attribute("ss:Weight", weight);
        }
        if (this.isValid(color)) {
            this.writer.attribute("ss:Color", color);
        }
        this.writer.closeTag("Border");
    }

    public void writeFont(String fontName, String size, String bold, String italic, String strikeThrough, String underline, String color) {
        this.writer.openTag("Font");
        if (this.isValid(fontName)) {
            this.writer.attribute("ss:FontName", fontName);
        }
        if (this.isValid(size)) {
            this.writer.attribute("ss:Size", size);
        }
        if (this.isValid(bold)) {
            this.writer.attribute("ss:Bold", bold);
        }
        if (this.isValid(italic)) {
            this.writer.attribute("ss:Italic", italic);
        }
        if (this.isValid(strikeThrough)) {
            this.writer.attribute("ss:StrikeThrough", strikeThrough);
        }
        if (this.isValid(underline) && !"0".equalsIgnoreCase(underline)) {
            this.writer.attribute("ss:Underline", "Single");
        }
        if (this.isValid(color)) {
            this.writer.attribute("ss:Color", color);
        }
        this.writer.closeTag("Font");
    }

    public void writeBackGroudColor(String bgColor) {
        if (this.isValid(bgColor)) {
            this.writer.openTag("Interior");
            this.writer.attribute("ss:Color", bgColor);
            this.writer.attribute("ss:Pattern", "Solid");
            this.writer.closeTag("Interior");
        }
    }

    private boolean isValid(String value) {
        return !StyleEntry.isNull(value);
    }

    private void declareStyle(StyleEntry style, int id) {
        boolean wrapText = this.context.getWrappingText();
        this.writer.openTag("Style");
        this.writer.attribute("ss:ID", id);
        if (id >= 20) {
            String direction = style.getProperty(27);
            String horizontalAlign = style.getProperty(8);
            String verticalAlign = style.getProperty(9);
            this.writeAlignment(horizontalAlign, verticalAlign, direction, wrapText);
            this.writer.openTag("Borders");
            String bottomColor = style.getProperty(10);
            String bottomLineStyle = style.getProperty(11);
            String bottomWeight = style.getProperty(12);
            this.writeBorder("Bottom", bottomLineStyle, bottomWeight, bottomColor);
            String topColor = style.getProperty(13);
            String topLineStyle = style.getProperty(14);
            String topWeight = style.getProperty(15);
            this.writeBorder("Top", topLineStyle, topWeight, topColor);
            String leftColor = style.getProperty(16);
            String leftLineStyle = style.getProperty(17);
            String leftWeight = style.getProperty(18);
            this.writeBorder("Left", leftLineStyle, leftWeight, leftColor);
            String rightColor = style.getProperty(19);
            String rightLineStyle = style.getProperty(20);
            String rightWeight = style.getProperty(21);
            this.writeBorder("Right", rightLineStyle, rightWeight, rightColor);
            this.writer.closeTag("Borders");
            String fontName = style.getProperty(0);
            String size = style.getProperty(1);
            String fontStyle = style.getProperty(2);
            String fontWeight = style.getProperty(3);
            String strikeThrough = style.getProperty(4);
            String underline = style.getProperty(5);
            String color = style.getProperty(7);
            this.writeFont(fontName, size, fontWeight, fontStyle, strikeThrough, underline, color);
            String bgColor = style.getProperty(6);
            this.writeBackGroudColor(bgColor);
        }
        this.writeDataFormat(style);
        this.writer.closeTag("Style");
    }

    public void writeDataFormat(StyleEntry style) {
        if (style.getProperty(25) == "DATE" && style.getProperty(22) != null) {
            this.writer.openTag("NumberFormat");
            this.writer.attribute("ss:Format", style.getProperty(22));
            this.writer.closeTag("NumberFormat");
        }
        if (style.getProperty(25) == "NUMBER" && style.getProperty(23) != null) {
            this.writer.openTag("NumberFormat");
            String numberStyle = style.getProperty(23);
            this.writer.attribute("ss:Format", numberStyle);
            this.writer.closeTag("NumberFormat");
        }
    }

    public void writeDeclarations() {
        this.writer.startWriter();
        this.writer.getPrint().println();
        this.writer.getPrint().println("<?mso-application progid=\"Excel.Sheet\"?>");
        this.writer.openTag("Workbook");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.attribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        this.writer.attribute("xmlns:x", "urn:schemas-microsoft-com:office:excel");
        this.writer.attribute("xmlns:ss", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.attribute("xmlns:html", "http://www.w3.org/TR/REC-html40");
    }

    public void declareStyles(Map style2id) {
        this.writer.openTag("Styles");
        for (Map.Entry entry : style2id.entrySet()) {
            Object style = entry.getKey();
            int id = (Integer)entry.getValue();
            this.declareStyle((StyleEntry)style, id);
        }
        this.writer.closeTag("Styles");
    }

    public void defineNames(List namesRefer) {
        this.writer.openTag("Names");
        for (BookmarkDef bookmark : namesRefer) {
            String name = bookmark.getName();
            String refer = bookmark.getRefer();
            if (!this.bookmarkNames.contains(name)) {
                this.defineName(name, refer);
                this.bookmarkNames.add(name);
                continue;
            }
            logger.log(Level.WARNING, "bookmark name is repeated : " + name);
        }
        this.writer.closeTag("Names");
        this.bookmarkNames.clear();
    }

    private void defineName(String name, String refer) {
        this.writer.openTag("NamedRange");
        this.writer.attribute("ss:Name", name);
        this.writer.attribute("ss:RefersTo", refer);
        this.writer.closeTag("NamedRange");
    }

    public void close(boolean complete) {
        if (complete) {
            this.writer.closeTag("Workbook");
        }
        this.writer.close();
    }

    public void startSheet(String name) {
        this.writer.openTag("Worksheet");
        this.writer.attribute("ss:Name", name);
        if (this.isRTLSheet) {
            this.writer.attribute("ss:RightToLeft", 1);
        }
    }

    public void startSheet(int sheetIndex) {
        this.startSheet("Sheet" + String.valueOf(sheetIndex));
    }

    public void closeSheet() {
        this.writer.closeTag("Worksheet");
    }

    public void startTable(int[] width) {
        this.writer.openTag("ss:Table");
        if (width == null) {
            logger.log(Level.SEVERE, "Invalid columns width");
            return;
        }
        int i = 0;
        while (i < width.length) {
            this.writer.openTag("ss:Column");
            this.writer.attribute("ss:Width", width[i]);
            this.writer.closeTag("ss:Column");
            ++i;
        }
    }

    public void endTable() {
        this.writer.closeTag("ss:Table");
    }

    public void insertHorizontalMargin(int height, int span) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        this.writer.attribute("ss:Height", height);
        this.writer.openTag("Cell");
        this.writer.attribute(" ss:MergeAcross", span);
        this.writer.closeTag("Cell");
        this.writer.closeTag("Row");
    }

    public void insertVerticalMargin(int start, int end, int length) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        this.writer.attribute("ss:Height", 1);
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", start);
        this.writer.attribute(" ss:MergeDown", length);
        this.writer.closeTag("Cell");
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", end);
        this.writer.attribute(" ss:MergeDown", length);
        this.writer.closeTag("Cell");
        this.writer.closeTag("Row");
    }

    public void insertSheet(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                this.writer.literal(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void declareWorkSheetOptions(String orientation, String pageHeader, String pageFooter) {
        this.writer.openTag("WorksheetOptions");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:excel");
        this.writer.openTag("PageSetup");
        if (orientation != null) {
            this.writer.openTag("Layout");
            this.writer.attribute("x:Orientation", orientation);
            this.writer.closeTag("Layout");
        }
        if (pageHeader != null) {
            this.writer.openTag("Header");
            this.writer.attribute("x:Data", pageHeader);
            this.writer.closeTag("Header");
        }
        if (pageFooter != null) {
            this.writer.openTag("Footer");
            this.writer.attribute("x:Data", pageFooter);
            this.writer.closeTag("Footer");
        }
        this.writer.closeTag("PageSetup");
        this.writer.closeTag("WorksheetOptions");
    }

    private class XMLWriterXLS
    extends XMLWriter {
        private XMLWriterXLS() {
        }

        public PrintWriter getPrint() {
            return this.printWriter;
        }

        protected String getEscapedStr(String s, boolean whitespace) {
            s = super.getEscapedStr(s, whitespace);
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            int max = s.length();
            while (i < max) {
                char c = s.charAt(i);
                if (c == '\n' || c == '\r') {
                    buffer.append("&#10;");
                    if (c == '\r' && i + 1 < max && s.charAt(i + 1) == '\n') {
                        ++i;
                    }
                } else {
                    buffer.append(c);
                }
                ++i;
            }
            return buffer.toString();
        }
    }
}

