/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.LayoutUtil;
import org.eclipse.birt.report.engine.emitter.excel.layout.TableInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;

public class XlsTable
extends XlsContainer {
    private int[] columnWidths;
    private int width;

    public XlsTable(StyleEntry entry, ContainerSizeInfo sizeInfo, XlsContainer parent) {
        super(entry, sizeInfo, parent);
    }

    public XlsTable(TableInfo table, StyleEntry entry, ContainerSizeInfo sizeInfo, XlsContainer parent) {
        this(entry, sizeInfo, parent);
        this.width = Math.min(table.getTableWidth(), sizeInfo.getWidth());
        this.columnWidths = LayoutUtil.getColumnWidth(table, this.width);
        this.width = table.getTableWidth();
    }

    public XlsTable(TableInfo table, XlsContainer container) {
        this(table, container.getStyle(), container.getSizeInfo(), container);
    }

    public ContainerSizeInfo getColumnSizeInfo(int column, int span) {
        int startCoordinate = this.getSizeInfo().getStartCoordinate();
        int i = 0;
        while (i < column) {
            startCoordinate += this.columnWidths[i];
            ++i;
        }
        int endCoordinate = 0;
        int i2 = column;
        while (i2 < column + span) {
            endCoordinate += this.columnWidths[i2];
            ++i2;
        }
        return new ContainerSizeInfo(startCoordinate, endCoordinate);
    }
}

