/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCornerHeaderRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabHeaderRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabMeasureHeaderRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;

public class CrosstabHeaderExecutor
extends BaseCrosstabExecutor {
    private static final Logger logger = Logger.getLogger(CrosstabHeaderExecutor.class.getName());
    private boolean hasMeasureHeader;
    private boolean useCornerHeader;
    private int currentGroupIndex;
    private long resetRowCursorPosition = -1L;

    public CrosstabHeaderExecutor(BaseCrosstabExecutor parent) {
        super(parent);
    }

    public IContent execute() {
        ITableBandContent content = this.context.getReportContent().createTableBandContent();
        content.setBandType(1);
        this.initializeContent((IContent)content, null);
        this.prepareChildren();
        return content;
    }

    public void close() {
        try {
            EdgeCursor rowCursor = this.getRowEdgeCursor();
            if (rowCursor != null && this.resetRowCursorPosition != -1L) {
                rowCursor.setPosition(this.resetRowCursorPosition);
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabHeaderExecutor.error.reset.row.position"), e);
        }
        this.resetRowCursorPosition = -1L;
        super.close();
    }

    private void prepareChildren() {
        try {
            EdgeCursor rowCursor = this.getRowEdgeCursor();
            if (rowCursor != null) {
                this.resetRowCursorPosition = rowCursor.getPosition();
                rowCursor.setPosition(-1L);
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabHeaderExecutor.error.reset.row.position"), e);
        }
        this.currentGroupIndex = 0;
        this.hasMeasureHeader = GroupUtil.hasMeasureHeader(this.crosstabItem, 1);
        this.useCornerHeader = this.columnGroups.size() == 0 && !this.hasMeasureHeader && this.crosstabItem.getHeader() != null;
    }

    public IReportItemExecutor getNextChild() {
        BaseCrosstabExecutor nextExecutor = null;
        if (this.currentGroupIndex < this.columnGroups.size()) {
            EdgeGroup eg = (EdgeGroup)this.columnGroups.get(this.currentGroupIndex++);
            DimensionViewHandle dv = this.crosstabItem.getDimension(1, eg.dimensionIndex);
            LevelViewHandle lv = dv.getLevel(eg.levelIndex);
            nextExecutor = new CrosstabHeaderRowExecutor(this, lv);
        } else if (this.hasMeasureHeader) {
            nextExecutor = new CrosstabMeasureHeaderRowExecutor(this);
            this.hasMeasureHeader = false;
        } else if (this.useCornerHeader) {
            nextExecutor = new CrosstabCornerHeaderRowExecutor(this);
            this.useCornerHeader = false;
        }
        return nextExecutor;
    }

    public boolean hasNextChild() {
        if (this.currentGroupIndex < this.columnGroups.size()) {
            return true;
        }
        if (this.hasMeasureHeader) {
            return true;
        }
        return this.useCornerHeader;
    }
}

