/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IDataAction;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;
import org.eclipse.birt.report.utility.UrlUtility;

class ViewerHTMLActionHandler
extends HTMLActionHandler {
    protected Logger log = Logger.getLogger(ViewerHTMLActionHandler.class.getName());
    protected IReportDocument document = null;
    protected Locale locale = null;
    protected TimeZone timeZone = null;
    protected long page = -1L;
    protected boolean isEmbeddable = false;
    protected boolean isRtl = false;
    protected boolean isMasterPageContent = true;
    protected String hostFormat = null;
    protected String resourceFolder = null;
    protected Boolean svg = null;
    protected String isDesigner = null;
    protected String pageOverflow = null;

    public ViewerHTMLActionHandler() {
    }

    public ViewerHTMLActionHandler(IReportDocument document, long page, Locale locale, TimeZone timeZone, boolean isEmbeddable, boolean isRtl, boolean isMasterPageContent, String format, Boolean svg, String isDesigner) {
        this.document = document;
        this.page = page;
        this.locale = locale;
        this.timeZone = timeZone;
        this.isEmbeddable = isEmbeddable;
        this.isRtl = isRtl;
        this.isMasterPageContent = isMasterPageContent;
        this.hostFormat = format;
        this.svg = svg;
        this.isDesigner = isDesigner;
    }

    public ViewerHTMLActionHandler(Locale locale, TimeZone timeZone, boolean isRtl, boolean isMasterPageContent, String format, Boolean svg, String isDesigner) {
        this.locale = locale;
        this.timeZone = timeZone;
        this.isRtl = isRtl;
        this.isMasterPageContent = isMasterPageContent;
        this.hostFormat = format;
        this.svg = svg;
        this.isDesigner = isDesigner;
    }

    public String getURL(IAction actionDefn, IReportContext context) {
        if (actionDefn == null) {
            return null;
        }
        switch (actionDefn.getType()) {
            case 2: {
                return this.buildBookmarkAction(actionDefn, context);
            }
            case 1: {
                return this.buildHyperlink(actionDefn, context);
            }
            case 3: {
                return this.buildDrillAction(actionDefn, context);
            }
            case 4: {
                return this.buildDataAction((IDataAction)actionDefn, context);
            }
        }
        return null;
    }

    public String getURL(IAction actionDefn, Object context) {
        if (actionDefn == null) {
            return null;
        }
        if (context instanceof IReportContext) {
            return this.getURL(actionDefn, (IReportContext)context);
        }
        throw new IllegalArgumentException("The context is of wrong type.");
    }

    private String buildHyperlink(IAction action, IReportContext context) {
        ModuleHandle moduleHandle;
        URL url;
        IReportRunnable runnable = context.getReportRunnable();
        String actionURL = action.getActionString();
        if (runnable != null && (url = (moduleHandle = runnable.getDesignHandle().getModuleHandle()).findResource(actionURL, -1)) != null) {
            actionURL = url.toString();
        }
        return actionURL;
    }

    protected String buildBookmarkAction(IAction action, IReportContext context) {
        if (action == null || context == null) {
            return null;
        }
        String baseURL = null;
        Object renderContext = this.getRenderContext(context);
        if (renderContext instanceof HTMLRenderContext) {
            baseURL = ((HTMLRenderContext)renderContext).getBaseURL();
        }
        if (renderContext instanceof PDFRenderContext) {
            baseURL = ((PDFRenderContext)renderContext).getBaseURL();
        }
        if (baseURL == null) {
            baseURL = "preview";
        }
        String bookmark = action.getBookmark();
        if (baseURL.lastIndexOf("/frameset") > 0 || baseURL.lastIndexOf("/run") > 0) {
            String func = "catchBookmark('" + ParameterAccessor.htmlEncode(bookmark) + "');";
            return "javascript:try{" + func + "}catch(e){parent." + func + "};";
        }
        StringBuffer link = new StringBuffer();
        boolean realBookmark = false;
        if (this.document != null) {
            long pageNumber = this.document.getPageNumber(action.getBookmark());
            realBookmark = pageNumber == this.page && !this.isEmbeddable;
        }
        try {
            bookmark = URLEncoder.encode(bookmark, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        link.append(baseURL);
        link.append("?");
        if (this.document != null) {
            link.append("__document");
            link.append("=");
            String documentName = this.document.getName();
            try {
                documentName = URLEncoder.encode(documentName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            link.append(documentName);
        } else if (action.getReportName() != null && action.getReportName().length() > 0) {
            link.append("__report");
            link.append("=");
            String reportName = this.getReportName(context, action);
            try {
                reportName = URLEncoder.encode(reportName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            link.append(reportName);
        } else {
            return "#" + action.getActionString();
        }
        if (this.locale != null) {
            link.append(ParameterAccessor.getQueryParameterString("__locale", this.locale.toString()));
        }
        if (this.timeZone != null) {
            link.append(ParameterAccessor.getQueryParameterString("__timezone", this.timeZone.getID()));
        }
        if (this.isRtl) {
            link.append(ParameterAccessor.getQueryParameterString("__rtl", String.valueOf(this.isRtl)));
        }
        if (this.svg != null) {
            link.append(ParameterAccessor.getQueryParameterString("__svg", String.valueOf(this.svg)));
        }
        if (this.isDesigner != null) {
            link.append(ParameterAccessor.getQueryParameterString("__designer", String.valueOf(this.isDesigner)));
        }
        if (this.pageOverflow != null) {
            link.append(ParameterAccessor.getQueryParameterString("__pageoverflow", this.pageOverflow));
        }
        link.append(ParameterAccessor.getQueryParameterString("__masterpage", String.valueOf(this.isMasterPageContent)));
        try {
            if (this.resourceFolder != null) {
                String res = URLEncoder.encode(this.resourceFolder, "UTF-8");
                link.append(ParameterAccessor.getQueryParameterString("__resourceFolder", res));
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (realBookmark) {
            link.append("#");
            link.append(bookmark);
        } else {
            link.append(ParameterAccessor.getQueryParameterString("__bookmark", bookmark));
            if (!action.isBookmark()) {
                link.append(ParameterAccessor.getQueryParameterString("__istoc", "true"));
            }
        }
        return link.toString();
    }

    protected String buildDataAction(IDataAction action, IReportContext context) {
        if (action == null || context == null) {
            return null;
        }
        boolean encodePaths = false;
        String actionString = action.getActionString();
        Map params = UrlUtility.extractUriParameters(actionString);
        String anchor = UrlUtility.getAnchor(actionString);
        String encodedPathsString = (String)params.get("__encodedPaths");
        encodePaths = encodedPathsString != null && Boolean.valueOf(encodedPathsString) != false;
        String baseURL = null;
        Object renderContext = this.getRenderContext(context);
        if (renderContext instanceof HTMLRenderContext) {
            baseURL = ((HTMLRenderContext)renderContext).getBaseURL();
        }
        if (renderContext instanceof PDFRenderContext) {
            baseURL = ((PDFRenderContext)renderContext).getBaseURL();
        }
        baseURL = this.createBaseURLWithExtractPattern(baseURL);
        if (this.document != null) {
            String documentName = this.document.getName();
            if (encodePaths) {
                documentName = ParameterAccessor.encodeBase64(documentName);
            }
            params.put("__document", documentName);
        } else if (action.getReportName() != null && action.getReportName().length() > 0) {
            String reportName = this.getReportName(context, (IAction)action);
            if (encodePaths) {
                reportName = ParameterAccessor.encodeBase64(reportName);
            }
            params.put("__report", reportName);
        }
        this.createURLWithExtractInfo(action, params);
        if (this.locale != null) {
            params.put("__locale", this.locale.toString());
        }
        if (this.timeZone != null) {
            params.put("__timezone", this.timeZone.getID());
        }
        if (this.isRtl) {
            params.put("__rtl", String.valueOf(this.isRtl));
        }
        if (this.resourceFolder != null) {
            if (encodePaths) {
                this.resourceFolder = ParameterAccessor.encodeBase64(this.resourceFolder);
            }
            params.put("__resourceFolder", this.resourceFolder);
        }
        return UrlUtility.buildUrl(baseURL, params, anchor);
    }

    protected String buildDrillAction(IAction action, IReportContext context) {
        if (action == null || context == null) {
            return null;
        }
        String baseURL = null;
        Object renderContext = this.getRenderContext(context);
        if (renderContext instanceof HTMLRenderContext) {
            baseURL = ((HTMLRenderContext)renderContext).getBaseURL();
        }
        if (renderContext instanceof PDFRenderContext) {
            baseURL = ((PDFRenderContext)renderContext).getBaseURL();
        }
        if (baseURL == null) {
            baseURL = "preview";
        }
        StringBuffer link = new StringBuffer();
        String reportName = this.getReportName(context, action);
        if (reportName != null && !reportName.equals("")) {
            link.append(baseURL);
            link.append(reportName.toLowerCase().endsWith(".rptdocument") ? "?__document=" : "?__report=");
            try {
                link.append(URLEncoder.encode(reportName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
            String format = action.getFormat();
            if (format == null || format.length() == 0) {
                format = this.hostFormat;
            }
            if (format != null && format.length() > 0) {
                link.append(ParameterAccessor.getQueryParameterString("__format", format));
            }
            if (action.getParameterBindings() != null) {
                for (Map.Entry entry : action.getParameterBindings().entrySet()) {
                    try {
                        String key = (String)entry.getKey();
                        Object valueObj = entry.getValue();
                        if (valueObj == null) continue;
                        Object[] values = valueObj instanceof Object[] ? (Object[])valueObj : new Object[]{valueObj};
                        for (int i = 0; i < values.length; ++i) {
                            String value = DataUtil.getDisplayValue(values[i], this.timeZone);
                            if (value != null) {
                                link.append(ParameterAccessor.getQueryParameterString(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(value, "UTF-8")));
                                continue;
                            }
                            link.append(ParameterAccessor.getQueryParameterString("__isnull", URLEncoder.encode(key, "UTF-8")));
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                    }
                }
                if (!reportName.toLowerCase().endsWith(".rptdocument") && baseURL.lastIndexOf("/frameset") > 0) {
                    link.append(ParameterAccessor.getQueryParameterString("__overwrite", String.valueOf(true)));
                }
            }
            if (this.locale != null) {
                link.append(ParameterAccessor.getQueryParameterString("__locale", this.locale.toString()));
            }
            if (this.timeZone != null) {
                link.append(ParameterAccessor.getQueryParameterString("__timezone", this.timeZone.getID()));
            }
            if (this.isRtl) {
                link.append(ParameterAccessor.getQueryParameterString("__rtl", String.valueOf(this.isRtl)));
            }
            if (this.svg != null) {
                link.append(ParameterAccessor.getQueryParameterString("__svg", String.valueOf(this.svg)));
            }
            if (this.isDesigner != null) {
                link.append(ParameterAccessor.getQueryParameterString("__designer", String.valueOf(this.isDesigner)));
            }
            if (this.pageOverflow != null) {
                link.append(ParameterAccessor.getQueryParameterString("__pageoverflow", this.pageOverflow));
            }
            link.append(ParameterAccessor.getQueryParameterString("__masterpage", String.valueOf(this.isMasterPageContent)));
            try {
                if (this.resourceFolder != null) {
                    String res = URLEncoder.encode(this.resourceFolder, "UTF-8");
                    link.append(ParameterAccessor.getQueryParameterString("__resourceFolder", res));
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            String bookmark = action.getBookmark();
            if (bookmark != null) {
                try {
                    if (baseURL.lastIndexOf("/preview") > 0 || "pdf".equalsIgnoreCase(format)) {
                        link.append("#");
                        if (!action.isBookmark() && reportName.toLowerCase().endsWith(".rptdocument")) {
                            InputOptions options = new InputOptions();
                            options.setOption("locale", this.locale);
                            options.setOption("timeZone", this.timeZone);
                            bookmark = BirtReportServiceFactory.getReportService().findTocByName(reportName, bookmark, options);
                        }
                        link.append(URLEncoder.encode(bookmark, "UTF-8"));
                    } else {
                        bookmark = URLEncoder.encode(bookmark, "UTF-8");
                        link.append(ParameterAccessor.getQueryParameterString("__bookmark", bookmark));
                        if (!action.isBookmark()) {
                            link.append(ParameterAccessor.getQueryParameterString("__istoc", "true"));
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
        return link.toString();
    }

    private String getReportName(IReportContext context, IAction action) {
        ModuleHandle moduleHandle;
        URL url;
        assert (context != null);
        assert (action != null);
        String reportName = action.getReportName();
        IReportRunnable runnable = context.getReportRunnable();
        if (runnable != null && !ParameterAccessor.isWorkingFolderAccessOnly() && (url = (moduleHandle = runnable.getDesignHandle().getModuleHandle()).findResource(reportName, -1)) != null) {
            if ("file".equals(url.getProtocol())) {
                try {
                    File reportFile = new File(url.toURI());
                    reportName = reportFile.getPath();
                }
                catch (URISyntaxException e) {}
            } else {
                reportName = url.toExternalForm();
            }
        }
        return reportName;
    }

    public String getResourceFolder() {
        return this.resourceFolder;
    }

    public void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    private String createBaseURLWithExtractPattern(String baseURL) {
        String url = baseURL;
        while (url.endsWith("/")) {
            url = url.substring(0, url.length() - 2);
        }
        int index = url.lastIndexOf("/");
        if (index >= 0) {
            url = url.substring(0, index);
        }
        return url + "/extract";
    }

    private void createURLWithExtractInfo(IDataAction action, Map params) {
        assert (action != null);
        assert (params != null);
        if (action.getDataType() != null) {
            params.put("__extractformat", action.getDataType());
        }
        if (action.getInstanceID() != null) {
            params.put("__instanceid", action.getInstanceID().toUniqueString());
        }
        if (action.getBookmark() != null) {
            params.put("__bookmark", action.getBookmark());
        }
    }

    public String getPageOverflow() {
        return this.pageOverflow;
    }

    public void setPageOverflow(String pageOverflow) {
        this.pageOverflow = pageOverflow;
    }
}

