/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.ParameterDataTypeConverter;
import org.eclipse.birt.report.service.actionhandler.AbstractGetCascadeParameterActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.CascadeParameter;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.SelectItemChoice;
import org.eclipse.birt.report.soapengine.api.SelectionList;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateData;
import org.eclipse.birt.report.utility.DataUtil;

public class BirtGetCascadeParameterActionHandler
extends AbstractGetCascadeParameterActionHandler {
    public BirtGetCascadeParameterActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        super(context, operation, response);
    }

    protected void __execute() throws Exception {
        ViewerAttributeBean attrBean = (ViewerAttributeBean)this.context.getBean();
        assert (attrBean != null);
        Oprand[] params = this.operation.getOprand();
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
        InputOptions options = new InputOptions();
        options.setOption("request", this.context.getRequest());
        IViewerReportDesignHandle designHandle = attrBean.getReportDesignHandle(this.context.getRequest());
        Map cascParamMap = null;
        for (int i = 0; i < params.length; ++i) {
            ParameterDefinition parameter;
            Oprand param = params[i];
            String paramName = param.getName();
            boolean isLocale = false;
            if ("__isnull".equalsIgnoreCase(paramName)) {
                paramMap.put(param.getValue(), null);
                continue;
            }
            if (paramName.startsWith("__islocale__")) {
                paramName = paramName.replaceFirst("__islocale__", "");
                isLocale = true;
            }
            if ((parameter = attrBean.findParameterDefinition(paramName)) == null) continue;
            String format = parameter.getPattern();
            String dataType = ParameterDataTypeConverter.ConvertDataType(parameter.getDataType());
            Object paramValue = DataUtil.validate(paramName, dataType, format, param.getValue(), attrBean.getLocale(), attrBean.getTimeZone(), isLocale);
            paramMap.put(paramName, paramValue);
        }
        cascParamMap = this.getParameterSelectionLists(designHandle, paramMap, options, attrBean);
        CascadeParameter cascadeParameter = new CascadeParameter();
        if (cascParamMap != null && cascParamMap.size() > 0) {
            SelectionList[] selectionLists = new SelectionList[cascParamMap.size()];
            int i = 0;
            Iterator it = cascParamMap.keySet().iterator();
            while (it.hasNext()) {
                selectionLists[i] = new SelectionList();
                String name = (String)it.next();
                selectionLists[i].setName(name);
                List selections = (List)cascParamMap.get(name);
                SelectItemChoice[] SelectItemChoices = this.getVectorFromList(selections);
                selectionLists[i].setSelections(SelectItemChoices);
                ++i;
            }
            cascadeParameter.setSelectionList(selectionLists);
        }
        this.handleUpdate(cascadeParameter);
    }

    private SelectItemChoice[] getVectorFromList(List list) {
        SelectItemChoice[] selectionList = new SelectItemChoice[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SelectItemChoice item = (SelectItemChoice)list.get(i);
            selectionList[i] = new SelectItemChoice(item.getValue(), item.getLabel());
        }
        return selectionList;
    }

    private Map getParameterSelectionLists(IViewerReportDesignHandle design, Map params, InputOptions options, ViewerAttributeBean attrBean) throws ReportServiceException {
        if (params == null || params.size() == 0) {
            return new HashMap();
        }
        List paramList = null;
        HashMap ret = new HashMap();
        ArrayList<String> remainingParamNames = new ArrayList<String>();
        String firstName = (String)params.keySet().iterator().next();
        Collection paramDefs = attrBean.getParameterDefList();
        ParameterDefinition paramDef = null;
        for (ParameterDefinition temp : paramDefs) {
            if (!temp.getName().equals(firstName)) continue;
            paramDef = temp;
            break;
        }
        if (paramDef == null) {
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.reportServiceException.INVALID_PARAMETER", new String[]{firstName}));
        }
        ParameterGroupDefinition group = paramDef.getGroup();
        if (group != null && group.getParameterCount() > params.size()) {
            int remainingParams = group.getParameterCount() - params.size();
            for (int i = 0; i < remainingParams; ++i) {
                ParameterDefinition def = (ParameterDefinition)group.getParameters().get(params.size() + i);
                remainingParamNames.add(def.getName());
            }
        }
        try {
            if (remainingParamNames.size() > 0) {
                Object[] keyValue = new Object[params.size()];
                Set values = params.keySet();
                Object lastKey2 = null;
                int i = 0;
                for (Object lastKey2 : values) {
                    keyValue[i] = params.get(lastKey2);
                    ++i;
                }
                Object lastParamValue = params.get(lastKey2);
                Object lastParamDefValue = attrBean.getDefaultValues().get(lastKey2);
                boolean keepDefValue = false;
                if (lastParamDefValue != null && lastParamDefValue.equals(lastParamValue)) {
                    keepDefValue = true;
                }
                paramList = this.doQueryCascadeParameterSelectionList(remainingParamNames.get(0).toString(), design, group.getName(), keyValue, options, attrBean, keepDefValue);
                ret.put(remainingParamNames.get(0), paramList);
                for (int j = 1; j < remainingParamNames.size(); ++j) {
                    ret.put(remainingParamNames.get(j), new ArrayList());
                }
            }
        }
        catch (RemoteException e) {
            throw new ReportServiceException(e.getLocalizedMessage());
        }
        return ret;
    }

    private List preHandleCascadeParameterSelectionList(ParameterDefinition parameter, String defaultValue, String defaultLabel) throws RemoteException, ReportServiceException {
        int index = 0;
        ArrayList<SelectItemChoice> selectionList = new ArrayList<SelectItemChoice>();
        if (!parameter.isRequired()) {
            selectionList.add(index++, new SelectItemChoice("", "Null Value"));
            selectionList.add(index++, new SelectItemChoice("", ""));
        } else {
            selectionList.add(index++, new SelectItemChoice("", ""));
        }
        return selectionList;
    }

    private List doQueryCascadeParameterSelectionList(String paramName, IViewerReportDesignHandle design, String groupName, Object[] groupKeys, InputOptions options, ViewerAttributeBean attrBean, boolean keepDefValue) throws RemoteException, ReportServiceException {
        Object obj;
        ParameterDefinition parameter = attrBean.findParameterDefinition(paramName);
        String defaultValue = null;
        String defaultLabel = null;
        if (keepDefValue && (obj = attrBean.getDefaultValues().get(parameter.getName())) != null) {
            defaultValue = DataUtil.getDisplayValue(obj, attrBean.getTimeZone());
            defaultLabel = DataUtil.getDisplayValue(null, parameter.getPattern(), obj, attrBean.getLocale(), attrBean.getTimeZone());
        }
        List selectionList = this.preHandleCascadeParameterSelectionList(parameter, defaultValue, defaultLabel);
        int index = selectionList.size();
        Collection list = this.getReportService().getSelectionListForCascadingGroup(design, groupName, groupKeys, options);
        if (list != null && list.size() > 0) {
            Iterator iList = list.iterator();
            while (iList != null && iList.hasNext()) {
                String displayValue;
                ParameterSelectionChoice item = (ParameterSelectionChoice)iList.next();
                if (item == null) continue;
                Object value = item.getValue();
                try {
                    value = DataUtil.convert(value, parameter.getDataType());
                }
                catch (Exception e) {
                    value = null;
                }
                if ((displayValue = DataUtil.getDisplayValue(value, attrBean.getTimeZone())) == null) continue;
                String label = item.getLabel();
                if (label == null || label.length() <= 0) {
                    label = DataUtil.getDisplayValue(null, parameter.getPattern(), value, attrBean.getLocale(), attrBean.getTimeZone());
                }
                if (label == null) continue;
                SelectItemChoice selectItemChoice = new SelectItemChoice();
                selectItemChoice.setLabel(label);
                selectItemChoice.setValue(displayValue);
                selectionList.add(index++, selectItemChoice);
            }
        }
        return selectionList;
    }

    protected void handleUpdate(CascadeParameter cascadeParameter) {
        Data data = new Data();
        data.setCascadeParameter(cascadeParameter);
        UpdateData updateData = new UpdateData();
        updateData.setTarget("birtParameterDialog");
        updateData.setData(data);
        Update update = new Update();
        update.setUpdateData(updateData);
        this.response.setUpdate(new Update[]{update});
    }

    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }
}

