/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtGetReportletActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRenderImageActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Page;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateContent;
import org.eclipse.birt.report.soapengine.api.UpdateData;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class BirtGetPageAllActionHandler
extends AbstractBaseActionHandler {
    public BirtGetPageAllActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        super(context, operation, response);
    }

    public IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }

    protected void __execute() throws Exception {
        boolean isDocumentRtl = false;
        ViewerAttributeBean attrBean = (ViewerAttributeBean)this.context.getBean();
        assert (attrBean != null);
        boolean svgFlag = this.getSVGFlag(this.operation.getOprand());
        String docName = attrBean.getReportDocumentName();
        String bookmark = this.getBookmark(this.operation.getOprand(), this.context.getBean());
        InputOptions options = this.createInputOptions(attrBean, svgFlag);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (ParameterAccessor.isGetImageOperator(this.context.getRequest())) {
            BirtRenderImageActionHandler renderImageHandler = new BirtRenderImageActionHandler(this.context, this.operation, this.response);
            renderImageHandler.__execute();
        } else if (ParameterAccessor.isGetReportlet(this.context.getRequest())) {
            BirtGetReportletActionHandler getReportletHandler = new BirtGetReportletActionHandler(this.context, this.operation, this.response, out);
            getReportletHandler.execute();
        } else if (this.context.getBean().isDocumentInUrl()) {
            if (this.isToc(this.operation.getOprand(), attrBean)) {
                bookmark = this.getReportService().findTocByName(docName, bookmark, options);
            }
            this.getReportService().renderReport(docName, attrBean.getReportPage(), attrBean.getReportPageRange(), options, out);
            Boolean docPropertyRtl = (Boolean)options.getOption("docRtl");
            isDocumentRtl = docPropertyRtl != null ? docPropertyRtl : false;
        } else {
            HashMap displayTexts;
            IViewerReportDesignHandle reportDesignHandle = attrBean.getReportDesignHandle(this.context.getRequest());
            HashMap parameterMap = attrBean.getParameters();
            if (parameterMap == null) {
                parameterMap = new HashMap();
            }
            if ((displayTexts = attrBean.getDisplayTexts()) == null) {
                displayTexts = new HashMap();
            }
            BirtUtility.handleOperation(this.operation, attrBean, parameterMap, displayTexts);
            this.getReportService().runAndRenderReport(reportDesignHandle, docName, options, parameterMap, out, new ArrayList(), displayTexts);
            IReportRunnable r = (IReportRunnable)reportDesignHandle.getDesignObject();
            if (r.getDesignHandle() instanceof ReportDesignHandle) {
                ReportDesignHandle handle = (ReportDesignHandle)r.getDesignHandle();
                isDocumentRtl = "rtl".equalsIgnoreCase(handle.getBidiOrientation());
            }
        }
        Page pageObj = new Page();
        pageObj.setPageNumber("1");
        pageObj.setTotalPage("1");
        pageObj.setRtl(isDocumentRtl);
        Data pageData = new Data();
        pageData.setPage(pageObj);
        UpdateContent content = new UpdateContent();
        content.setContent(DataUtil.toUTF8(out.toByteArray()));
        content.setTarget("Document");
        if (bookmark != null) {
            content.setBookmark(bookmark);
        }
        UpdateData updateDocumentData = new UpdateData();
        updateDocumentData.setTarget("birtReportDocument");
        updateDocumentData.setData(pageData);
        Update updateDocument = new Update();
        updateDocument.setUpdateContent(content);
        updateDocument.setUpdateData(updateDocumentData);
        this.response.setUpdate(new Update[]{updateDocument});
    }
}

