/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.datafeed;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.datafeed.IDataPointEntry;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;

public final class DifferenceEntry
implements IDataPointEntry {
    private double dPosValue;
    private double dNegValue;

    public DifferenceEntry(double dPositiveValue, double dNegativeValue) {
        this.dPosValue = dPositiveValue;
        this.dNegValue = dNegativeValue;
    }

    public DifferenceEntry(Object[] oaTwoComponents) {
        assert (oaTwoComponents.length == 2);
        this.dPosValue = oaTwoComponents[0] instanceof Number ? ((Number)oaTwoComponents[0]).doubleValue() : Double.NaN;
        this.dNegValue = oaTwoComponents[1] instanceof Number ? ((Number)oaTwoComponents[1]).doubleValue() : Double.NaN;
    }

    public String toString() {
        return "P" + this.dPosValue + " N" + this.dNegValue;
    }

    public final double getPositiveValue() {
        return this.dPosValue;
    }

    public final void setPositiveValue(double value) {
        this.dPosValue = value;
    }

    public final double getNegativeValue() {
        return this.dNegValue;
    }

    public final void setNegativeValue(double value) {
        this.dNegValue = value;
    }

    public String getFormattedString(String type, FormatSpecifier formatter, ULocale locale) {
        String str = null;
        try {
            if ("difference_positive".equals(type)) {
                str = ValueFormatter.format((Object)new Double(this.dPosValue), (FormatSpecifier)formatter, (ULocale)locale, null);
            } else if ("difference_negative".equals(type)) {
                str = ValueFormatter.format((Object)new Double(this.dNegValue), (FormatSpecifier)formatter, (ULocale)locale, null);
            }
        }
        catch (ChartException e) {
            Logger.getLogger((String)"org.eclipse.birt.chart.engine/exception").log((Exception)((Object)e));
        }
        return str;
    }

    public String getFormattedString(Object formatter, ULocale locale) {
        return this.toString();
    }
}

