/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCProcedure;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCUserDefinedFunction;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaObjectFilterProvider;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EClass;

public class JDBCRoutineLoader
extends JDBCBaseLoader {
    public static final String COLUMN_PROCEDURE_NAME = "PROCEDURE_NAME";
    public static final String COLUMN_REMARKS = "REMARKS";
    public static final String COLUMN_PROCEDURE_TYPE = "PROCEDURE_TYPE";
    private IRoutineFactory mUserDefinedFunctionFactory;
    private IRoutineFactory mProcedureFactory;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.sqm.loader.JDBCRoutineLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public JDBCRoutineLoader(ICatalogObject catalogObject) {
        this(catalogObject, new SchemaObjectFilterProvider("DatatoolsSPFilterPredicate"));
    }

    public JDBCRoutineLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        this(catalogObject, connectionFilterProvider, new UserDefinedFunctionFactory(), new ProcedureFactory());
    }

    public JDBCRoutineLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider, IRoutineFactory udfFactory, IRoutineFactory spFactory) {
        super(catalogObject, connectionFilterProvider);
        if (!$assertionsDisabled && !(catalogObject instanceof Schema)) {
            throw new AssertionError();
        }
        this.mUserDefinedFunctionFactory = udfFactory;
        this.mProcedureFactory = spFactory;
    }

    public List loadRoutines() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadRoutines(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    /*
     * Exception decompiling
     */
    public void loadRoutines(List containmentList, Collection existingRoutines) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 177->181)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clearRoutines(List routines) {
        routines.clear();
    }

    public IRoutineFactory getProcedureFactory() {
        return this.mProcedureFactory;
    }

    public void setProcedureFactory(IRoutineFactory procedureFactory) {
        this.mProcedureFactory = procedureFactory;
    }

    public IRoutineFactory getUserDefinedFunctionFactory() {
        return this.mUserDefinedFunctionFactory;
    }

    public void setUserDefinedFunctionFactory(IRoutineFactory userDefinedFunctionFactory) {
        this.mUserDefinedFunctionFactory = userDefinedFunctionFactory;
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            Schema schema = this.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getProcedures(schema.getCatalog().getName(), schema.getName(), this.getJDBCFilterPattern());
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getProcedures()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected Routine processRow(ResultSet rs) throws SQLException {
        IRoutineFactory routineFactory = this.isProcedure(rs) ? this.mProcedureFactory : this.mUserDefinedFunctionFactory;
        return routineFactory.createRoutine(rs);
    }

    protected Schema getSchema() {
        return (Schema)this.getCatalogObject();
    }

    protected boolean isProcedure(ResultSet rs) throws SQLException {
        return rs.getShort(COLUMN_PROCEDURE_TYPE) == 1;
    }

    public static interface IRoutineFactory {
        public EClass getRoutineEClass();

        public Routine createRoutine(ResultSet var1) throws SQLException;

        public void initialize(Routine var1, ResultSet var2) throws SQLException;
    }

    public static class ProcedureFactory
    implements IRoutineFactory {
        public EClass getRoutineEClass() {
            return SQLRoutinesPackage.eINSTANCE.getProcedure();
        }

        public Routine createRoutine(ResultSet rs) throws SQLException {
            Routine retVal = this.newRoutine();
            this.initialize(retVal, rs);
            return retVal;
        }

        protected Routine newRoutine() {
            return new JDBCProcedure();
        }

        public void initialize(Routine routine, ResultSet rs) throws SQLException {
            routine.setName(rs.getString(JDBCRoutineLoader.COLUMN_PROCEDURE_NAME));
            routine.setDescription(rs.getString(JDBCRoutineLoader.COLUMN_REMARKS));
        }
    }

    public static class UserDefinedFunctionFactory
    extends ProcedureFactory {
        public EClass getRoutineEClass() {
            return SQLRoutinesPackage.eINSTANCE.getUserDefinedFunction();
        }

        protected Routine newRoutine() {
            return new JDBCUserDefinedFunction();
        }
    }
}

