/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCellExecutor;

public class CrosstabCornerHeaderRowExecutor
extends BaseCrosstabExecutor {
    private static Logger logger = Logger.getLogger(CrosstabCornerHeaderRowExecutor.class.getName());
    private int rowSpan;
    private int colSpan;
    private int currentChangeType;
    private int currentColIndex;
    private long currentEdgePosition;
    private boolean blankStarted;
    private boolean hasLast;

    public CrosstabCornerHeaderRowExecutor(BaseCrosstabExecutor parent) {
        super(parent);
    }

    public IContent execute() {
        IRowContent content = this.context.getReportContent().createRowContent();
        this.initializeContent((IContent)content, null);
        this.processRowHeight(this.crosstabItem.getHeader());
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        this.currentChangeType = -1;
        this.currentColIndex = -1;
        this.currentEdgePosition = -1L;
        this.blankStarted = false;
        this.rowSpan = 1;
        this.colSpan = 0;
        this.hasLast = false;
        this.walker.reload();
    }

    public IReportItemExecutor getNextChild() {
        CrosstabCellExecutor nextExecutor = null;
        try {
            while (this.walker.hasNext()) {
                ColumnEvent ev = this.walker.next();
                switch (this.currentChangeType) {
                    case 1: {
                        if (!this.blankStarted || ev.type == 1) break;
                        nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        nextExecutor.setPosition(this.currentEdgePosition);
                        this.blankStarted = false;
                        this.hasLast = false;
                    }
                }
                if (!this.blankStarted && ev.type == 1) {
                    this.blankStarted = true;
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                }
                this.currentEdgePosition = ev.dataPosition;
                this.currentChangeType = ev.type;
                ++this.colSpan;
                ++this.currentColIndex;
                if (nextExecutor == null) continue;
                return nextExecutor;
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabMeasureHeaderRowExecutor.error.generate.child.executor"), e);
        }
        if (this.hasLast) {
            this.hasLast = false;
            if (this.blankStarted) {
                nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                nextExecutor.setPosition(this.currentEdgePosition);
                this.blankStarted = false;
            }
        }
        return nextExecutor;
    }

    public boolean hasNextChild() {
        try {
            return this.walker.hasNext() || this.hasLast;
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabMeasureHeaderRowExecutor.error.check.child.executor"), e);
            return false;
        }
    }
}

