/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriverObject;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaParameterMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSet;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;

public class OdaQuery
extends OdaDriverObject
implements IQuery {
    private boolean m_isPreparedSuccessfully;
    private boolean m_isExecuted;
    private String m_dataSetType;
    private Object m_appContext;
    static /* synthetic */ Class class$0;

    protected OdaQuery(IQuery statement, OdaConnection connection, String dataSetType, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((Object)statement, connection, switchContextClassloader, driverClassLoader);
        String context = "OdaQuery.OdaQuery( " + statement + ", " + connection + ", " + dataSetType + " )\t";
        this.logMethodCalled(context);
        this.m_isPreparedSuccessfully = false;
        this.m_isExecuted = false;
        this.m_dataSetType = dataSetType;
        this.logMethodExitWithReturn(context, this);
    }

    protected IQuery getQuery() {
        return (IQuery)this.getObject();
    }

    protected OdaDataSetMetaData getDSMetaData() throws OdaException {
        return this.getOdaConnection().doGetMetaData(this.m_dataSetType);
    }

    protected boolean isPreparedSuccessfully() {
        return this.m_isPreparedSuccessfully;
    }

    protected boolean isExecuted() {
        return this.m_isExecuted;
    }

    protected void setIsExecuted(boolean flag) {
        this.m_isExecuted = flag;
    }

    private void resetStatementStates() {
        this.getOdaConnection().removeOpenStatement(this);
        this.m_isPreparedSuccessfully = false;
        this.resetExecuteStates();
    }

    protected void resetExecuteStates() {
        this.m_isExecuted = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAppContext(Object context) throws OdaException {
        String contextObjInfo = context == null ? "null" : context.toString();
        this.logMethodCalled("OdaQuery.setAppContext()\t");
        if (this.m_appContext == context) {
            this.log("OdaQuery.setAppContext()\t", "Same pass-thru application context object: " + contextObjInfo);
            this.logMethodExit("OdaQuery.setAppContext()\t");
            return;
        }
        try {
            try {
                this.setContextClassloader();
                this.log("OdaQuery.setAppContext()\t", "Passing thru application context to underlying ODA query: " + contextObjInfo);
                this.getQuery().setAppContext(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.logUnsupportedOp(uoException, "IQuery.setAppContext");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        this.resetContextClassloader();
        this.m_appContext = context;
        this.logMethodExit("OdaQuery.setAppContext()\t");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepare(String queryText) throws OdaException {
        String context = "OdaQuery.prepare( " + queryText + " )\t";
        this.logMethodCalled(context);
        this.setAppContext(this.getOdaConnection().getAppContext());
        try {
            try {
                this.setContextClassloader();
                this.doPrepare(queryText, context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.prepare( String queryText )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        this.resetContextClassloader();
        this.m_isPreparedSuccessfully = true;
        this.getOdaConnection().addOpenStatement(this);
        this.logMethodExit(context);
    }

    private void doPrepare(String queryText, String logContext) throws OdaException {
        this.resetStatementStates();
        if (queryText == null) {
            this.log(logContext, "Converted the null queryText argument to an empty String value to comply with the ODA interfaces specification.");
            queryText = "";
        }
        if (!this.getOdaConnection().canSupportMoreOpenedStatements()) {
            throw this.newOdaException(Messages.helper_maxConcurrentStatementsReached);
        }
        this.getQuery().prepare(queryText);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setProperty(String propertyName, String propertyValue) throws OdaException {
        String context = "OdaQuery.setProperty( " + propertyName + ", " + propertyValue + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.getQuery().setProperty(propertyName, propertyValue);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setProperty( String propertyName, String propertyValue )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws OdaException {
        this.logMethodCalled("OdaQuery.close()\t");
        try {
            try {
                this.setContextClassloader();
                this.getQuery().close();
                this.resetStatementStates();
                this.m_dataSetType = null;
                this.logMethodExit("OdaQuery.close()\t");
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.close()");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var2_6 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxRows(int max) throws OdaException {
        String context = "OdaQuery.setMaxRows( " + max + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.getQuery().setMaxRows(max);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setMaxRows()");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        this.resetContextClassloader();
        this.logMethodExit(context);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMaxRows() throws OdaException {
        this.logMethodCalled("OdaQuery.getMaxRows()\t");
        int ret = 0;
        try {
            try {
                this.setContextClassloader();
                ret = this.getQuery().getMaxRows();
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.getMaxRows()");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var3_7 = null;
        }
        this.resetContextClassloader();
        this.logMethodExitWithReturn("OdaQuery.getMaxRows()\t", ret);
        return ret;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResultSetMetaData getMetaData() throws OdaException {
        this.logMethodCalled("OdaQuery.getMetaData()\t");
        try {
            OdaResultSetMetaData odaResultSetMetaData;
            try {
                this.setContextClassloader();
                OdaResultSetMetaData ret = this.doGetMetaData();
                this.logMethodExitWithReturn("OdaQuery.getMetaData()\t", ret);
                odaResultSetMetaData = ret;
                Object var2_6 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IQuery.getMetaData()");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var2_7 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaResultSetMetaData;
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    private OdaResultSetMetaData doGetMetaData() throws OdaException {
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotGetResultSetMdBeforePrepare);
        }
        IResultSetMetaData resultSetMetaData = this.getQuery().getMetaData();
        OdaResultSetMetaData ret = resultSetMetaData == null ? null : new OdaResultSetMetaData(resultSetMetaData, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
        return ret;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResultSet executeQuery() throws OdaException {
        this.logMethodCalled("OdaQuery.executeQuery()\t");
        try {
            OdaResultSet odaResultSet;
            try {
                this.setContextClassloader();
                OdaResultSet ret = this.doExecuteQuery();
                this.logMethodExitWithReturn("OdaQuery.executeQuery()\t", ret);
                odaResultSet = ret;
                Object var2_6 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IQuery.executeQuery()");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var2_7 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaResultSet;
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    private OdaResultSet doExecuteQuery() throws OdaException {
        this.resetExecuteStates();
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotExecuteBeforePrepare);
        }
        IResultSet resultSet = this.getQuery().executeQuery();
        this.m_isExecuted = true;
        if (resultSet == null) {
            return null;
        }
        OdaResultSet ret = this.newResultSetHelper(resultSet);
        return ret;
    }

    protected OdaResultSet newResultSetHelper(IResultSet resultSet) {
        return new OdaResultSet(resultSet, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setInt(String parameterName, int value) throws OdaException {
        String context = "OdaQuery.setInt( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setInt(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setInt( String parameterName, int value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setInt(int parameterId, int value) throws OdaException {
        String context = "OdaQuery.setInt( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setInt(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setInt( int parameterId, int value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDouble(String parameterName, double value) throws OdaException {
        String context = "OdaQuery.setDouble( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setDouble(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setDouble( String parameterName, double value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDouble(int parameterId, double value) throws OdaException {
        String context = "OdaQuery.setDouble( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setDouble(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setDouble( int parameterId, double value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        String context = "OdaQuery.setBigDecimal( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setBigDecimal(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setBigDecimal( String parameterName, BigDecimal value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        String context = "OdaQuery.setBigDecimal( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setBigDecimal(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setBigDecimal( int parameterId, BigDecimal value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setString(String parameterName, String value) throws OdaException {
        String context = "OdaQuery.setString( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setString(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setString( String parameterName, String value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setString(int parameterId, String value) throws OdaException {
        String context = "OdaQuery.setString( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setString(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setString( int parameterId, String value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDate(String parameterName, Date value) throws OdaException {
        String context = "OdaQuery.setDate( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setDate(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setDate( String parameterName, Date value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDate(int parameterId, Date value) throws OdaException {
        String context = "OdaQuery.setDate( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setDate(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setDate( int parameterId, Date value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTime(String parameterName, Time value) throws OdaException {
        String context = "OdaQuery.setTime( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setTime(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setTime( String parameterName, Time value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTime(int parameterId, Time value) throws OdaException {
        String context = "OdaQuery.setTime( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setTime(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setTime( int parameterId, Time value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        String context = "OdaQuery.setTimestamp( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setTimestamp(parameterName, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setTimestamp( String parameterName, Timestamp value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        String context = "OdaQuery.setTimestamp( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setTimestamp(parameterId, value);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setTimestamp( int parameterId, Timestamp value )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBoolean(String parameterName, boolean value) throws OdaException {
        String context = "OdaQuery.setBoolean( " + parameterName + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setBoolean(parameterName, value);
                this.logMethodExit(context);
            }
            catch (AbstractMethodError abstractMethodError) {
                String msg = this.formatMethodNotImplementedMsg("IQuery.setBoolean( String, boolean )");
                this.log(context, msg);
                this.handleUnsupportedOp(new UnsupportedOperationException(msg), msg);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setBoolean( String, boolean )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_10 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBoolean(int parameterId, boolean value) throws OdaException {
        String context = "OdaQuery.setBoolean( " + parameterId + ", " + value + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setBoolean(parameterId, value);
                this.logMethodExit(context);
            }
            catch (AbstractMethodError abstractMethodError) {
                String msg = this.formatMethodNotImplementedMsg("IQuery.setBoolean( int, boolean )");
                this.log(context, msg);
                this.handleUnsupportedOp(new UnsupportedOperationException(msg), msg);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setBoolean( int, boolean )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_10 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNull(String parameterName) throws OdaException {
        String context = "OdaQuery.setNull( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setNull(parameterName);
                this.logMethodExit(context);
            }
            catch (AbstractMethodError abstractMethodError) {
                String msg = this.formatMethodNotImplementedMsg("IQuery.setNull( String )");
                this.log(context, msg);
                this.handleUnsupportedOp(new UnsupportedOperationException(msg), msg);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setNull( String )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var4_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNull(int parameterId) throws OdaException {
        String context = "OdaQuery.setNull( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                this.getQuery().setNull(parameterId);
                this.logMethodExit(context);
            }
            catch (AbstractMethodError abstractMethodError) {
                String msg = this.formatMethodNotImplementedMsg("IQuery.setNull( int )");
                this.log(context, msg);
                this.handleUnsupportedOp(new UnsupportedOperationException(msg), msg);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setNull( int )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var4_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearInParameters() throws OdaException {
        this.logMethodCalled("OdaQuery.clearInParameters()\t");
        try {
            try {
                this.setContextClassloader();
                this.getQuery().clearInParameters();
                this.logMethodExit("OdaQuery.clearInParameters()\t");
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.clearInParameters()");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var2_6 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findInParameter(String parameterName) throws OdaException {
        int n;
        String context = "OdaQuery.findInParameter( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                if (!this.isPreparedSuccessfully()) {
                    throw this.newOdaException(Messages.helper_cannotGetParamMdBeforePrepare);
                }
                int ret = this.getQuery().findInParameter(parameterName);
                this.logMethodExitWithReturn(context, ret);
                n = ret;
                Object var4_11 = null;
            }
            catch (UnsupportedOperationException uoException) {
                int n2 = this.handleUnsupportedOpAndRetZero(uoException, "IQuery.findInParameter( String parameterName )");
                Object var4_12 = null;
                this.resetContextClassloader();
                return n2;
            }
            catch (RuntimeException rtException) {
                int n3 = this.handleErrorAndReturnZero(rtException);
                Object var4_13 = null;
                this.resetContextClassloader();
                return n3;
            }
            catch (OdaException odaException) {
                int n4 = this.handleErrorAndReturnZero(odaException);
                Object var4_14 = null;
                this.resetContextClassloader();
                return n4;
            }
        }
        catch (Throwable throwable) {
            Object var4_15 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IParameterMetaData getParameterMetaData() throws OdaException {
        this.logMethodCalled("OdaQuery.getParameterMetaData()\t");
        try {
            OdaParameterMetaData odaParameterMetaData;
            try {
                this.setContextClassloader();
                if (!this.isPreparedSuccessfully()) {
                    throw this.newOdaException(Messages.helper_cannotGetParamMdBeforePrepare);
                }
                IParameterMetaData parameterMetaData = this.getQuery().getParameterMetaData();
                OdaParameterMetaData ret = parameterMetaData == null ? null : new OdaParameterMetaData(parameterMetaData, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
                this.logMethodExitWithReturn("OdaQuery.getParameterMetaData()\t", ret);
                odaParameterMetaData = ret;
                Object var3_7 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block7: {
                    this.handleUnsupportedOp(uoException, "IQuery.getParameterMetaData()");
                    break block7;
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                        break block7;
                    }
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                    }
                }
                Object var3_8 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaParameterMetaData;
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSortSpec(SortSpec sortBy) throws OdaException {
        String context = "OdaQuery.setSortSpec( " + sortBy + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                if (!this.isPreparedSuccessfully()) {
                    throw this.newOdaException(Messages.helper_cannotSetSortSpecBeforePrepare);
                }
                this.getQuery().setSortSpec(sortBy);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IQuery.setSortSpec( SortSpec sortBy )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SortSpec getSortSpec() throws OdaException {
        this.logMethodCalled("OdaQuery.getSortSpec()\t");
        try {
            block7: {
                SortSpec sortSpec;
                try {
                    this.setContextClassloader();
                    SortSpec sortSpec2 = this.getQuery().getSortSpec();
                    this.logMethodExitWithReturn("OdaQuery.getSortSpec()\t", sortSpec2);
                    sortSpec = sortSpec2;
                    Object var2_6 = null;
                }
                catch (UnsupportedOperationException uoException) {
                    this.handleUnsupportedOp(uoException, "IQuery.getSortSpec()");
                    break block7;
                }
                catch (RuntimeException rtException) {
                    this.handleError(rtException);
                    break block7;
                }
                catch (OdaException odaException) {
                    this.handleError(odaException);
                }
                this.resetContextClassloader();
                return sortSpec;
            }
            Object var2_8 = null;
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return null;
    }

    public String getInterfaceName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.IQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    private void throwIfSetParamBeforePrepare() throws OdaException {
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotSetParamBeforePrepare);
        }
    }
}

