/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ppt.device;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.report.engine.emitter.ppt.PPTWriter;
import org.eclipse.birt.report.engine.layout.TextStyle;
import org.eclipse.birt.report.engine.layout.emitter.AbstractPage;

public class PPTPage
extends AbstractPage {
    private PPTWriter writer;
    private boolean isDisposed;
    private String link;

    public PPTPage(int pageWidth, int pageHeight, Color backgroundColor, PPTWriter writer) {
        super(pageWidth, pageHeight);
        writer.newPage(this.pageWidth, this.pageHeight, backgroundColor);
        this.writer = writer;
        this.isDisposed = false;
    }

    public void restoreState() {
    }

    public void saveState() {
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.writer.endPage();
            this.isDisposed = true;
        }
    }

    protected void clip(float startX, float startY, float width, float height) {
    }

    protected void drawBackgroundColor(Color color, float x, float y, float width, float height) {
        this.writer.drawBackgroundColor(color, x, y, width, height);
    }

    protected void drawBackgroundImage(float x, float y, float width, float height, String repeat, String imageUrl, float absPosX, float absPosY) throws IOException {
        this.writer.drawBackgroundImage(imageUrl, x, y, width, height, absPosX, absPosY, repeat);
    }

    protected void drawImage(String imageId, byte[] imageData, String extension, float imageX, float imageY, float height, float width, String helpText) throws Exception {
        this.writer.drawImage(imageId, imageData, extension, imageX, imageY, height, width, helpText, this.link);
    }

    protected void drawImage(String uri, String extension, float imageX, float imageY, float height, float width, String helpText) throws Exception {
        int data;
        if (uri == null) {
            return;
        }
        InputStream imageStream = new URL(uri).openStream();
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        while ((data = imageStream.read()) != -1) {
            byteArrayOut.write(data);
        }
        this.drawImage(uri, byteArrayOut.toByteArray(), extension, imageX, imageY, height, width, helpText);
    }

    protected void drawLine(float startX, float startY, float endX, float endY, float width, Color color, String lineStyle) {
        this.writer.drawLine(startX, startY, endX, endY, width, color, lineStyle);
    }

    protected void drawText(String text, float textX, float textY, float baseline, float width, float height, TextStyle textStyle) {
        this.writer.drawText(text, textX, textY, width + 1.0f, height, textStyle.getFontInfo(), textStyle.getColor(), textStyle.isRtl(), this.link);
    }

    public void setLink(String link) {
        this.link = link;
    }
}

