/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignPackage;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DocumentRoot;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.datatools.connectivity.oda.design.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.util.DesignValidator;
import org.eclipse.datatools.connectivity.oda.design.util.DesignXMLProcessor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;

public class DesignUtil {
    private static Diagnostician sm_diagnostician;
    private static final String sm_loggerName = "org.eclipse.datatools.connectivity.oda.design.util";
    private static String sm_className;
    private static Logger sm_logger;
    static /* synthetic */ Class class$0;

    private DesignUtil() {
    }

    public static void validateObject(EObject eObject) throws IllegalStateException {
        Diagnostic diagnostic = DesignUtil.diagnoseObject(eObject);
        if (diagnostic == null || diagnostic.getSeverity() == 0) {
            return;
        }
        if (diagnostic.getSeverity() == 4) {
            String errWarnMsg = DesignUtil.getDiagnosticMessages(diagnostic, 4, 2);
            throw new IllegalStateException(errWarnMsg);
        }
        String diagnosticMsg = DesignUtil.getDiagnosticMessages(diagnostic, 2, 1);
        if (diagnostic.getSeverity() == 2) {
            DiagnosticException ex = new DiagnosticException(diagnostic);
            DesignUtil.getLogger().logp(Level.WARNING, sm_className, "validateObject", diagnosticMsg, (Throwable)ex);
        } else {
            DesignUtil.getLogger().logp(Level.INFO, sm_className, "validateObject", diagnosticMsg);
        }
    }

    public static Diagnostic diagnoseObject(EObject eObject) {
        if (!DesignUtil.canDiagnose()) {
            return null;
        }
        Diagnostician designDiagnostician = DesignUtil.getDiagnostician();
        return designDiagnostician.validate(eObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Diagnostician getDiagnostician() {
        if (sm_diagnostician != null) return sm_diagnostician;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.design.util.DesignUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (sm_diagnostician != null) return sm_diagnostician;
            EValidator.Registry eValidatorRegistry = EValidator.Registry.INSTANCE;
            eValidatorRegistry.put((Object)DesignPackage.Literals.DATA_SET_QUERY.eContainer(), (Object)new DesignValidator());
            sm_diagnostician = new Diagnostician(eValidatorRegistry);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_diagnostician;
        }
    }

    private static String getDiagnosticMessages(Diagnostic diagnostic, int messageType1, int messageType2) {
        if (diagnostic == null) {
            return null;
        }
        String errMsg = diagnostic.getMessage();
        Iterator i = diagnostic.getChildren().iterator();
        while (i.hasNext()) {
            Diagnostic childDiagnostic = (Diagnostic)i.next();
            if (childDiagnostic.getSeverity() != messageType1 && childDiagnostic.getSeverity() != messageType2) continue;
            errMsg = String.valueOf(errMsg) + "\n" + childDiagnostic.getMessage();
        }
        return errMsg;
    }

    private static boolean canDiagnose() {
        return true;
    }

    public static java.util.Properties convertDataSourceProperties(DataSourceDesign dataSourceDesign) {
        java.util.Properties publicProps = DesignUtil.convertDesignProperties(dataSourceDesign.getPublicProperties());
        java.util.Properties propCollection = DesignUtil.convertDesignProperties(dataSourceDesign.getPrivateProperties());
        propCollection.putAll((Map<?, ?>)publicProps);
        return propCollection;
    }

    public static java.util.Properties convertDesignProperties(Properties designProps) {
        java.util.Properties utilProps = new java.util.Properties();
        if (designProps == null || designProps.isEmpty()) {
            return utilProps;
        }
        Iterator itr = designProps.getProperties().iterator();
        while (itr.hasNext()) {
            Property designProp = (Property)itr.next();
            if (designProp.getNameValue() == null || designProp.getNameValue().getName() == null || designProp.getNameValue().getValue() == null) continue;
            utilProps.setProperty(designProp.getNameValue().getName(), designProp.getNameValue().getValue());
        }
        return utilProps;
    }

    public static Properties convertToDesignProperties(java.util.Properties utilProps) {
        Properties designProps = DesignFactory.eINSTANCE.createProperties();
        if (utilProps == null || utilProps.size() == 0) {
            return designProps;
        }
        Iterator<Map.Entry<Object, Object>> iter = utilProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> utilProp = iter.next();
            designProps.setProperty((String)utilProp.getKey(), (String)utilProp.getValue());
        }
        return designProps;
    }

    public static String validateRequestSession(DesignSessionRequest requestSession) throws IllegalStateException {
        if (requestSession == null) {
            throw new IllegalStateException(Messages.design_nullArgument);
        }
        DesignUtil.validateObject(requestSession);
        DataSourceDesign dataSourceDesign = requestSession.getDataSourceDesign();
        if (dataSourceDesign == null) {
            throw new IllegalStateException(Messages.design_missingDataSourceDesign);
        }
        String odaDataSourceId = dataSourceDesign.getOdaExtensionDataSourceId();
        if (odaDataSourceId == null || odaDataSourceId.length() == 0) {
            throw new IllegalStateException(Messages.design_missingId);
        }
        return odaDataSourceId;
    }

    public static void validateDataSourceDesign(DataSourceDesign dataSourceDesign) throws IllegalStateException {
        if (dataSourceDesign == null) {
            throw new IllegalStateException(Messages.design_nullArgument);
        }
        DesignUtil.validateObject(dataSourceDesign);
    }

    public static File convertPathToFile(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        try {
            URL url = new URL(filePath);
            return new File(FileLocator.toFileURL((URL)url).getPath());
        }
        catch (MalformedURLException e) {
            DesignUtil.getLogger().warning(e.toString());
        }
        catch (IOException e) {
            DesignUtil.getLogger().warning(e.toString());
        }
        return null;
    }

    public static String convertFileToPath(File aFile) {
        if (aFile == null) {
            return null;
        }
        return aFile.getPath();
    }

    public static void saveOdaDesignSession(OdaDesignSession odaDesignSession, File outputFile) throws IOException, IllegalArgumentException {
        if (outputFile == null) {
            throw new IllegalArgumentException();
        }
        URI fileURI = URI.createFileURI((String)outputFile.getAbsolutePath());
        DesignUtil.saveOdaDesignSession(odaDesignSession, fileURI);
    }

    public static void saveOdaDesignSession(OdaDesignSession odaDesignSession, URI uri) throws IOException {
        DocumentRoot documentRoot = DesignFactory.eINSTANCE.createDocumentRoot();
        documentRoot.setOdaDesignSession(odaDesignSession);
        DesignXMLProcessor xmlProcessor = new DesignXMLProcessor();
        Resource resource = xmlProcessor.createResource(uri);
        resource.getContents().add((Object)documentRoot);
        try {
            resource.save(null);
        }
        catch (IOException ex) {
            DesignUtil.getLogger().logp(Level.INFO, sm_className, "saveOdaDesignSession( OdaDesignSession, URI )", "Not able to serialize the ODA design session to specified URI.", ex);
            throw ex;
        }
    }

    public static OdaDesignSession loadOdaDesignSession(File resourceFile) throws IOException, IllegalArgumentException {
        if (resourceFile == null) {
            throw new IllegalArgumentException();
        }
        URI fileURI = URI.createFileURI((String)resourceFile.getAbsolutePath());
        return DesignUtil.loadOdaDesignSession(fileURI);
    }

    public static OdaDesignSession loadOdaDesignSession(URI uri) throws IOException {
        DocumentRoot documentRoot;
        OdaDesignSession odaDesignSession;
        DesignXMLProcessor xmlProcessor = new DesignXMLProcessor();
        Resource resource = xmlProcessor.createResource(uri);
        try {
            resource.load(null);
        }
        catch (IOException ex) {
            DesignUtil.getLogger().logp(Level.INFO, sm_className, "loadOdaDesignSession( URI )", "Not able to load the specified URI.", ex);
            throw ex;
        }
        if (resource.getContents().isEmpty()) {
            DesignUtil.getLogger().logp(Level.WARNING, sm_className, "loadOdaDesignSession( URI )", "The specified resource URI (" + uri.toString() + ") is empty.");
            return null;
        }
        Object content = resource.getContents().get(0);
        if (content instanceof DocumentRoot && (odaDesignSession = (documentRoot = (DocumentRoot)content).getOdaDesignSession()) != null) {
            return odaDesignSession;
        }
        DesignUtil.getLogger().logp(Level.WARNING, sm_className, "loadOdaDesignSession( URI )", "The resource URI (" + uri.toString() + ") does not contain an ODA Design Session.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.design.util.DesignUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (sm_logger != null) return sm_logger;
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.design.util.DesignUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            sm_className = clazz3.getName();
            sm_logger = Logger.getLogger(sm_loggerName);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }
}

