/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.ExcelEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCache {
    private List<ArrayList<Data>> columns = new ArrayList<ArrayList<Data>>();
    private Map<Integer, Integer> columnId2StartRowId = new HashMap<Integer, Integer>();
    private int width;
    private int height;
    protected static Logger logger = Logger.getLogger(EmitterUtil.class.getName());
    private ExcelEmitter emitter;
    private List<BookmarkDef> bookmarks = new ArrayList<BookmarkDef>();

    public DataCache(int width, int height, ExcelEmitter emitter) {
        this.columns.add(new ArrayList());
        this.columnId2StartRowId.put(0, 0);
        this.width = width;
        this.height = height;
        this.emitter = emitter;
    }

    public void insertColumns(int col, int size) {
        if (size == 0) {
            return;
        }
        int columnCount = this.getColumnCount();
        int m_start = col + 1;
        int m_size = columnCount - m_start;
        m_size = Math.max(0, m_size);
        ArrayList[] mcol = new ArrayList[m_size];
        HashMap<Integer, Integer> temp = new HashMap<Integer, Integer>();
        int i = m_start;
        int j = 0;
        while (j < m_size) {
            Integer column = new Integer(i);
            Integer row = this.columnId2StartRowId.get(column);
            int npos = i + size;
            if (npos < this.width) {
                temp.put(new Integer(npos), row);
                mcol[j] = this.columns.get(m_start);
            }
            this.columns.remove(m_start);
            ++i;
            ++j;
        }
        this.columnId2StartRowId.putAll(temp);
        int rowCount = this.getStartRowId(col);
        int i2 = m_start;
        while (i2 <= col + size) {
            if (i2 < this.width) {
                if (i2 > this.columns.size()) {
                    this.columns.add(new ArrayList());
                    this.columnId2StartRowId.put(this.columns.size() - 1, rowCount);
                } else {
                    this.columns.add(i2, new ArrayList());
                    this.columnId2StartRowId.put(i2, rowCount);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < mcol.length) {
            if (mcol[i2] != null) {
                this.columns.add(mcol[i2]);
            }
            ++i2;
        }
    }

    public void addData(int col, Data data) {
        List column;
        int size;
        if (this.getStartRowId(col) > this.height || col >= this.getColumnCount()) {
            this.emitter.outputSheet();
            this.clearCachedSheetData();
        }
        if ((size = (column = (List)this.columns.get(col)).size()) > 0) {
            ((Data)column.get(size - 1)).clearContainer();
        }
        column.add(data);
        if (data instanceof Data) {
            BookmarkDef bookmark = data.getBookmark();
            if (bookmark == null) {
                return;
            }
            int rowNo = this.columnId2StartRowId.get(new Integer(col)) + this.getStartRowId(col);
            bookmark.setColumnNo(col + 1);
            bookmark.setRowNo(rowNo);
            this.bookmarks.add(bookmark);
        }
    }

    private void clearCachedSheetData() {
        int i = 0;
        while (i < this.getColumnCount()) {
            this.columns.set(i, new ArrayList());
            ++i;
        }
        Set<Map.Entry<Integer, Integer>> entrySets = this.columnId2StartRowId.entrySet();
        for (Map.Entry<Integer, Integer> entry : entrySets) {
            entry.setValue(0);
        }
    }

    public int getStartRowId(int column) {
        if (column < this.getColumnCount()) {
            return this.columnId2StartRowId.get(column) + this.columns.get(column).size();
        }
        return -1;
    }

    public int getMaxRow() {
        int max = 0;
        int i = 0;
        while (i < this.columns.size()) {
            int size = this.getStartRowId(i);
            max = max >= size ? max : size;
            ++i;
        }
        return max;
    }

    public Data[] getRowData(int rownum) {
        ArrayList<Data> data = new ArrayList<Data>();
        int i = 0;
        while (i < this.columns.size()) {
            Data value = this.getData(i, rownum);
            if (value != null) {
                data.add(value);
            }
            ++i;
        }
        Data[] row = new Data[data.size()];
        data.toArray(row);
        return row;
    }

    public Data getData(int col, int row) {
        if (!this.valid(row, col)) {
            return null;
        }
        int start = this.columnId2StartRowId.get(new Integer(col));
        List data = this.columns.get(col);
        if (data.size() > row - start) {
            return (Data)data.get(row - start);
        }
        return null;
    }

    protected boolean valid(int row, int col) {
        if (col >= this.getColumnCount() || row > this.getStartRowId(col)) {
            return false;
        }
        int start = this.columnId2StartRowId.get(new Integer(col));
        return row >= start && row < this.getStartRowId(col) && col < this.getColumnCount();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public List<BookmarkDef> getBookmarks() {
        return this.bookmarks;
    }
}

