/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetUtil {
    public static int writeResultObject(DataOutputStream dos, IResultObject resultObject, int count, Set nameSet) throws DataException, IOException {
        if (resultObject.getResultClass() == null) {
            return 0;
        }
        ByteArrayOutputStream tempBaos = new ByteArrayOutputStream();
        BufferedOutputStream tempBos = new BufferedOutputStream(tempBaos);
        DataOutputStream tempDos = new DataOutputStream(tempBos);
        int i = 1;
        while (i <= count) {
            if (nameSet != null && (nameSet.contains(resultObject.getResultClass().getFieldName(i)) || nameSet.contains(resultObject.getResultClass().getFieldAlias(i)))) {
                IOUtil.writeObject((DataOutputStream)tempDos, (Object)resultObject.getFieldValue(i));
            }
            ++i;
        }
        tempDos.flush();
        tempBos.flush();
        tempBaos.flush();
        byte[] bytes = tempBaos.toByteArray();
        int rowBytes = bytes.length;
        IOUtil.writeRawBytes((DataOutputStream)dos, (byte[])bytes);
        tempBaos = null;
        tempBos = null;
        tempDos = null;
        return rowBytes;
    }

    public static IResultObject readResultObject(DataInputStream dis, IResultClass rsMeta, int count) throws IOException {
        Object[] obs = new Object[count];
        int i = 0;
        while (i < count) {
            obs[i] = IOUtil.readObject((DataInputStream)dis, (ClassLoader)DataEngineSession.getCurrentClassLoader());
            ++i;
        }
        return new ResultObject(rsMeta, obs);
    }

    public static Set getRsColumnRequestMap(List<IBinding> cacheRequestMap) throws DataException {
        HashSet resultSetNameSet = new HashSet();
        if (cacheRequestMap != null) {
            Iterator<IBinding> iter = cacheRequestMap.iterator();
            List dataSetColumnList = null;
            while (iter.hasNext()) {
                IBinding binding = iter.next();
                List list = dataSetColumnList = binding == null ? null : ExpressionCompilerUtil.extractDataSetColumnExpression(binding.getExpression());
                if (dataSetColumnList == null) continue;
                resultSetNameSet.addAll(dataSetColumnList);
            }
        }
        return resultSetNameSet;
    }
}

