/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.aggregation.AggrDefnManager;
import org.eclipse.birt.data.engine.executor.aggregation.AggrInfo;
import org.eclipse.birt.data.engine.executor.aggregation.AggregationHelper;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.AggrComputedColumnHelper;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnCalculator;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.pass.PassStatusController;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.executor.transform.pass.RowProcessUtil;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.impl.StopSign;

class DataSetProcessUtil
extends RowProcessUtil {
    private DataSetProcessUtil(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController) {
        super(populator, iccState, computedColumnHelper, filterByRow, psController);
    }

    public static void doPopulate(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, FilterByRow filterByRow, PassStatusController psController, StopSign stopSign) throws DataException {
        DataSetProcessUtil instance = new DataSetProcessUtil(populator, iccState, computedColumnHelper, filterByRow, psController);
        instance.populateDataSet(stopSign);
    }

    private void populateDataSet(StopSign stopSign) throws DataException {
        boolean changeMaxRows;
        int originalMaxRows = this.populator.getQuery().getMaxRows();
        boolean bl = this.filterByRow == null ? false : (changeMaxRows = this.filterByRow.getFilterList(2).size() + this.filterByRow.getFilterList(5).size() > 0);
        if (changeMaxRows) {
            this.populator.getQuery().setMaxRows(0);
        }
        if (this.computedColumnHelper != null) {
            this.computedColumnHelper.setModel(4);
        }
        this.doDataSetFilter(changeMaxRows, stopSign);
        List aggCCList = this.prepareComputedColumns(0);
        this.populateAggrCCs(this.getAggrComputedColumns(aggCCList, true), stopSign);
        this.removeAvailableComputedColumns();
        this.populateComputedColumns(this.getAggrComputedColumns(aggCCList, false), stopSign);
        this.populator.getQuery().setMaxRows(originalMaxRows);
    }

    private void populateAggrCCs(List aggrComputedColumns, StopSign stopSign) throws DataException {
        if (aggrComputedColumns.size() == 0) {
            return;
        }
        ExpressionCompiler compiler = new ExpressionCompiler();
        compiler.setDataSetMode(true);
        ArrayList<AggrInfo> aggrInfos = new ArrayList<AggrInfo>();
        ArrayList<String> aggrNames = new ArrayList<String>();
        int i = 0;
        while (i < aggrComputedColumns.size()) {
            ComputedColumn cc = (ComputedColumn)aggrComputedColumns.get(i);
            List args = cc.getAggregateArgument();
            IBaseExpression[] exprs = null;
            int offset = 0;
            if (cc.getExpression() != null) {
                exprs = new IBaseExpression[args.size() + 1];
                offset = 1;
                exprs[0] = cc.getExpression();
            } else {
                exprs = new IBaseExpression[args.size()];
            }
            int j = offset;
            while (j < args.size() + offset) {
                exprs[j] = (IBaseExpression)args.get(j - offset);
                ++j;
            }
            j = 0;
            while (j < exprs.length) {
                IScriptExpression scriptExpr;
                if (!(exprs[j] instanceof IScriptExpression) || (scriptExpr = (IScriptExpression)exprs[j]).getText() != null) {
                    compiler.compile(exprs[j], this.populator.getSession().getEngineContext().getScriptContext().getContext());
                }
                ++j;
            }
            if (cc.getAggregateFilter() != null) {
                compiler.compile(cc.getAggregateFilter(), this.populator.getSession().getEngineContext().getScriptContext().getContext());
            }
            IAggrFunction aggrFunction = AggregationManager.getInstance().getAggregation(cc.getAggregateFunction());
            AggrInfo aggrInfo = new AggrInfo(cc.getName(), 0, aggrFunction, exprs, cc.getAggregateFilter());
            aggrInfos.add(aggrInfo);
            aggrNames.add(cc.getName());
            ++i;
        }
        if (!this.psController.needDoOperation(1)) {
            PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false, stopSign);
        }
        AggregationHelper helper = new AggregationHelper(new AggrDefnManager(aggrInfos), this.populator);
        AggrComputedColumnHelper ccHelper = new AggrComputedColumnHelper(helper, aggrNames);
        this.populator.getQuery().getFetchEvents().add(0, ccHelper);
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false, stopSign);
        this.populator.getQuery().getFetchEvents().remove(0);
    }

    private void doDataSetFilter(boolean changeMaxRows, StopSign stopSign) throws DataException {
        if (!this.psController.needDoOperation(1)) {
            return;
        }
        this.applyFilters(1, changeMaxRows, stopSign);
    }

    private void populateComputedColumns(List aggCCList, StopSign stopSign) throws DataException {
        if (!this.psController.needDoOperation(2)) {
            return;
        }
        if (!this.psController.needDoOperation(1)) {
            PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false, stopSign);
        }
        this.computedColumnHelper.getComputedColumnList().clear();
        this.computedColumnHelper.getComputedColumnList().addAll(aggCCList);
        this.computedColumnHelper.setModel(0);
        this.iccState.setModel(0);
        if (this.iccState.getCount() > 0) {
            ComputedColumnCalculator.populateComputedColumns(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), this.iccState, this.computedColumnHelper, stopSign);
        }
        this.computedColumnHelper.setModel(4);
    }

    private void removeAvailableComputedColumns() {
        if (this.iccState != null) {
            int i = 0;
            while (i < this.iccState.getCount()) {
                if (this.iccState.isValueAvailable(i)) {
                    int k = 0;
                    while (k < this.populator.getQuery().getFetchEvents().size()) {
                        if (this.populator.getQuery().getFetchEvents().get(k) instanceof ComputedColumnHelper) {
                            ComputedColumnHelper helper = (ComputedColumnHelper)this.populator.getQuery().getFetchEvents().get(k);
                            helper.getComputedColumnList().remove(this.iccState.getComputedColumn(i));
                            break;
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
    }
}

