/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.File;
import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheConfig;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IEngineExecutionHints;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;

public class DataSetCacheUtil {
    public static DataSetCacheConfig getJVMDataSetCacheConfig(Map appContext, DataEngineContext context, IBaseDataSetDesign dataSetDesign) throws DataException {
        Object option;
        int cacheOption;
        String tempDir = context.getTmpdir();
        if (dataSetDesign != null && dataSetDesign instanceof IIncreCacheDataSetDesign) {
            return DataSetCacheConfig.getInstance(DataSetCacheConfig.DataSetCacheMode.IN_DISK, -1, true, tempDir);
        }
        if (appContext != null) {
            Object option2 = appContext.get(DataEngine.MEMORY_DATA_SET_CACHE);
            if (option2 != null) {
                int rowLimit = DataSetCacheUtil.getIntValueFromString(option2);
                return DataSetCacheConfig.getInstacne(DataSetCacheConfig.DataSetCacheMode.IN_MEMORY, rowLimit, null);
            }
            option2 = appContext.get(DataEngine.DATA_SET_CACHE_ROW_LIMIT);
            if (option2 != null) {
                int rowLimit = DataSetCacheUtil.getIntValueFromString(option2);
                return DataSetCacheConfig.getInstacne(DataSetCacheConfig.DataSetCacheMode.IN_DISK, rowLimit, tempDir);
            }
        }
        if ((cacheOption = context.getCacheOption()) == 3) {
            return DataSetCacheConfig.getInstacne(DataSetCacheConfig.DataSetCacheMode.IN_DISK, context.getCacheCount(), tempDir);
        }
        if (cacheOption == 2) {
            return null;
        }
        if (appContext != null && (option = appContext.get(DataEngine.DATASET_CACHE_OPTION)) != null && option.toString().equals("true")) {
            int cacheCount = dataSetDesign.getCacheRowCount();
            if (cacheCount == 0) {
                cacheCount = context.getCacheCount();
            }
            return DataSetCacheConfig.getInstacne(DataSetCacheConfig.DataSetCacheMode.IN_DISK, cacheCount, tempDir);
        }
        return null;
    }

    public static DataSetCacheConfig getDteDataSetCacheConfig(IEngineExecutionHints queryExecutionHints, IBaseDataSetDesign dataSetDesign, DataEngineSession session) throws DataException {
        if (queryExecutionHints == null || dataSetDesign == null) {
            return null;
        }
        if (queryExecutionHints.needCacheDataSet(dataSetDesign.getName())) {
            return DataSetCacheConfig.getInstacne(DataSetCacheConfig.DataSetCacheMode.IN_DISK, -1, session.getTempDir());
        }
        return null;
    }

    public static void deleteFile(String path) {
        if (path == null) {
            return;
        }
        DataSetCacheUtil.deleteFile(new File(path));
    }

    public static void deleteFile(File f) {
        if (f == null || !f.exists()) {
            return;
        }
        if (f.isFile()) {
            DataSetCacheUtil.safeDelete(f);
        } else {
            File[] childFiles = f.listFiles();
            if (childFiles != null) {
                File[] fileArray = childFiles;
                int n = childFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    DataSetCacheUtil.deleteFile(child);
                    ++n2;
                }
            }
            DataSetCacheUtil.safeDelete(f);
        }
    }

    private static void safeDelete(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    private static int getIntValueFromString(Object option) {
        return Integer.valueOf(option.toString());
    }
}

