/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSourceFactory;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.ISubQueryExecutor;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.SubqueryDataSetRuntime;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.mozilla.javascript.Scriptable;

class PreparedSubquery
implements IPreparedQueryService {
    private int groupLevel;
    private PreparedQuery preparedQuery;
    private IPreparedQueryService queryService;
    private DataEngineSession session;
    private boolean subQueryOnGroup;
    private static Logger logger = Logger.getLogger(PreparedSubquery.class.getName());

    PreparedSubquery(DataEngineSession session, DataEngineContext context, ISubqueryDefinition subquery, IPreparedQueryService queryService, int groupLevel) throws DataException {
        Object[] params = new Object[]{session, context, subquery, queryService, new Integer(groupLevel)};
        logger.entering(PreparedSubquery.class.getName(), "PreparedSubquery", params);
        this.groupLevel = groupLevel;
        this.queryService = queryService;
        this.subQueryOnGroup = subquery.applyOnGroup();
        logger.logp(Level.FINER, PreparedSubquery.class.getName(), "PreparedSubquery", "PreparedSubquery starts up.");
        this.session = session;
        this.preparedQuery = new PreparedQuery(session, context, subquery, this, null);
        logger.exiting(PreparedSubquery.class.getName(), "PreparedSubquery");
    }

    public PreparedDataSourceQuery getDataSourceQuery() {
        return this.queryService.getDataSourceQuery();
    }

    public IQueryResults execSubquery(IResultIterator iterator, IQueryExecutor parentExecutor, String subQueryName, Scriptable subScope) throws DataException {
        return this.preparedQuery.execSubquery(iterator, parentExecutor, subQueryName, subScope);
    }

    int getGroupLevel() {
        return this.groupLevel;
    }

    QueryResults execute(IResultIterator parentIterator, IQueryExecutor parentExecutor, Scriptable scope) throws DataException {
        logger.logp(Level.FINER, PreparedSubquery.class.getName(), "execute", "start to execute a PreparedSubquery.");
        try {
            QueryResults queryResults = this.preparedQuery.doPrepare(null, scope, new SubQueryExecutor(parentIterator, parentExecutor), this.getDataSourceQuery());
            return queryResults;
        }
        finally {
            logger.logp(Level.FINER, PreparedSubquery.class.getName(), "execute", "finish executing a PreparedSubquery.");
        }
    }

    private final class CustomDataSet
    implements ICustomDataSet {
        private IResultIterator resultIterator;
        private IResultClass resultClass;
        private boolean finished;

        CustomDataSet(IResultIterator resultIterator, IResultClass resultClass) {
            this.resultIterator = resultIterator;
            this.resultClass = resultClass;
        }

        public IResultClass getResultClass() {
            return this.resultClass;
        }

        public void open() throws DataException {
        }

        public IResultObject fetch() throws DataException {
            if (this.finished) {
                return null;
            }
            this.finished = true;
            return this.resultIterator.getCurrentResult();
        }

        public void close() throws DataException {
        }
    }

    private class SubQueryExecutor
    extends QueryExecutor
    implements ISubQueryExecutor {
        private IResultIterator parentIterator;
        private IQueryExecutor parentExecutor;

        public SubQueryExecutor(IResultIterator parentIterator, IQueryExecutor parentExecutor) {
            super(PreparedSubquery.this.preparedQuery.getSharedScope(), PreparedSubquery.this.preparedQuery.getBaseQueryDefn(), PreparedSubquery.this.preparedQuery.getAggrTable(), PreparedSubquery.this.session);
            this.parentIterator = parentIterator;
            this.parentExecutor = parentExecutor;
            this.setParentExecutorHelper(parentIterator.getExecutorHelper());
        }

        protected IDataSource createOdiDataSource() {
            return null;
        }

        protected DataSourceRuntime findDataSource() {
            return null;
        }

        protected DataSetRuntime newDataSetRuntime() {
            return new SubqueryDataSetRuntime(this, PreparedSubquery.this.session);
        }

        protected IQuery createOdiQuery() throws DataException {
            return DataSourceFactory.getFactory().getEmptyDataSource(PreparedSubquery.this.session).newCandidateQuery(false);
        }

        protected IResultIterator executeOdiQuery(IEventHandler eventHandler, StopSign stopSign) throws DataException {
            assert (this.parentIterator != null);
            IResultIterator ret = null;
            ICandidateQuery cdQuery = (ICandidateQuery)this.odiQuery;
            if (PreparedSubquery.this.subQueryOnGroup) {
                cdQuery.setCandidates(this.parentIterator, PreparedSubquery.this.groupLevel);
            } else {
                cdQuery.setCandidates(new CustomDataSet(this.parentIterator, this.getMergedResultClass()));
            }
            ret = cdQuery.execute(eventHandler, stopSign);
            return ret;
        }

        private IResultClass getMergedResultClass() throws DataException {
            IResultClass parentResultClass = this.parentIterator.getResultClass();
            ICandidateQuery candidateQuery = (ICandidateQuery)this.odiQuery;
            assert (candidateQuery != null);
            List computedColumns = this.dataSet.getComputedColumns();
            ArrayList<ResultFieldMetadata> columnsList = new ArrayList<ResultFieldMetadata>();
            int i = 0;
            while (i < parentResultClass.getFieldCount()) {
                ResultFieldMetadata columnMetaData = new ResultFieldMetadata(i + 1, parentResultClass.getFieldName(i + 1), parentResultClass.getFieldName(i + 1), parentResultClass.getFieldValueClass(i + 1), parentResultClass.getFieldNativeTypeName(i + 1), parentResultClass.isCustomField(i + 1));
                columnsList.add(columnMetaData);
                columnMetaData.setAlias(parentResultClass.getFieldAlias(i + 1));
                ++i;
            }
            int count = columnsList.size();
            Iterator it = computedColumns.iterator();
            int j = columnsList.size();
            while (it.hasNext()) {
                IComputedColumn compColumn = (IComputedColumn)it.next();
                ResultFieldMetadata columnMetaData = new ResultFieldMetadata(++count, compColumn.getName(), compColumn.getName(), DataType.getClass((int)compColumn.getDataType()), null, true);
                columnsList.add(columnMetaData);
                ++j;
            }
            return new ResultClass(columnsList);
        }

        public int getSubQueryStartingIndex() throws DataException {
            if (!PreparedSubquery.this.subQueryOnGroup) {
                return this.parentIterator.getCurrentResultIndex();
            }
            int groupIndex = this.parentIterator.getCurrentGroupIndex(PreparedSubquery.this.groupLevel);
            int[] groupStartingEndingIndex = this.parentIterator.getGroupStartAndEndIndex(PreparedSubquery.this.groupLevel);
            return this.parentExecutor instanceof ISubQueryExecutor ? ((ISubQueryExecutor)this.parentExecutor).getSubQueryStartingIndex() + groupStartingEndingIndex[groupIndex * 2] : groupStartingEndingIndex[groupIndex * 2];
        }
    }
}

