/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.BindingColumnsEvalUtil;
import org.eclipse.birt.data.engine.impl.IServiceForResultSet;
import org.eclipse.birt.data.engine.impl.LogUtil;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.ResultSetCacheUtil;
import org.eclipse.birt.data.engine.impl.RowIDUtil;
import org.eclipse.birt.data.engine.impl.document.IDInfo;
import org.eclipse.birt.data.engine.impl.document.IRDSave;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultIterator
implements IResultIterator {
    private RDSaveHelper rdSaveHelper;
    private Scriptable scope;
    protected org.eclipse.birt.data.engine.odi.IResultIterator odiResult;
    private IServiceForResultSet resultService;
    private GroupUtil groupUtil;
    protected RowIDUtil rowIDUtil;
    private int lastRowIndex = -1;
    private Map boundColumnValueMap = new HashMap();
    private BindingColumnsEvalUtil bindingColumnsEvalUtil;
    private int state = 0;
    private static final int NOT_STARTED = 0;
    private static final int BEFORE_FIRST_ROW = 1;
    private static final int ON_ROW = 2;
    private static final int AFTER_LAST_ROW = 3;
    private static final int CLOSED = -1;
    private boolean isFirstRowPepared = true;
    private OutputStream metaOutputStream = null;
    private DataOutputStream rowOutputStream = null;
    private static Logger logger = Logger.getLogger(ResultIterator.class.getName());
    private List columnList = null;
    private List preparedList = null;
    private int rawIdStartingValue = 0;
    private IShutdownListener listener;

    ResultIterator(IServiceForResultSet rService, org.eclipse.birt.data.engine.odi.IResultIterator odiResult, Scriptable scope, int rawIdStartingValue) throws DataException {
        Object[] params = new Object[]{rService, odiResult, scope};
        logger.entering(ResultIterator.class.getName(), "ResultIterator", params);
        assert (rService != null && rService.getQueryResults() != null && odiResult != null && scope != null);
        this.resultService = rService;
        this.odiResult = odiResult;
        this.scope = scope;
        this.rawIdStartingValue = rawIdStartingValue;
        if (rService.getSession().getEngineContext().getMode() == 1 || rService.getSession().getEngineContext().getMode() == 3) {
            this.validateManualBindingExpressions(this.resultService.getQueryDefn().getBindings());
        }
        if (this.needCache()) {
            try {
                this.createCacheOutputStream();
                this.saveMetaData();
                IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)this.odiResult.getRowCount());
            }
            catch (IOException iOException) {
                throw new DataException("data.engine.CreateCacheTempError");
            }
        }
        this.listener = new IShutdownListener(){

            public void dataEngineShutdown() {
                try {
                    ResultIterator.this.close();
                }
                catch (BirtException birtException) {}
            }
        };
        this.resultService.getSession().getEngine().addShutdownListener(this.listener);
        this.start();
        logger.exiting(ResultIterator.class.getName(), "ResultIterator");
    }

    private void createCacheOutputStream() throws FileNotFoundException {
        File tmpDir = new File(this.resultService.getSession().getTempDir());
        if (!tmpDir.exists() || !tmpDir.isDirectory()) {
            tmpDir.mkdirs();
        }
        this.metaOutputStream = new BufferedOutputStream(new FileOutputStream(ResultSetCacheUtil.getMetaFile(this.resultService.getSession().getTempDir(), this.resultService.getQueryResults().getID())), 1024);
        this.rowOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(ResultSetCacheUtil.getDataFile(this.resultService.getSession().getTempDir(), this.resultService.getQueryResults().getID())), 1024));
        File file = ResultSetCacheUtil.getDataFile(this.resultService.getSession().getTempDir(), this.resultService.getQueryResults().getID());
        file.deleteOnExit();
        file = ResultSetCacheUtil.getMetaFile(this.resultService.getSession().getTempDir(), this.resultService.getQueryResults().getID());
        file.deleteOnExit();
    }

    private void closeCacheOutputStream() throws DataException {
        try {
            if (this.rowOutputStream != null) {
                IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)-1);
                this.rowOutputStream.close();
                this.rowOutputStream = null;
            }
        }
        catch (IOException iOException) {
            throw new DataException("data.engine.CloseCacheTempError");
        }
    }

    private boolean needCache() {
        if (this.resultService == null || this.resultService.getQueryDefn() == null) {
            return false;
        }
        return this.resultService.getQueryDefn().cacheQueryResults();
    }

    private void saveMetaData() throws DataException, IOException {
        ArrayList<IBinding> metaMap = new ArrayList<IBinding>();
        ResultIterator.populateDataSetRowMapping(metaMap, this.odiResult.getResultClass());
        ((ResultClass)this.odiResult.getResultClass()).doSave(this.metaOutputStream, metaMap);
        if (this.metaOutputStream != null) {
            this.metaOutputStream.close();
            this.metaOutputStream = null;
        }
    }

    private static void populateDataSetRowMapping(List<IBinding> metaMap, IResultClass rsClass) throws DataException {
        int i = 0;
        while (i < rsClass.getFieldCount()) {
            Binding binding = new Binding(rsClass.getFieldName(i + 1));
            binding.setExpression(new org.eclipse.birt.data.engine.api.querydefn.ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)rsClass.getFieldName(i + 1))));
            metaMap.add(binding);
            ++i;
        }
    }

    private void validateManualBindingExpressions(Map exprs) throws DataException {
        Set validDataSetColumnNames = this.populateValidDataSetColumnNameSet();
        for (Object key : exprs.keySet()) {
            IBaseExpression expr = ((IBinding)exprs.get(key)).getExpression();
            List usedDataSetExprs = ExpressionCompilerUtil.extractDataSetColumnExpression(expr);
            int j = 0;
            while (j < usedDataSetExprs.size()) {
                if (!validDataSetColumnNames.contains(usedDataSetExprs.get(j)) && !usedDataSetExprs.get(j).equals("_rowPosition")) {
                    throw new DataException("data.engine.ColumnBindingReferToInexistColumn", new Object[]{key, usedDataSetExprs.get(j)});
                }
                ++j;
            }
        }
    }

    private Set populateValidDataSetColumnNameSet() throws DataException {
        HashSet<String> validDataSetColumnNames = new HashSet<String>();
        int i = 1;
        while (i <= this.odiResult.getResultClass().getFieldCount()) {
            validDataSetColumnNames.add(this.odiResult.getResultClass().getFieldName(i));
            validDataSetColumnNames.add(this.odiResult.getResultClass().getFieldAlias(i));
            ++i;
        }
        return validDataSetColumnNames;
    }

    @Override
    public Scriptable getScope() {
        return this.scope;
    }

    private void start() throws DataException {
        assert (this.state == 0);
        this.state = 1;
        this.getRdSaveHelper().doSaveStart();
    }

    private void checkStarted() throws DataException {
        if (this.state == 0 || this.state == -1) {
            DataException e = new DataException("data.engine.ResultClosed");
            logger.logp(Level.FINE, ResultIterator.class.getName(), "checkStarted", "ResultIterator has been closed.", (Throwable)((Object)e));
            throw e;
        }
    }

    @Override
    public IQueryResults getQueryResults() {
        return this.resultService.getQueryResults();
    }

    @Override
    public boolean next() throws BirtException {
        this.checkStarted();
        this.clear();
        if (this.isEmpty()) {
            if (this.isFirstRowPepared) {
                this.lastRowIndex = this.odiResult.getCurrentResultIndex() - 1;
                this.prepareCurrentRow();
                this.isFirstRowPepared = false;
            }
            return false;
        }
        boolean hasNext = false;
        if (this.state == 1) {
            this.state = 2;
            hasNext = this.odiResult.getCurrentResult() != null;
        } else {
            hasNext = this.hasNextRow();
        }
        if (hasNext) {
            this.prepareCurrentRow();
        }
        if (!hasNext) {
            this.state = 3;
        }
        return hasNext;
    }

    private void clear() {
        if (this.preparedList != null) {
            this.preparedList.clear();
        }
        this.boundColumnValueMap.clear();
    }

    private void saveCurrentRow() throws IOException, BirtException {
        if (this.isFirstRowPepared) {
            this.columnList = new ArrayList();
            for (Object key : this.boundColumnValueMap.keySet()) {
                this.columnList.add(key);
            }
            IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)this.columnList.size());
            int i = 0;
            while (i < this.columnList.size()) {
                IOUtil.writeObject((DataOutputStream)this.rowOutputStream, this.columnList.get(i));
                ++i;
            }
        }
        IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)this.getRowIndex());
        IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)this.getStartingGroupLevel());
        IOUtil.writeInt((OutputStream)this.rowOutputStream, (int)this.getEndingGroupLevel());
        int i = 0;
        while (i < this.columnList.size()) {
            IOUtil.writeObject((DataOutputStream)this.rowOutputStream, (Object)this.getValue((String)this.columnList.get(i)));
            ++i;
        }
    }

    protected boolean hasNextRow() throws DataException {
        return this.odiResult.next();
    }

    @Override
    public boolean isEmpty() throws DataException {
        return this.odiResult.getRowCount() == 0;
    }

    @Override
    public int getRowId() throws BirtException {
        this.checkStarted();
        if (this.rowIDUtil == null) {
            this.rowIDUtil = new RowIDUtil();
        }
        if (this.rowIDUtil.getMode(this.odiResult) == 1) {
            return this.odiResult.getCurrentResultIndex() + this.rawIdStartingValue;
        }
        IResultObject ob = this.odiResult.getCurrentResult();
        if (ob == null) {
            return -1;
        }
        return (Integer)ob.getFieldValue(this.rowIDUtil.getRowIdPos());
    }

    int getRawIdStartingValue() {
        return this.rawIdStartingValue;
    }

    @Override
    public int getRowIndex() throws BirtException {
        this.checkStarted();
        return this.odiResult.getCurrentResultIndex();
    }

    @Override
    public void moveTo(int rowIndex) throws BirtException {
        this.checkStarted();
        if (this.state == 1) {
            this.clear();
            this.prepareCurrentRow();
            this.state = 2;
        }
        int currRowIndex = this.odiResult.getCurrentResultIndex();
        if (rowIndex < 0 || rowIndex >= this.odiResult.getRowCount() && this.odiResult.getRowCount() != -1) {
            throw new DataException("data.engine.invalidRowIndex", new Integer(rowIndex));
        }
        if (rowIndex < currRowIndex) {
            throw new DataException("data.engine.backwardSeekError");
        }
        if (rowIndex == currRowIndex) {
            return;
        }
        int gapRows = rowIndex - currRowIndex;
        int i = 0;
        while (i < gapRows) {
            this.next();
            ++i;
        }
    }

    private RDSaveHelper getRdSaveHelper() throws DataException {
        if (this.rdSaveHelper == null) {
            IDInfo id = null;
            id = this.resultService.getQueryDefn() instanceof ISubqueryDefinition ? new IDInfo(null, this.resultService.getQueryDefn().getName()) : new IDInfo(this.resultService.getQueryResults().getID());
            this.rdSaveHelper = new RDSaveHelper(this.resultService.getSession().getEngineContext(), this.resultService.getQueryDefn(), this.odiResult, id);
        }
        return this.rdSaveHelper;
    }

    @Override
    public Object getValue(String exprName) throws BirtException {
        this.checkStarted();
        logger.logp(Level.FINER, ResultIterator.class.getName(), "getValue", "get of value binding column: " + LogUtil.toString(exprName));
        if (this.isFirstRowPepared) {
            if (this.isEmpty()) {
                this.next();
            } else {
                this.prepareCurrentRow();
            }
        }
        if (!this.boundColumnValueMap.containsKey(exprName)) {
            if (this.resultService.getBindingExpr(exprName) != null) {
                return this.prepareBindingColumn(exprName);
            }
            throw new DataException("data.engine.InvalidBoundColumnName", exprName);
        }
        Object exprValue = this.boundColumnValueMap.get(exprName);
        if (exprValue instanceof BirtException) {
            throw (BirtException)((Object)exprValue);
        }
        return exprValue;
    }

    private Object prepareBindingColumn(String exprName) throws DataException {
        assert (this.bindingColumnsEvalUtil != null);
        if (this.preparedList == null) {
            this.preparedList = new ArrayList();
        } else if (this.preparedList.contains(exprName)) {
            return new DataException("data.engine.ColumnBindingCycle", exprName);
        }
        this.preparedList.add(exprName);
        Object value = this.bindingColumnsEvalUtil.evaluateValue(exprName);
        this.boundColumnValueMap.put(exprName, value);
        return value;
    }

    private void prepareCurrentRow() throws DataException {
        int currRowIndex = this.odiResult.getCurrentResultIndex();
        this.prepareBindingColumnsEvalUtil();
        if (this.lastRowIndex < currRowIndex) {
            this.lastRowIndex = currRowIndex;
            this.bindingColumnsEvalUtil.getColumnsValue(this.boundColumnValueMap);
            if (this.needCache() && !this.isEmpty()) {
                try {
                    this.saveCurrentRow();
                }
                catch (IOException iOException) {
                    throw new DataException("data.engine.WriteCacheTempError");
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
            }
            this.isFirstRowPepared = false;
        }
    }

    protected void prepareBindingColumnsEvalUtil() throws DataException {
        if (this.bindingColumnsEvalUtil == null) {
            this.bindingColumnsEvalUtil = new BindingColumnsEvalUtil(this.odiResult, this.scope, this.resultService.getSession().getEngineContext().getScriptContext(), this.getRdSaveHelper(), this.resultService.getAllBindingExprs(), this.resultService.getAllAutoBindingExprs());
        }
    }

    @Override
    public Boolean getBoolean(String name) throws BirtException {
        return DataTypeUtil.toBoolean((Object)this.getValue(name));
    }

    @Override
    public Integer getInteger(String name) throws BirtException {
        return DataTypeUtil.toInteger((Object)this.getValue(name));
    }

    @Override
    public Double getDouble(String name) throws BirtException {
        return DataTypeUtil.toDouble((Object)this.getValue(name));
    }

    @Override
    public String getString(String name) throws BirtException {
        return DataTypeUtil.toString((Object)this.getValue(name));
    }

    @Override
    public BigDecimal getBigDecimal(String name) throws BirtException {
        return DataTypeUtil.toBigDecimal((Object)this.getValue(name));
    }

    @Override
    public Date getDate(String name) throws BirtException {
        return DataTypeUtil.toDate((Object)this.getValue(name));
    }

    @Override
    public Blob getBlob(String name) throws BirtException {
        return DataTypeUtil.toBlob((Object)this.getValue(name));
    }

    @Override
    public byte[] getBytes(String name) throws BirtException {
        return DataTypeUtil.toBytes((Object)this.getValue(name));
    }

    @Override
    public void skipToEnd(int groupLevel) throws BirtException {
        this.checkStarted();
        this.goThroughGapRows(groupLevel);
        logger.logp(Level.FINER, ResultIterator.class.getName(), "skipToEnd", "skipping rows to the last row in the current group");
    }

    protected void goThroughGapRows(int groupLevel) throws DataException, BirtException {
        while (groupLevel < this.odiResult.getEndingGroupLevel() && this.odiResult.getEndingGroupLevel() != 0 && this.odiResult.next()) {
            this.clear();
            this.prepareCurrentRow();
        }
    }

    @Override
    public int getStartingGroupLevel() throws DataException {
        return this.odiResult.getStartingGroupLevel();
    }

    @Override
    public int getEndingGroupLevel() throws DataException {
        return this.odiResult.getEndingGroupLevel();
    }

    @Override
    public IResultIterator getSecondaryIterator(String subQueryName, Scriptable subScope) throws DataException {
        IResultIterator resultIt;
        this.checkStarted();
        IQueryResults results = this.resultService.execSubquery(this.odiResult, subQueryName, subScope);
        logger.logp(Level.FINE, ResultIterator.class.getName(), "getSecondaryIterator", "Returns the secondary result specified by a SubQuery");
        try {
            resultIt = results.getResultIterator();
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        if (resultIt instanceof ResultIterator) {
            this.getRdSaveHelper().processForSubQuery(this.getQueryResults().getID(), (ResultIterator)resultIt, subQueryName);
        }
        return resultIt;
    }

    @Override
    public IResultMetaData getResultMetaData() throws DataException {
        try {
            ResultMetaData resultMetaData = new ResultMetaData(this.odiResult.getResultClass());
            return resultMetaData;
        }
        finally {
            logger.logp(Level.FINE, ResultIterator.class.getName(), "getResultMetaData", "Returns the result metadata");
        }
    }

    @Override
    public void close() throws BirtException {
        if (this.state == -1) {
            return;
        }
        this.resultService.getSession().getEngine().removeListener(this.listener);
        if (this.getRdSaveHelper().needsSaveToDoc()) {
            while (this.next()) {
            }
            this.getRdSaveHelper().doSaveFinish();
        }
        if (this.needCache() && !this.isEmpty()) {
            while (this.next()) {
            }
            this.closeCacheOutputStream();
        }
        if (this.odiResult != null) {
            this.odiResult.close();
        }
        this.odiResult = null;
        this.resultService = null;
        this.state = -1;
        logger.logp(Level.FINE, ResultIterator.class.getName(), "close", "a ResultIterator is closed");
    }

    public org.eclipse.birt.data.engine.odi.IResultIterator getOdiResult() {
        return this.odiResult;
    }

    @Override
    public boolean findGroup(Object[] groupKeyValues) throws BirtException {
        if (this.groupUtil == null) {
            this.groupUtil = new GroupUtil(this.resultService.getQueryDefn(), this);
        }
        return this.groupUtil.findGroup(groupKeyValues);
    }

    @Override
    public boolean isBeforeFirst() throws BirtException {
        return !this.isEmpty() && this.state == 1;
    }

    @Override
    public boolean isFirst() throws BirtException {
        return !this.isEmpty() && this.getRowIndex() == 0;
    }

    private class GroupUtil {
        private IBaseQueryDefinition queryDefn;
        private ResultIterator resultIterator;

        private GroupUtil(IBaseQueryDefinition queryDefn, ResultIterator resultIterator2) {
            this.queryDefn = queryDefn;
            this.resultIterator = resultIterator2;
        }

        public boolean findGroup(Object[] groupKeyValues) throws BirtException {
            org.eclipse.birt.data.engine.odi.IResultIterator odiResult = this.resultIterator.getOdiResult();
            List groups = this.queryDefn.getGroups();
            if (groupKeyValues.length > groups.size()) {
                throw new DataException("data.engine.incorrectGroupKeyValues");
            }
            GroupDefinition group = null;
            String[] columnNames = new String[groupKeyValues.length];
            int i = 0;
            while (i < columnNames.length) {
                group = (GroupDefinition)groups.get(i);
                columnNames[i] = this.getGroupKeyExpression(group);
                ++i;
            }
            odiResult.first(0);
            if (odiResult.getCurrentResult() == null) {
                return false;
            }
            block1: do {
                i = 0;
                while (i < columnNames.length) {
                    if (!this.groupKeyValuesEqual(odiResult, groupKeyValues, columnNames, i)) {
                        this.resultIterator.skipToEnd(i + 1);
                        continue block1;
                    }
                    if (i == columnNames.length - 1) {
                        return true;
                    }
                    ++i;
                }
            } while (odiResult.next());
            return false;
        }

        private boolean groupKeyValuesEqual(org.eclipse.birt.data.engine.odi.IResultIterator odiResult, Object[] groupKeyValues, String[] columnExprs, int i) throws BirtException {
            Object fieldValue = null;
            fieldValue = ScriptEvalUtil.evalExpr(new org.eclipse.birt.data.engine.api.querydefn.ScriptExpression(columnExprs[i]), ResultIterator.this.resultService.getSession().getEngineContext().getScriptContext(), ResultIterator.this.scope, ScriptExpression.defaultID, 0);
            boolean retValue = false;
            if (fieldValue == groupKeyValues[i]) {
                retValue = true;
            } else if (fieldValue != null && groupKeyValues[i] != null) {
                if (fieldValue.getClass().equals(groupKeyValues[i].getClass())) {
                    retValue = this.isTwoObjectEqual(fieldValue, groupKeyValues[i]);
                } else {
                    Object convertedOb = DataTypeUtil.convert((Object)groupKeyValues[i], fieldValue.getClass());
                    retValue = this.isTwoObjectEqual(fieldValue, convertedOb);
                }
            }
            return retValue;
        }

        private boolean isTwoObjectEqual(Object value1, Object value2) {
            if (value1 instanceof Date && value2 instanceof Date) {
                return ((Date)value1).getTime() == ((Date)value2).getTime();
            }
            return value1.equals(value2);
        }

        private String getGroupKeyExpression(GroupDefinition group) {
            String columnName = group.getKeyColumn() != null ? ExpressionUtil.createJSRowExpression((String)group.getKeyColumn()) : group.getKeyExpression();
            return columnName;
        }
    }

    class RDSaveHelper {
        private DataEngineContext context;
        private IBaseQueryDefinition queryDefn;
        private org.eclipse.birt.data.engine.odi.IResultIterator odiResult;
        private IDInfo idInfo;
        private IRDSave rdSave;
        private boolean isBasicSaved;

        RDSaveHelper(DataEngineContext context, IBaseQueryDefinition queryDefn, org.eclipse.birt.data.engine.odi.IResultIterator odiResult, IDInfo idInfo) {
            this.context = context;
            this.queryDefn = queryDefn;
            this.odiResult = odiResult;
            this.idInfo = idInfo;
        }

        void doSaveExpr(Map valueMap) throws DataException {
            this.doSave(valueMap, false);
        }

        void doSaveFinish() throws DataException {
            this.doSave(null, true);
        }

        void doSaveStart() throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            this.getRdSave().saveStart();
        }

        private void doSave(Map valueMap, boolean finish) throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            if (!this.isBasicSaved) {
                this.isBasicSaved = true;
                this.getRdSave().saveResultIterator(this.odiResult, this.idInfo.getGroupLevel(), this.idInfo.getSubQueryInfo());
            }
            if (!finish) {
                this.rdSave.saveExprValue(this.odiResult.getCurrentResultIndex(), valueMap);
            } else {
                this.rdSave.saveFinish(this.odiResult.getRowCount() - 1);
            }
        }

        private IRDSave getRdSave() throws DataException {
            if (this.rdSave == null) {
                this.rdSave = RDUtil.newSave(this.context, this.queryDefn, this.odiResult.getRowCount(), new QueryResultInfo(this.idInfo.getQueryResultID(), this.idInfo.getsubQueryName(), this.idInfo.getsubQueryIndex()));
            }
            return this.rdSave;
        }

        private boolean needsSaveToDoc() {
            if (ResultIterator.this.state == 0 || ResultIterator.this.state == -1) {
                return false;
            }
            if (this.context == null || this.context.getMode() == 3 || this.context.getMode() == 2) {
                return false;
            }
            return this.context.getDocWriter() != null;
        }

        private void processForSubQuery(String parentQueryID, ResultIterator resultIt, String subQueryName) throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            QueryResults results = (QueryResults)resultIt.getQueryResults();
            results.setID(this.idInfo.buildSubQueryID(parentQueryID));
            if (((ISubqueryDefinition)resultIt.resultService.getQueryDefn()).applyOnGroup()) {
                resultIt.rdSaveHelper = new RDSaveHelper(resultIt.resultService.getSession().getEngineContext(), resultIt.resultService.getQueryDefn(), resultIt.odiResult, new IDInfo(resultIt.getQueryResults().getID(), subQueryName, results.getGroupLevel(), this.odiResult.getCurrentGroupIndex(results.getGroupLevel()), this.odiResult.getGroupStartAndEndIndex(results.getGroupLevel())));
            } else {
                resultIt.rdSaveHelper = new RDSaveHelper(resultIt.resultService.getSession().getEngineContext(), resultIt.resultService.getQueryDefn(), resultIt.odiResult, new IDInfo(resultIt.getQueryResults().getID(), subQueryName, 1, this.odiResult.getCurrentResultIndex(), IDInfo.getSpecialSubQueryInfo(this.odiResult.getRowCount())));
            }
        }
    }
}

