/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.IComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObjectUtil;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.Traversalor;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.CubePosFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivision;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableAccessor;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.MeasureMap;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.SelectedSubDimension;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.util.filter.ICubePosFilter;
import org.eclipse.birt.data.engine.olap.util.filter.IJSMeasureFilterEvalHelper;

public class FactTableRowIterator
implements IFactTableRowIterator {
    private FactTable factTable;
    private MeasureInfo[] computedMeasureInfo;
    private MeasureInfo[] allMeasureInfo;
    private IDiskArray[] selectedPos;
    private int[] dimensionIndex;
    private int[] currentSubDim;
    private List[] selectedSubDim = null;
    private IDocumentObject currentSegment;
    private int[] currentPos;
    private Object[] currentMeasureValues;
    private MeasureMap currentMeasureMap;
    private Object[] currentComputedMeasureValues;
    private Traversalor traversalor;
    private StopSign stopSign;
    private int[][] selectedPosOfCurSegment;
    private IComputedMeasureHelper computedMeasureHelper;
    private List measureFilters;
    private List cubePosFilters;
    private static Logger logger = Logger.getLogger(FactTableRowIterator.class.getName());

    public FactTableRowIterator(FactTable factTable, String[] dimensionName, IDiskArray[] dimensionPos, StopSign stopSign) throws IOException {
        this(factTable, dimensionName, dimensionPos, null, stopSign);
    }

    public FactTableRowIterator(FactTable factTable, String[] dimensionName, IDiskArray[] dimensionPos, IComputedMeasureHelper computedMeasureHelper, StopSign stopSign) throws IOException {
        Object[] params = new Object[]{factTable, dimensionName, dimensionPos, stopSign};
        logger.entering(FactTableRowIterator.class.getName(), "FactTableRowIterator", params);
        this.factTable = factTable;
        this.selectedPos = dimensionPos;
        this.selectedSubDim = new List[factTable.getDimensionInfo().length];
        this.selectedPosOfCurSegment = new int[factTable.getDimensionInfo().length][];
        this.stopSign = stopSign;
        this.measureFilters = new ArrayList();
        this.cubePosFilters = new ArrayList();
        this.computedMeasureHelper = computedMeasureHelper;
        assert (dimensionName.length == dimensionPos.length);
        int i = 0;
        while (i < this.selectedSubDim.length) {
            this.selectedSubDim[i] = new ArrayList();
            ++i;
        }
        this.dimensionIndex = new int[factTable.getDimensionInfo().length];
        i = 0;
        while (i < this.dimensionIndex.length) {
            this.dimensionIndex[i] = -1;
            ++i;
        }
        i = 0;
        while (i < dimensionName.length) {
            this.dimensionIndex[factTable.getDimensionIndex((String)dimensionName[i])] = i;
            ++i;
        }
        this.filterSubDimension();
        this.currentPos = new int[factTable.getDimensionInfo().length];
        this.currentMeasureValues = new Object[factTable.getMeasureInfo().length];
        this.currentMeasureMap = new MeasureMap(this.factTable.getMeasureInfo());
        if (this.computedMeasureHelper != null) {
            this.computedMeasureInfo = this.computedMeasureHelper.getAllComputedMeasureInfos();
        }
        this.computeAllMeasureInfo();
        this.nextSegment();
        logger.exiting(FactTableRowIterator.class.getName(), "FactTableRowIterator");
    }

    private void filterSubDimension() throws IOException {
        DimensionDivision[] dimensionDivisions = this.factTable.getDimensionDivision();
        SelectedSubDimension selectedSubDimension = null;
        int[] selectedSubDimensionCount = new int[this.selectedSubDim.length];
        int i = 0;
        while (i < this.selectedSubDim.length) {
            int pointer = 0;
            int j = 0;
            while (j < dimensionDivisions[i].getRanges().length) {
                if (this.dimensionIndex[i] > -1) {
                    while (pointer < this.selectedPos[this.dimensionIndex[i]].size() && (Integer)this.selectedPos[this.dimensionIndex[i]].get(pointer) < dimensionDivisions[i].getRanges()[j].start) {
                        ++pointer;
                    }
                    if (pointer >= this.selectedPos[this.dimensionIndex[i]].size()) break;
                    if ((Integer)this.selectedPos[this.dimensionIndex[i]].get(pointer) <= dimensionDivisions[i].getRanges()[j].end) {
                        selectedSubDimension = new SelectedSubDimension();
                        selectedSubDimension.subDimensionIndex = j;
                        selectedSubDimension.start = pointer;
                        while (pointer < this.selectedPos[this.dimensionIndex[i]].size() && (Integer)this.selectedPos[this.dimensionIndex[i]].get(pointer) <= dimensionDivisions[i].getRanges()[j].end) {
                            ++pointer;
                        }
                        selectedSubDimension.end = pointer - 1;
                        this.selectedSubDim[i].add(selectedSubDimension);
                    }
                } else {
                    selectedSubDimension = new SelectedSubDimension();
                    selectedSubDimension.subDimensionIndex = j;
                    selectedSubDimension.start = -1;
                    selectedSubDimension.end = -1;
                    this.selectedSubDim[i].add(selectedSubDimension);
                }
                ++j;
            }
            selectedSubDimensionCount[i] = this.selectedSubDim[i].size();
            ++i;
        }
        this.traversalor = new Traversalor(selectedSubDimensionCount);
    }

    public boolean next() throws IOException, DataException {
        while (!this.stopSign.isStopped()) {
            block9: {
                if (this.currentSegment != null) break block9;
                return false;
            }
            try {
                Bytes combinedDimensionPosition = this.currentSegment.readBytes();
                this.currentPos = this.factTable.getCombinedPositionCalculator().calculateDimensionPosition(this.getSubDimensionIndex(), combinedDimensionPosition.bytesValue());
                int i = 0;
                while (i < this.currentMeasureValues.length) {
                    this.currentMeasureValues[i] = DocumentObjectUtil.readValue(this.currentSegment, this.factTable.getMeasureInfo()[i].getDataType());
                    ++i;
                }
                this.currentMeasureMap.setMeasureValue(this.currentMeasureValues);
                if (this.computedMeasureHelper != null) {
                    try {
                        this.currentComputedMeasureValues = this.computedMeasureHelper.computeMeasureValues(this.currentMeasureMap);
                    }
                    catch (DataException e) {
                        throw new DataException("data.olap.failComputeComputedMeasureValue", (Throwable)((Object)e));
                    }
                }
                if (!this.isSelectedRow()) continue;
                return true;
            }
            catch (EOFException eOFException) {
                break;
            }
        }
        if (this.stopSign.isStopped() || !this.nextSegment()) {
            return false;
        }
        return this.next();
    }

    public void close() throws DataException {
        if (this.computedMeasureHelper != null) {
            this.computedMeasureHelper.cleanUp();
        }
    }

    private int[] getSubDimensionIndex() {
        int[] result = new int[this.selectedSubDim.length];
        int i = 0;
        while (i < result.length) {
            result[i] = ((SelectedSubDimension)this.selectedSubDim[i].get((int)this.currentSubDim[i])).subDimensionIndex;
            ++i;
        }
        return result;
    }

    private boolean isSelectedRow() throws IOException, DataException {
        int i = 0;
        while (i < this.currentPos.length) {
            if (this.dimensionIndex[i] != -1 && Arrays.binarySearch(this.selectedPosOfCurSegment[i], this.currentPos[i]) < 0) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.cubePosFilters.size()) {
            if (!((CubePosFilterHelper)this.cubePosFilters.get(i)).getFilterResult(this.currentPos)) {
                return false;
            }
            ++i;
        }
        if (this.measureFilters != null) {
            i = 0;
            while (i < this.measureFilters.size()) {
                IJSMeasureFilterEvalHelper measureFilter = (IJSMeasureFilterEvalHelper)this.measureFilters.get(i);
                if (!measureFilter.evaluateFilter(this.currentMeasureMap)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean nextSegment() throws IOException {
        if (this.stopSign.isStopped()) {
            return false;
        }
        if (!this.traversalor.next()) {
            return false;
        }
        this.currentSubDim = this.traversalor.getIntArray();
        this.currentSegment = this.factTable.getDocumentManager().openDocumentObject(FactTableAccessor.FTSUDocumentObjectNamingUtil.getDocumentObjectName(NamingUtil.getFactTableName(this.factTable.getName()), this.getSubDimensionIndex()));
        int i = 0;
        while (i < this.dimensionIndex.length) {
            if (this.dimensionIndex[i] != -1) {
                SelectedSubDimension selectedSubDimension = (SelectedSubDimension)this.selectedSubDim[i].get(this.currentSubDim[i]);
                this.selectedPosOfCurSegment[i] = new int[selectedSubDimension.end - selectedSubDimension.start + 1];
                int j = 0;
                while (j < selectedSubDimension.end - selectedSubDimension.start + 1) {
                    this.selectedPosOfCurSegment[i][j] = (Integer)this.selectedPos[this.dimensionIndex[i]].get(selectedSubDimension.start + j);
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public int getDimensionCount() {
        return this.factTable.getDimensionInfo().length;
    }

    public int getDimensionIndex(String dimensionName) {
        return this.factTable.getDimensionIndex(dimensionName);
    }

    public int getMeasureIndex(String measureName) {
        int reValue = this.factTable.getMeasureIndex(measureName);
        if (reValue < 0 && this.computedMeasureInfo != null) {
            int i = 0;
            while (i < this.computedMeasureInfo.length) {
                if (measureName.equals(this.computedMeasureInfo[i].getMeasureName())) {
                    reValue = i + this.factTable.getMeasureInfo().length;
                    break;
                }
                ++i;
            }
        }
        return reValue;
    }

    public int getDimensionPosition(int dimensionIndex) {
        return this.currentPos[dimensionIndex];
    }

    public int getMeasureCount() {
        if (this.computedMeasureInfo != null) {
            return this.factTable.getMeasureInfo().length + this.computedMeasureInfo.length;
        }
        return this.factTable.getMeasureInfo().length;
    }

    public Object getMeasure(int measureIndex) {
        if (measureIndex < this.currentMeasureValues.length) {
            return this.currentMeasureValues[measureIndex];
        }
        if (this.currentComputedMeasureValues != null && measureIndex - this.currentMeasureValues.length < this.currentComputedMeasureValues.length) {
            return this.currentComputedMeasureValues[measureIndex - this.currentMeasureValues.length];
        }
        return null;
    }

    public MeasureInfo[] getMeasureInfos() {
        return this.allMeasureInfo;
    }

    public void addMeasureFilter(IJSMeasureFilterEvalHelper measureFilter) {
        this.measureFilters.add(measureFilter);
    }

    public void addCubePosFilter(ICubePosFilter cubePosFilter) {
        this.cubePosFilters.add(new CubePosFilterHelper(this.factTable, cubePosFilter));
    }

    private void computeAllMeasureInfo() {
        int len = this.factTable.getMeasureInfo().length;
        if (this.computedMeasureInfo != null) {
            len += this.computedMeasureInfo.length;
        }
        this.allMeasureInfo = new MeasureInfo[len];
        System.arraycopy(this.factTable.getMeasureInfo(), 0, this.allMeasureInfo, 0, this.factTable.getMeasureInfo().length);
        if (this.computedMeasureInfo != null) {
            System.arraycopy(this.computedMeasureInfo, 0, this.allMeasureInfo, this.factTable.getMeasureInfo().length, this.computedMeasureInfo.length);
        }
    }
}

