/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.driver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.cursor.IRowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessorService;
import org.eclipse.birt.data.engine.olap.cursor.SubRowDataAccessor;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.driver.DimensionAxis;
import org.eclipse.birt.data.engine.olap.query.view.BirtDimensionView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;

public class EdgeAxis {
    private DimensionAxis[] dimensionAxis;
    private IAggregationResultSet rs;
    private IRowDataAccessor dataAccessor;
    private List sortList = null;
    private boolean isCalculatedMember = false;

    public EdgeAxis(IAggregationResultSet resultSet, BirtEdgeView view, boolean isCalculatedMember) throws IOException {
        this(resultSet, view, null, isCalculatedMember);
    }

    public EdgeAxis(IAggregationResultSet resultSet, BirtEdgeView view, List sortList, boolean isCalculatedMember) throws IOException {
        this.rs = resultSet;
        this.sortList = sortList;
        this.isCalculatedMember = isCalculatedMember;
        this.populateDimensionAxis(resultSet, view);
        RowDataAccessorService service = new RowDataAccessorService(this.rs, this.dimensionAxis, view.getMirrorStartingLevel(), view.getPageEndingIndex());
        this.dataAccessor = new RowDataAccessor(service);
        int i = 0;
        while (i < this.dimensionAxis.length) {
            this.dimensionAxis[i].setEdgeInfo(this.dataAccessor);
            ++i;
        }
    }

    public EdgeAxis(IRowDataAccessor parent, BirtEdgeView view, List sortList, boolean isPage, int startingLevelIndex) throws IOException {
        this(parent.getDataAccessorService().getAggregationResultSet(), view, sortList, isPage);
        this.dataAccessor = new SubRowDataAccessor(parent.getDataAccessorService(), parent, startingLevelIndex);
        int i = 0;
        while (i < this.dimensionAxis.length) {
            this.dimensionAxis[i].setEdgeInfo(this.dataAccessor);
            ++i;
        }
    }

    private void populateDimensionAxis(IAggregationResultSet rs, BirtEdgeView view) throws IOException {
        ArrayList<DimensionAxis> dimensionAxisList = new ArrayList<DimensionAxis>();
        int mirrorStartLevel = view.getMirrorStartingLevel();
        int index = -1;
        int levelIndex = -1;
        if (!this.isCalculatedMember) {
            index = 0;
            levelIndex = 0;
            int i = 0;
            while (i < view.getDimensionViews().size()) {
                BirtDimensionView dv = (BirtDimensionView)view.getDimensionViews().get(i);
                Iterator levelIter = dv.getMemberSelection().iterator();
                while (levelIter.hasNext()) {
                    levelIter.next();
                    DimensionAxis axis = null;
                    axis = mirrorStartLevel != 0 && levelIndex >= mirrorStartLevel ? new DimensionAxis(this, rs, index, levelIndex, true, this.findAggregationSort(levelIndex)) : new DimensionAxis(this, rs, index, levelIndex);
                    ++index;
                    ++levelIndex;
                    dimensionAxisList.add(axis);
                }
                ++i;
            }
        } else if (this.isCalculatedMember) {
            DimensionAxis axis = new DimensionAxis(this, rs, index, 0);
            dimensionAxisList.add(axis);
        }
        this.dimensionAxis = new DimensionAxis[dimensionAxisList.size()];
        int i = 0;
        while (i < dimensionAxisList.size()) {
            this.dimensionAxis[i] = (DimensionAxis)dimensionAxisList.get(i);
            ++i;
        }
    }

    public void populateEdgeInfo(boolean isPage) throws OLAPException {
        if (this.dataAccessor != null) {
            try {
                this.dataAccessor.initialize(isPage);
            }
            catch (IOException e) {
                throw new OLAPException(e.getLocalizedMessage());
            }
        }
    }

    private AggrSortDefinition findAggregationSort(int levelIndex) {
        AggrSortDefinition aggrSortDefn = null;
        if (this.sortList != null) {
            DimLevel level = this.rs.getLevel(levelIndex);
            int i = 0;
            while (i < this.sortList.size()) {
                if (level.equals(aggrSortDefn.getTargetLevel())) {
                    aggrSortDefn = (AggrSortDefinition)this.sortList.get(i);
                    break;
                }
                ++i;
            }
        }
        return aggrSortDefn;
    }

    public IRowDataAccessor getRowDataAccessor() {
        return this.dataAccessor;
    }

    public DimensionAxis getDimensionAxis(int index) {
        return this.dimensionAxis[index];
    }

    public DimensionAxis[] getAllDimensionAxis() {
        return this.dimensionAxis;
    }

    public IAggregationResultSet getQueryResultSet() {
        return this.rs;
    }
}

