/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.script.IJavascriptContext;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSDataSources
extends ScriptableObject {
    private Map dataSources;
    private static Logger logger = Logger.getLogger(JSDataSources.class.getName());
    private static final long serialVersionUID = -3214290672302098993L;

    public JSDataSources(Map dataSourceMap) {
        logger.entering(JSDataSources.class.getName(), "JSDataSources");
        assert (dataSourceMap != null);
        this.dataSources = dataSourceMap;
        this.sealObject();
    }

    public String getClassName() {
        return "DataSources";
    }

    public Object get(String name, Scriptable start) {
        logger.entering(JSDataSources.class.getName(), "get", name);
        IJavascriptContext ds = (IJavascriptContext)this.dataSources.get(name);
        if (ds != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(JSDataSources.class.getName(), "get", ds.getScriptScope());
            }
            return ds.getScriptScope();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(JSDataSources.class.getName(), "get", super.get(name, start));
        }
        return super.get(name, start);
    }

    public Object[] getIds() {
        return this.dataSources.keySet().toArray(new String[0]);
    }

    public boolean has(String name, Scriptable start) {
        logger.entering(JSDataSources.class.getName(), "has", name);
        if (this.dataSources.containsKey(name)) {
            logger.exiting(JSDataSources.class.getName(), "has", new Boolean(true));
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(JSDataSources.class.getName(), "has", new Boolean(super.has(name, start)));
        }
        return super.has(name, start);
    }
}

