/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;

public class RomanList
extends List {
    protected boolean romanlower;
    private static final RomanDigit[] roman = new RomanDigit[]{new RomanDigit('m', 1000, false), new RomanDigit('d', 500, false), new RomanDigit('c', 100, true), new RomanDigit('l', 50, false), new RomanDigit('x', 10, true), new RomanDigit('v', 5, false), new RomanDigit('i', 1, true)};

    public RomanList(int n) {
        super(true, n);
    }

    public RomanList(boolean bl, int n) {
        super(true, n);
        this.romanlower = bl;
    }

    public void setRomanLower(boolean bl) {
        this.romanlower = bl;
    }

    public boolean isRomanLower() {
        return this.romanlower;
    }

    public boolean add(Object object) {
        if (object instanceof ListItem) {
            ListItem listItem = (ListItem)object;
            Chunk chunk = this.romanlower ? new Chunk(RomanList.toRomanLowerCase(this.first + this.list.size()), this.symbol.font()) : new Chunk(RomanList.toRomanUppercase(this.first + this.list.size()), this.symbol.font());
            chunk.append(".");
            listItem.setListSymbol(chunk);
            listItem.setIndentationLeft(this.symbolIndent);
            listItem.setIndentationRight(0.0f);
            this.list.add(listItem);
        } else {
            if (object instanceof List) {
                List list = (List)object;
                list.setIndentationLeft(list.indentationLeft() + this.symbolIndent);
                --this.first;
                return this.list.add(list);
            }
            if (object instanceof String) {
                return this.add(new ListItem((String)object));
            }
        }
        return false;
    }

    public static String toRoman(int n) {
        return RomanList.toRomanLowerCase(n);
    }

    public static String toRomanUppercase(int n) {
        return RomanList.toRomanLowerCase(n).toUpperCase();
    }

    public static String toRomanLowerCase(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            stringBuffer.append('-');
            n = -n;
        }
        if (n > 3000) {
            stringBuffer.append('|');
            stringBuffer.append(RomanList.toRomanLowerCase(n / 1000));
            stringBuffer.append('|');
            n -= n / 1000 * 1000;
        }
        int n2 = 0;
        while (true) {
            RomanDigit romanDigit = roman[n2];
            while (n >= romanDigit.value) {
                stringBuffer.append(romanDigit.digit);
                n -= romanDigit.value;
            }
            if (n <= 0) break;
            int n3 = n2;
            while (!RomanList.roman[++n3].pre) {
            }
            if (n + RomanList.roman[n3].value >= romanDigit.value) {
                stringBuffer.append(RomanList.roman[n3].digit).append(romanDigit.digit);
                n -= romanDigit.value - RomanList.roman[n3].value;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static class RomanDigit {
        public char digit;
        public int value;
        public boolean pre;

        RomanDigit(char c, int n, boolean bl) {
            this.digit = c;
            this.value = n;
            this.pre = bl;
        }
    }
}

