/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;

public class EmbeddedImage
extends ReferencableStructure {
    public static final String EMBEDDED_IMAGE_STRUCT = "EmbeddedImage";
    public static final String NAME_MEMBER = "name";
    public static final String TYPE_MEMBER = "type";
    public static final String DATA_MEMBER = "data";
    public static final String CHARSET = "8859_1";
    protected String name = null;
    protected String type = null;
    protected String data = null;

    public EmbeddedImage() {
    }

    public EmbeddedImage(String name) {
        this.name = name;
    }

    public EmbeddedImage(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public String getStructName() {
        return EMBEDDED_IMAGE_STRUCT;
    }

    protected Object getIntrinsicProperty(String propName) {
        if (NAME_MEMBER.equals(propName)) {
            return this.name;
        }
        if (TYPE_MEMBER.equals(propName)) {
            return this.type;
        }
        if (DATA_MEMBER.equals(propName)) {
            return this.data;
        }
        return super.getIntrinsicProperty(propName);
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if (NAME_MEMBER.equalsIgnoreCase(propName)) {
            this.name = (String)value;
        } else if (TYPE_MEMBER.equalsIgnoreCase(propName)) {
            this.type = (String)value;
        } else if (DATA_MEMBER.equalsIgnoreCase(propName)) {
            this.data = (String)value;
        } else {
            super.setIntrinsicProperty(propName, value);
        }
    }

    public String getName() {
        return (String)this.getProperty(null, NAME_MEMBER);
    }

    public void setName(String name) {
        this.setProperty(NAME_MEMBER, (Object)name);
    }

    public String getType(Module module) {
        return (String)this.getProperty(module, TYPE_MEMBER);
    }

    public void setType(String type) {
        this.setProperty(TYPE_MEMBER, (Object)type);
    }

    public byte[] getData(Module module) {
        String dataValue = (String)this.getProperty(module, DATA_MEMBER);
        if (dataValue == null) {
            return null;
        }
        try {
            return dataValue.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return null;
        }
    }

    public void setData(byte[] data) {
        block3: {
            if (data == null) {
                return;
            }
            try {
                this.data = new String(data, CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.data = null;
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new EmbeddedImageHandle(valueHandle, index);
    }

    public List validate(Module module, DesignElement element) {
        List list = super.validate(module, element);
        if (StringUtil.isBlank(this.name)) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(NAME_MEMBER), (Object)this.name, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        if (this.getData(module) == null) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(DATA_MEMBER), (Object)this.data, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }

    public boolean isReferencableProperty(String memberName) {
        return NAME_MEMBER.equalsIgnoreCase(memberName);
    }

    public String getReferencableProperty() {
        return this.name;
    }
}

