/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class DataColumnNameValidator
extends AbstractElementValidator {
    private static DataColumnNameValidator instance = new DataColumnNameValidator();

    public static DataColumnNameValidator getInstance() {
        return instance;
    }

    private DataColumnNameValidator() {
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof DataItem)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, (DataItem)element);
    }

    private List doValidate(Module module, DataItem toValidate) {
        ArrayList<SemanticError> list = new ArrayList<SemanticError>();
        String columnName = (String)toValidate.getLocalProperty(module, "resultSetColumn");
        if (columnName == null) {
            return list;
        }
        if (!DataColumnNameValidator.hasCorrespondingColumnBinding(module, toValidate, columnName)) {
            list.add(new SemanticError((DesignElement)toValidate, new String[]{columnName}, "Error.SemanticError.MISSING_COLUMN_BINDING"));
        }
        return list;
    }

    private static boolean hasCorrespondingColumnBinding(Module module, DesignElement target, String columnBindingName) {
        if (DataColumnNameValidator.isTemplateParameterDefinition(target)) {
            return true;
        }
        List columns = null;
        columns = (List)target.getProperty(module, "boundDataColumns");
        if (DataColumnNameValidator.exists(columns, columnBindingName)) {
            return true;
        }
        if (target.getProperty(module, "dataSet") != null || target.getProperty(module, "cube") != null) {
            return false;
        }
        DesignElement container = target.getContainer();
        while (container != null) {
            if (DataColumnNameValidator.isDataContainer(container)) {
                columns = (List)container.getProperty(module, "boundDataColumns");
                if (DataColumnNameValidator.exists(columns, columnBindingName)) {
                    return true;
                }
                if (container.getProperty(module, "dataSet") != null || container.getProperty(module, "cube") != null) break;
            }
            container = container.getContainer();
        }
        return false;
    }

    private static boolean isDataContainer(DesignElement element) {
        return element instanceof ListingElement || element instanceof GridItem || element instanceof ExtendedItem;
    }

    private static boolean exists(List columns, String columnName) {
        return DataColumnNameValidator.getColumn(columns, columnName) != null;
    }

    public static ComputedColumn getColumn(List columns, String name) {
        if (columns == null || columns.size() == 0 || name == null) {
            return null;
        }
        int i = 0;
        while (i < columns.size()) {
            ComputedColumn column = (ComputedColumn)columns.get(i);
            if (name.equals(column.getName())) {
                return column;
            }
            ++i;
        }
        return null;
    }
}

