/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class MemberRecord
extends SimpleRecord {
    protected DesignElement element;
    protected Module module;
    protected MemberRef memberRef;
    protected Structure structure;
    protected Object newValue;
    protected Object oldValue;

    public MemberRecord(Module module, DesignElement obj, MemberRef ref, Object value) {
        this.element = obj;
        this.memberRef = ref;
        this.newValue = value;
        assert (module != null);
        this.structure = this.memberRef.getStructure(module, this.element);
        this.oldValue = this.memberRef.getLocalValue(module, this.element);
        this.label = CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{this.memberRef.getPropDefn().getDisplayName()});
    }

    protected void perform(boolean undo) {
        PropertyDefn prop = this.memberRef.getMemberDefn();
        if (this.structure != null) {
            Object value = null;
            Object tmpOldValue = null;
            if (!undo) {
                value = this.newValue;
                tmpOldValue = this.oldValue;
            } else {
                value = this.oldValue;
                tmpOldValue = this.newValue;
            }
            StructureContext context = new StructureContext(this.structure, prop.getName());
            if (tmpOldValue instanceof Structure) {
                context.remove((Structure)tmpOldValue);
            }
            if (value instanceof Structure) {
                context.add((Structure)value);
            } else {
                this.structure.setProperty(prop, value);
            }
        }
    }

    public DesignElement getTarget() {
        return this.element;
    }

    public NotificationEvent getEvent() {
        return new PropertyEvent(this.element, this.memberRef.getPropDefn().getName());
    }

    protected List getPostTasks() {
        ArrayList<NotificationRecordTask> retList = new ArrayList<NotificationRecordTask>();
        retList.addAll(super.getPostTasks());
        NotificationEvent ev = this.getEvent();
        retList.add(new NotificationRecordTask(this.element, ev));
        if (this.structure != null && this.structure.isReferencable()) {
            ReferencableStructure refValue = (ReferencableStructure)this.structure;
            retList.add(new NotificationRecordTask(refValue, ev));
        }
        return retList;
    }
}

