/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.StyleEvent;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStyledElement;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class ReferenceableElementAdapter
implements IReferencableElement,
Cloneable {
    protected ArrayList clients = new ArrayList();
    private DesignElement element;

    public ReferenceableElementAdapter(ReferenceableElement element) {
        this.element = element;
    }

    public ReferenceableElementAdapter(ReferencableStyledElement element) {
        this.element = element;
    }

    public Object clone() throws CloneNotSupportedException {
        ReferenceableElementAdapter adapter = (ReferenceableElementAdapter)super.clone();
        adapter.clients = new ArrayList();
        return adapter;
    }

    public void addClient(DesignElement client, String propName) {
        this.clients.add(new BackRef(client, propName));
    }

    public void dropClient(DesignElement client) {
        this.dropClient(client, null);
    }

    public void dropClient(DesignElement client, String propName) {
        int i = 0;
        while (i < this.clients.size()) {
            BackRef ref = (BackRef)this.clients.get(i);
            if (ref.getElement() == client && (propName == null || ref.getPropertyName().equals(propName))) {
                this.clients.remove(i);
                return;
            }
            ++i;
        }
        assert (false);
    }

    public List getClientList() {
        return new ArrayList(this.clients);
    }

    public boolean hasReferences() {
        return !this.clients.isEmpty();
    }

    protected void broadcastToClients(NotificationEvent ev, Module module) {
        int i = 0;
        while (i < this.clients.size()) {
            BackRef ref = (BackRef)this.clients.get(i);
            DesignElement target = ref.getElement();
            if ("extends".equalsIgnoreCase(ref.getPropertyName())) {
                ev.setDeliveryPath(2);
            } else if ("style".equalsIgnoreCase(ref.getPropertyName())) {
                ev.setDeliveryPath(2);
            } else {
                ev.setDeliveryPath(4);
            }
            target.broadcast(ev, module);
            ++i;
        }
    }

    public void updateClientReferences() {
        for (BackRef ref : new ArrayList(this.clients)) {
            DesignElement client = ref.getElement();
            Module root = client.getRoot();
            Structure struct = ref.getStructure();
            Object value = null;
            value = struct != null ? struct.getContext().getLocalValue(root) : client.getLocalProperty(root, ref.getPropertyName());
            if (value instanceof ElementRefValue) {
                ElementRefValue refValue = (ElementRefValue)value;
                refValue.unresolved(refValue.getName());
                this.dropClient(client);
            } else if (value instanceof List) {
                List valueList = (List)value;
                int i = 0;
                while (i < valueList.size()) {
                    ElementRefValue item = (ElementRefValue)valueList.get(i);
                    if (item.getElement() == this.element) {
                        item.unresolved(item.getName());
                        this.dropClient(client);
                    }
                    ++i;
                }
            }
            if ("style".equalsIgnoreCase(ref.getPropertyName())) {
                client.broadcast(new StyleEvent(client));
                continue;
            }
            client.resolveElementReference(root, client.getPropertyDefn(ref.getPropertyName()));
        }
    }

    public void clearClients() {
        this.clients = new ArrayList();
    }

    public void addClient(Structure struct, String memberName) {
        this.clients.add(new BackRef(struct, memberName));
    }

    public void dropClient(Structure struct, String memberName) {
        int i = 0;
        while (i < this.clients.size()) {
            BackRef ref = (BackRef)this.clients.get(i);
            if (ref.getStructure() == struct && ref.getPropertyName().equalsIgnoreCase(memberName)) {
                this.clients.remove(i);
                return;
            }
            ++i;
        }
        assert (false);
    }
}

